/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.execute.ExecuteInputStreamHandler;
import org.apache.commons.execute.StreamPumper;

public class ExecutePumpInputStreamHandler
implements ExecuteInputStreamHandler {
    public static final long DEFAULT_JOIN_TIMEOUT = 5000L;
    private Thread outThread = null;
    private InputStream in = null;
    private OutputStream out = null;
    private long joinTimeout = 5000L;

    public ExecutePumpInputStreamHandler(InputStream in) {
        this(in, 5000L);
    }

    public ExecutePumpInputStreamHandler(InputStream in, long joinTimeout) {
        this.in = in;
        this.joinTimeout = joinTimeout;
    }

    public void setInputStream(OutputStream out) throws IOException {
        this.out = out;
        this.outThread = new Thread(new StreamPumper(this.in, out));
        this.outThread.setDaemon(true);
    }

    public void start() throws IOException {
        this.outThread.start();
    }

    public void stop() {
        try {
            if (this.joinTimeout < 0L) {
                this.outThread.join();
            } else {
                this.outThread.join(this.joinTimeout);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public void setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
    }
}

