/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.execute.ExecuteOutputStreamHandler;
import org.apache.commons.execute.StreamPumper;

public class ExecutePumpOutputStreamHandler
implements ExecuteOutputStreamHandler {
    public static final long DEFAULT_JOIN_TIMEOUT = 5000L;
    private Thread outThread = null;
    private OutputStream out = null;
    private long joinTimeout = 5000L;

    public ExecutePumpOutputStreamHandler(OutputStream out) {
        this(out, 5000L);
    }

    public ExecutePumpOutputStreamHandler(OutputStream out, long joinTimeout) {
        this.out = out;
        this.joinTimeout = joinTimeout;
    }

    public void setOutputStream(InputStream is) throws IOException {
        this.outThread = new Thread(new StreamPumper(is, this.out));
        this.outThread.setDaemon(true);
    }

    public void start() throws IOException {
        this.outThread.start();
    }

    public void stop() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.joinTimeout < 0L) {
                this.outThread.join();
            } else {
                this.outThread.join(this.joinTimeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public void setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
    }
}

