/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import org.apache.commons.execute.ExecuteException;
import org.apache.commons.execute.TimeoutObserver;
import org.apache.commons.execute.Watchdog;

public class ExecuteWatchdog
implements TimeoutObserver {
    private Process process;
    private boolean watch = false;
    private Exception caught = null;
    private boolean killedProcess = false;
    private Watchdog watchdog;

    public ExecuteWatchdog(long timeout) {
        this.watchdog = new Watchdog(timeout);
        this.watchdog.addTimeoutObserver(this);
    }

    public ExecuteWatchdog(int timeout) {
        this((long)timeout);
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.watchdog.stop();
        this.watch = false;
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutOccured(Watchdog w) {
        try {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
        }
        finally {
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public void checkException() throws ExecuteException {
        if (this.caught != null) {
            throw new ExecuteException("Exception in ExecuteWatchdog.run: " + this.caught.getMessage(), this.caught);
        }
    }

    public boolean isWatching() {
        return this.watch;
    }

    public boolean killedProcess() {
        return this.killedProcess;
    }
}

