/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogFilterInputStream
extends FilterInputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Logger log = null;
    private Priority priority = Priority.INFO;

    public LogFilterInputStream(Logger log, Priority priority, InputStream in) {
        super(in);
        this.log = log;
        this.priority = priority;
    }

    public int read() throws IOException {
        int o = super.read();
        byte c = (byte)o;
        if (c == 10) {
            this.flushBuffer();
        } else {
            this.buffer.write(o);
        }
        return o;
    }

    public int read(byte[] b) throws IOException {
        int o = super.read(b);
        for (int i = 0; i < o; ++i) {
            if (b[i] == 10) {
                this.flushBuffer();
                continue;
            }
            this.buffer.write(o);
        }
        return o;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int o = super.read(b, off, len);
        for (int i = off; i < o; ++i) {
            if (b[i] == 10) {
                this.flushBuffer();
                continue;
            }
            this.buffer.write(o);
        }
        return o;
    }

    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.flushBuffer();
        }
        super.close();
    }

    public Priority getLogPriority() {
        return this.priority;
    }

    protected void flushBuffer() {
        this.log.log(this.priority, (Object)this.buffer.toString());
        this.buffer.reset();
    }
}

