/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogFilterOutputStream
extends FilterOutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Logger log = null;
    private Priority priority = Priority.INFO;

    public LogFilterOutputStream(Logger log, Priority priority, OutputStream out) {
        super(out);
        this.log = log;
        this.priority = priority;
    }

    public void write(int i) throws IOException {
        byte c = (byte)i;
        if (c == 10) {
            this.flushBuffer();
        } else {
            this.buffer.write(i);
        }
        super.write(i);
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 10) {
                this.flushBuffer();
                continue;
            }
            this.buffer.write(b[i]);
        }
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            if (b[i] == 10) {
                this.flushBuffer();
                continue;
            }
            this.buffer.write(b[i]);
        }
        super.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.flushBuffer();
        }
        super.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public Priority getLogPriority() {
        return this.priority;
    }

    protected void flushBuffer() {
        if (this.log != null) {
            this.log.log(this.priority, (Object)this.buffer.toString());
        }
        this.buffer.reset();
    }
}

