/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogOutputStream
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Logger log = null;
    private Priority priority = Priority.INFO;

    public LogOutputStream(Logger log, Priority priority) {
        this.log = log;
        this.priority = priority;
    }

    public void write(int i) throws IOException {
        byte c = (byte)i;
        if (c != 13) {
            if (c == 10) {
                this.flushBuffer();
            } else {
                this.buffer.write(i);
            }
        }
    }

    protected void flushBuffer() {
        if (this.log != null) {
            this.log.log(this.priority, (Object)this.buffer.toString());
        }
        this.buffer.reset();
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.flushBuffer();
        }
        super.close();
    }

    public Priority getLogPriority() {
        return this.priority;
    }
}

