/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.execute.ExecuteStreamHandler;
import org.apache.commons.execute.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    public static final long DEFAULT_JOIN_TIMEOUT = 5000L;
    private Thread inputThread;
    private Thread errorThread;
    private OutputStream out;
    private OutputStream err;
    private long joinTimeout = 5000L;

    public PumpStreamHandler(OutputStream out, OutputStream err, long joinTimeout) {
        this.out = out;
        this.err = err;
        this.joinTimeout = joinTimeout;
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, 5000L);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void setProcessErrorStream(InputStream is) {
        this.createProcessErrorPump(is, this.err);
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public void setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
    }

    public void start() {
        this.inputThread.start();
        this.errorThread.start();
    }

    public void stop() {
        try {
            if (this.joinTimeout < 0L) {
                this.inputThread.join();
            } else {
                this.inputThread.join(this.joinTimeout);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (this.joinTimeout < 0L) {
                this.errorThread.join();
            } else {
                this.errorThread.join(this.joinTimeout);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.inputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        Thread result = new Thread(new StreamPumper(is, os));
        result.setDaemon(true);
        return result;
    }
}

