/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private static final int SLEEP = 25;
    private static final int SIZE = 4096;
    private InputStream is;
    private OutputStream os;
    private boolean finished;
    private boolean keepReading = true;

    public StreamPumper(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
    }

    public void stopPumping() {
        this.keepReading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        StreamPumper streamPumper;
        StreamPumper streamPumper2 = this;
        synchronized (streamPumper2) {
            this.finished = false;
        }
        byte[] buf = new byte[4096];
        try {
            try {
                int length;
                while (this.keepReading && (length = this.is.read(buf)) > 0) {
                    this.os.write(buf, 0, length);
                }
                Object var5_3 = null;
                streamPumper = this;
            }
            catch (IOException iOException) {
                Object var5_4 = null;
                StreamPumper streamPumper3 = this;
                synchronized (streamPumper3) {
                    this.finished = true;
                    this.notify();
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StreamPumper streamPumper4 = this;
            synchronized (streamPumper4) {
                this.finished = true;
                this.notify();
                throw throwable;
            }
        }
        synchronized (streamPumper) {
            this.finished = true;
            this.notify();
            return;
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

