/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.ObjectPool;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Category;

public class ThreadPool
extends ObjectPool {
    protected static Category log = Category.getInstance((String)(class$com$urbancode$commons$util$ThreadPool == null ? (class$com$urbancode$commons$util$ThreadPool = ThreadPool.class$("com.urbancode.commons.util.ThreadPool")) : class$com$urbancode$commons$util$ThreadPool).getName());
    private String name = "ThreadPool";
    private int threadId = 0;
    private Set threadSet = new HashSet();
    static /* synthetic */ Class class$com$urbancode$commons$util$ThreadPool;

    public ThreadPool() {
    }

    public ThreadPool(String name, int maxThreadCount, int minThreadCount, int cleanUpInterval, int expirationTime) {
        super(maxThreadCount, minThreadCount, cleanUpInterval, expirationTime);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void run(Runnable job) {
        log.debug((Object)("ThreadPool requested to run job: " + job));
        if (!this.isInitialized()) {
            throw new IllegalStateException("ThreadPool not running.");
        }
        if (job == null) {
            throw new IllegalArgumentException("Job can not be null.");
        }
        WorkerThread worker = (WorkerThread)this.checkOut();
        worker.run(job);
    }

    protected Object getNewInstance() {
        WorkerThread wt = new WorkerThread(this.name + "-" + this.threadId++, this);
        wt.start();
        return wt;
    }

    protected void expire(Object o) throws Exception {
        WorkerThread worker = (WorkerThread)o;
        worker.shutdown();
    }

    protected boolean isObjectValid(Object o) throws Exception {
        WorkerThread worker = (WorkerThread)o;
        return worker.isAlive() && !worker.isInterrupted() && worker.isValid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WorkerThread
    extends Thread {
        private boolean isTerminated = false;
        private Runnable job = null;
        private ThreadPool threadPool = null;
        private boolean isValid = true;

        WorkerThread(String name, ThreadPool threadPool) {
            super(name);
            this.threadPool = threadPool;
        }

        public void run() {
            while (!this.isTerminated) {
                try {
                    Object var4_5;
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (this.job == null) {
                            log.debug((Object)"WorkerThread job is null, waiting.");
                            this.wait();
                        }
                    }
                    log.debug((Object)("WorkerThread got job: " + this.job));
                    try {
                        try {
                            this.job.run();
                        }
                        catch (Throwable t) {
                            this.isValid = false;
                            log.error((Object)t.getMessage(), t);
                            var4_5 = null;
                            this.job = null;
                            this.threadPool.checkIn(this);
                            continue;
                        }
                        var4_5 = null;
                        this.job = null;
                        this.threadPool.checkIn(this);
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        this.job = null;
                        this.threadPool.checkIn(this);
                        throw throwable;
                    }
                }
                catch (InterruptedException ie) {
                    log.error((Object)ie.getMessage(), (Throwable)ie);
                }
            }
        }

        protected void run(Runnable job) {
            log.debug((Object)("WorkerThread requested to run job: " + job));
            if (job == null) {
                throw new IllegalArgumentException("Job is null.");
            }
            this.job = job;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.notify();
            }
        }

        protected synchronized void shutdown() {
            this.isTerminated = true;
        }
    }
}

