/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet;

import com.urbancode.pagelet.PageletClassLoader;
import com.urbancode.pagelet.PageletCompiler;
import com.urbancode.pagelet.PageletException;
import com.urbancode.pagelet.PageletFactory;
import com.urbancode.pagelet.Template;
import com.urbancode.pagelet.parser.PageletParser;
import com.urbancode.pagelet.parser.PageletTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Pagelet {
    public static final String PAGELET_HOME = "pagelet.home";
    public static final String PAGELET_WORK = "pagelet.work";
    public static final String DEFAULT_WORK_DIR = "work";
    protected File templateFile;
    protected String templateFileIndex;
    protected File sourceFile;
    protected File classFile;
    protected String packageName;
    protected String className;
    protected Template template;
    protected PageletFactory factory;

    protected Pagelet(File templateFile, File sourceFile, File classFile, String packageName, String className, PageletFactory factory) throws PageletException {
        this.templateFile = templateFile;
        this.sourceFile = sourceFile;
        this.classFile = classFile;
        this.packageName = packageName;
        this.className = className;
        this.factory = factory;
    }

    protected Pagelet(File templateFile, String templateFileIndex, File sourceFile, File classFile, String packageName, String className, PageletFactory factory) throws PageletException {
        this.templateFile = templateFile;
        this.templateFileIndex = templateFileIndex;
        this.sourceFile = sourceFile;
        this.classFile = classFile;
        this.packageName = packageName;
        this.className = className;
        this.factory = factory;
    }

    public String service(Map context) throws PageletException {
        StringWriter out = new StringWriter();
        this.service(context, out);
        return out.toString();
    }

    public void service(Map context, OutputStream os) throws PageletException {
        this.service(context, new OutputStreamWriter(os));
    }

    public void service(Map context, Writer os) throws PageletException {
        if (!context.containsKey(PageletFactory.PAGELET_FACTORY_CONTEXT_KEY)) {
            context.put(PageletFactory.PAGELET_FACTORY_CONTEXT_KEY, this.factory);
        }
        if (this.template == null) {
            this.compile();
            this.loadClass();
        } else if (this.templateFile != null && this.templateFile.exists() && this.templateFile.lastModified() > this.classFile.lastModified()) {
            this.compile();
            this.loadClass();
        }
        try {
            this.template.service(context, os);
        }
        catch (Throwable t) {
            throw new PageletException(t);
        }
    }

    public void compile() throws PageletException {
        if (this.template == null) {
            if (this.classFile.exists()) {
                if (this.templateFile != null && this.templateFile.exists() && this.templateFile.lastModified() > this.classFile.lastModified()) {
                    this.generateSourceFile();
                    PageletCompiler.compile(this.sourceFile, this.factory.getConfig().getCompileCommand(), this.factory.getConfig().getClasspath());
                }
            } else {
                this.generateSourceFile();
                PageletCompiler.compile(this.sourceFile, this.factory.getConfig().getCompileCommand(), this.factory.getConfig().getClasspath());
            }
        } else if (this.templateFile != null && this.templateFile.exists() && this.templateFile.lastModified() > this.classFile.lastModified()) {
            this.generateSourceFile();
            PageletCompiler.compile(this.sourceFile, this.factory.getConfig().getCompileCommand(), this.factory.getConfig().getClasspath());
        }
    }

    private void generateSourceFile() throws PageletException {
        BufferedInputStream in = null;
        PrintWriter out = null;
        try {
            if (this.templateFileIndex != null) {
                ZipFile zipFile = new ZipFile(this.templateFile);
                ZipEntry zipEntry = zipFile.getEntry(this.templateFileIndex);
                in = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            } else {
                in = new BufferedInputStream(new FileInputStream(this.templateFile));
            }
            File sourceFileDir = this.sourceFile.getParentFile();
            if (!sourceFileDir.exists()) {
                sourceFileDir.mkdirs();
            }
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.sourceFile))));
        }
        catch (Exception e) {
            throw new PageletException(e);
        }
        PageletTokenizer tokenizer = new PageletTokenizer(in);
        PageletParser parser = new PageletParser(tokenizer, this.factory.getConfig(), this.className);
        parser.parse(out, this.packageName, this.factory.getConfig().getPageletProfile());
        out.close();
    }

    private void loadClass() throws PageletException {
        Class templateClass = null;
        try {
            PageletClassLoader pageletClassLoader = this.factory.getClassLoader();
            templateClass = this.packageName != null && this.packageName.length() > 0 ? pageletClassLoader.loadClass(this.packageName + "." + this.className, this.classFile, true) : pageletClassLoader.loadClass(this.className, this.classFile, true);
            this.template = (Template)templateClass.newInstance();
        }
        catch (Exception e) {
            throw new PageletException(e);
        }
    }
}

