/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet;

import com.urbancode.lib.version.VersionReader;
import com.urbancode.pagelet.Pagelet;
import com.urbancode.pagelet.PageletClassLoader;
import com.urbancode.pagelet.PageletConfig;
import com.urbancode.pagelet.PageletException;
import com.urbancode.pagelet.PageletUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Category;

public class PageletFactory {
    private static Category log = Category.getInstance((String)(class$com$urbancode$pagelet$PageletFactory == null ? (class$com$urbancode$pagelet$PageletFactory = PageletFactory.class$("com.urbancode.pagelet.PageletFactory")) : class$com$urbancode$pagelet$PageletFactory).getName());
    public static final String PAGELET_FACTORY_CONTEXT_KEY = (class$com$urbancode$pagelet$PageletFactory == null ? (class$com$urbancode$pagelet$PageletFactory = PageletFactory.class$("com.urbancode.pagelet.PageletFactory")) : class$com$urbancode$pagelet$PageletFactory).getName();
    private static String versionStr = null;
    protected PageletConfig config = null;
    protected PageletClassLoader classLoader = null;
    protected File[] templateDirs = null;
    protected File workDir = null;
    protected Map name2pagelet = new HashMap();
    protected PageletUtils utils = null;
    protected String classpath = "";
    static /* synthetic */ Class class$com$urbancode$pagelet$PageletFactory;

    public static String getVersion() {
        if (versionStr == null) {
            ClassLoader loader = (class$com$urbancode$pagelet$PageletFactory == null ? (class$com$urbancode$pagelet$PageletFactory = PageletFactory.class$("com.urbancode.pagelet.PageletFactory")) : class$com$urbancode$pagelet$PageletFactory).getClassLoader();
            InputStream in = loader.getResourceAsStream("Pagelet.version");
            versionStr = VersionReader.readVersionStr((InputStream)in);
        }
        return versionStr;
    }

    public static PageletFactory getPageletFactory(PageletConfig config) {
        return new PageletFactory(config);
    }

    public static PageletFactory getPageletFactory(String templatePath, String workDir) {
        PageletConfig defaultConfig = new PageletConfig(templatePath, workDir);
        return PageletFactory.getPageletFactory(defaultConfig);
    }

    public static PageletFactory getPageletFactory(File templatePath, File workDir) {
        return PageletFactory.getPageletFactory(templatePath.getAbsolutePath(), workDir.getAbsolutePath());
    }

    protected PageletFactory(PageletConfig config) {
        this.config = config;
        this.templateDirs = this.convertPathToDirectories(config.getTemplatePath());
        if (config.getWorkDirectory() == null) {
            log.info((Object)"Pagelet work directory not specified. Using work");
            config.setWorkDirectory("work");
        }
        this.workDir = config.getWorkDirectory();
        if (config.getParentClassLoader() != null) {
            log.debug((Object)("Using class loader " + config.getParentClassLoader()));
            this.classLoader = new PageletClassLoader(config.getParentClassLoader());
        } else {
            log.debug((Object)"Using default Pagelet Class Loader");
            this.classLoader = new PageletClassLoader(this.getClass().getClassLoader());
        }
        this.utils = new PageletUtils(config);
    }

    private File[] convertPathToDirectories(String templatePath) {
        StringTokenizer tokenizer = new StringTokenizer(templatePath, File.pathSeparator);
        int i = 0;
        File[] files = new File[tokenizer.countTokens()];
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 0) {
                token = ".";
            }
            files[i++] = new File(token);
        }
        return files;
    }

    public Pagelet getPagelet(String name) throws PageletException {
        String pageletName = this.convertName(name);
        Pagelet pagelet = (Pagelet)this.name2pagelet.get(name);
        if (pagelet == null) {
            int i = 0;
            while (i < this.templateDirs.length) {
                File templateDir = this.templateDirs[i];
                if (templateDir.isDirectory()) {
                    File templateFile = new File(templateDir, pageletName);
                    if (templateFile.isFile()) {
                        String templateFileName = templateFile.getName();
                        String packageName = this.utils.getPackageName(templateDir, templateFile);
                        String className = this.utils.getClassName(templateFileName);
                        File sourceFile = this.utils.getSourceFile(templateFileName, packageName);
                        File classFile = this.utils.getClassFile(templateFileName, packageName);
                        pagelet = new Pagelet(templateFile, sourceFile, classFile, packageName, className, this);
                        this.name2pagelet.put(pageletName, pagelet);
                        i = this.templateDirs.length;
                    }
                } else if (templateDir.isFile()) {
                    try {
                        String zipEntryName = pageletName.replace('\\', '/');
                        ZipFile zipFile = new ZipFile(templateDir);
                        ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
                        if (zipEntry != null) {
                            String templateFileName = zipEntryName.substring(zipEntryName.lastIndexOf(47));
                            File templateFile = templateDir;
                            String packageName = zipEntryName.substring(0, zipEntryName.lastIndexOf(47));
                            packageName = packageName.replace('/', '.');
                            String className = this.utils.getClassName(templateFileName);
                            File sourceFile = this.utils.getSourceFile(templateFileName, packageName);
                            File classFile = this.utils.getClassFile(templateFileName, packageName);
                            pagelet = new Pagelet(templateFile, zipEntryName, sourceFile, classFile, packageName, className, this);
                            this.name2pagelet.put(pageletName, pagelet);
                            i = this.templateDirs.length;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (pagelet == null) {
                String classFileName = this.utils.getClassName(pageletName) + ".class";
                File classFile = new File(this.config.getWorkDirectory(), classFileName);
                if (classFile.exists()) {
                    String packageName = this.utils.getPackageName(this.config.getWorkDirectory(), classFile);
                    String className = classFile.getName().substring(0, classFile.getName().lastIndexOf("."));
                    pagelet = new Pagelet(null, null, classFile, packageName, className, this);
                }
            }
        }
        if (pagelet == null) {
            throw new PageletException("Pagelet not found: " + pageletName + ". Neither the template or a " + "corresponding binary was found.");
        }
        return pagelet;
    }

    protected PageletUtils getPageletUtils() {
        return this.utils;
    }

    protected PageletConfig getConfig() {
        return this.config;
    }

    protected PageletClassLoader getClassLoader() {
        return this.classLoader;
    }

    private String convertName(String pageletName) {
        pageletName = pageletName.replace('\\', File.separatorChar);
        pageletName = pageletName.replace('/', File.separatorChar);
        return pageletName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.out.println("Pagelets v" + PageletFactory.getVersion() + " loaded.\n" + "Copyright 2000-2002 Urbancode.  All rights reserved.");
    }
}

