/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet;

import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.registry.RegistryEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PageletProfile {
    public static final String IMPORT_ENTRY = "import";
    public static final String SCRIPTLET_BEGIN_ENTRY = "scriptlet.begin";
    public static final String SCRIPTLET_END_ENTRY = "scriptlet.end";
    public static final String DECLARATION_ENTRY = "declaration";
    protected List imports = new ArrayList();
    protected List scripletBegins = new ArrayList();
    protected List scripletEnds = new ArrayList();
    protected List declarations = new ArrayList();

    public static PageletProfile getProfile(String filename, String prefix) throws IOException {
        return PageletProfile.getProfile(new File(filename), prefix);
    }

    public static PageletProfile getProfile(File file, String prefix) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Profile file does not exist: " + file);
        }
        return PageletProfile.getProfile(new FileInputStream(file), prefix);
    }

    public static PageletProfile getProfile(InputStream input, String prefix) throws IOException {
        PageletProfile profile = new PageletProfile();
        Registry registry = Registry.load((InputStream)input);
        RegistryEntry regEntry = registry.getRegistryEntry(prefix);
        if (regEntry != null) {
            String scriptletValue;
            Iterator imports = regEntry.getKeyValues(IMPORT_ENTRY);
            while (imports.hasNext()) {
                String importValue = (String)imports.next();
                profile.addImport(importValue);
            }
            Iterator scriptlets = null;
            scriptlets = regEntry.getKeyValues(SCRIPTLET_BEGIN_ENTRY);
            while (scriptlets.hasNext()) {
                scriptletValue = (String)scriptlets.next();
                profile.addScriptletBegin(scriptletValue);
            }
            scriptlets = regEntry.getKeyValues(SCRIPTLET_END_ENTRY);
            while (scriptlets.hasNext()) {
                scriptletValue = (String)scriptlets.next();
                profile.addScriptletEnd(scriptletValue);
            }
            Iterator declarations = regEntry.getKeyValues(DECLARATION_ENTRY);
            while (declarations.hasNext()) {
                String declarationValue = (String)declarations.next();
                profile.addDeclaration(declarationValue);
            }
        }
        return profile;
    }

    protected PageletProfile() {
    }

    public Iterator getImports() {
        return this.imports.iterator();
    }

    public void addImport(String _import) {
        this.imports.add(_import);
    }

    public Iterator getScriptletBegins() {
        return this.scripletBegins.iterator();
    }

    public void addScriptletBegin(String scriptlet) {
        this.scripletBegins.add(scriptlet);
    }

    public Iterator getScriptletEnds() {
        return this.scripletEnds.iterator();
    }

    public void addScriptletEnd(String scriptlet) {
        this.scripletEnds.add(scriptlet);
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public void addDeclaration(String declaration) {
        this.declarations.add(declaration);
    }
}

