/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class PageletStreamPumper
extends Thread {
    private static final int SIZE = 128;
    private static final int SLEEP_TIME = 50;
    private InputStream is = null;
    private Writer writer = null;
    private String name = null;
    private boolean verbose = false;

    public PageletStreamPumper(InputStream is, String name, Writer writer) {
        this(is, name, writer, false);
    }

    public PageletStreamPumper(InputStream is, String name, Writer writer, boolean verbose) {
        this.is = is;
        this.writer = writer;
        this.name = name != null ? "[" + name + "] " : "";
        this.verbose = verbose;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        byte[] buf = new byte[128];
        int length = 0;
        String temp = "";
        try {
            while (true) {
                int index;
                if ((length = this.is.read(buf)) <= 0) {
                    this.writer.write(temp);
                    return;
                }
                if (this.verbose && (index = (temp = temp + new String(buf, 0, length)).lastIndexOf("\n")) != -1) {
                    String line = temp.substring(0, index + 1);
                    temp = temp.substring(index + 1);
                    this.writer.write(line);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

