/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet;

import com.urbancode.pagelet.PageletConfig;
import java.io.File;
import org.apache.log4j.Category;

public final class PageletUtils {
    private static Category log = Category.getInstance((String)(class$com$urbancode$pagelet$PageletUtils == null ? (class$com$urbancode$pagelet$PageletUtils = PageletUtils.class$("com.urbancode.pagelet.PageletUtils")) : class$com$urbancode$pagelet$PageletUtils).getName());
    protected PageletConfig config = null;
    static /* synthetic */ Class class$com$urbancode$pagelet$PageletUtils;

    public static String getIncludePageletName(String pagelet) {
        String str = pagelet;
        if (str == null) {
            throw new NullPointerException("Null string not allowed.");
        }
        if (str.length() < 1) {
            throw new IllegalArgumentException("String of length 1 or greater required.");
        }
        if (str.lastIndexOf(File.separatorChar) > -1) {
            str = str.substring(str.lastIndexOf(File.separatorChar) + 1, str.length());
        }
        if (str.lastIndexOf(46) > -1) {
            str = str.substring(0, str.lastIndexOf(46));
        }
        str = PageletUtils.lowerFirst(str);
        return "_" + str;
    }

    protected static String lowerFirst(String str) {
        char[] strcpy = str.toCharArray();
        strcpy[0] = Character.toLowerCase(strcpy[0]);
        return String.valueOf(strcpy);
    }

    protected PageletUtils(PageletConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Pagelet Configuration is null.");
        }
        log.debug((Object)("PageletUtils templatePath: " + config.getTemplatePath()));
        log.debug((Object)("PageletUtils workDir:      " + config.getWorkDirectory()));
        if (config.getTemplatePath() == null) {
            throw new IllegalArgumentException("Pagelet Template Path parameter is null.");
        }
        if (config.getWorkDirectory() == null) {
            throw new IllegalArgumentException("Pagelet Work Directory parameter is null.");
        }
        if (!config.getWorkDirectory().isDirectory()) {
            config.getWorkDirectory().mkdirs();
        }
        this.config = config;
    }

    protected String getPackageName(File templateDir, File templateFile) {
        int endIndex;
        String templateDirName;
        int startIndex;
        String templateFileStr = templateFile.getAbsolutePath();
        String pkgDirName = templateFileStr.substring(startIndex = (templateDirName = templateDir.getAbsolutePath()).length() + 1, endIndex = templateFileStr.length() - templateFile.getName().length());
        String pkgName = pkgDirName.replace(File.separatorChar, '.');
        if (pkgName.startsWith(".")) {
            pkgName = pkgName.substring(1, pkgName.length());
        }
        if (pkgName.endsWith(".")) {
            pkgName = pkgName.substring(0, pkgName.length() - 1);
        }
        return pkgName;
    }

    protected File getClassFile(String templateFileName, String packageName) {
        StringBuffer className = new StringBuffer();
        String packageDir = packageName.replace('.', File.separatorChar);
        templateFileName = templateFileName.replace('.', '_');
        templateFileName = templateFileName + ".class";
        int i = 0;
        while (i < templateFileName.length()) {
            char c = templateFileName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == File.separatorChar || c == '.') {
                className.append(c);
            } else {
                className.append('_');
                className.append(Integer.toHexString(c));
            }
            ++i;
        }
        return new File(this.config.getWorkDirectory(), packageDir + File.separator + className.toString());
    }

    protected File getSourceFile(String templateFileName, String packageName) {
        StringBuffer className = new StringBuffer();
        String packageDir = packageName.replace('.', File.separatorChar);
        String templateFileStr = templateFileName.replace('.', '_');
        templateFileStr = templateFileStr + ".java";
        int i = 0;
        while (i < templateFileStr.length()) {
            char c = templateFileStr.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == File.separatorChar || c == '.') {
                className.append(c);
            } else {
                className.append('_').append(Integer.toHexString(c));
            }
            ++i;
        }
        return new File(this.config.getWorkDirectory(), packageDir + File.separator + className.toString());
    }

    protected String getClassName(String templateFileName) {
        StringBuffer className = new StringBuffer();
        Object rootDirStr = null;
        String templateFileStr = templateFileName.replace('.', '_');
        int i = 0;
        while (i < templateFileStr.length()) {
            char c = templateFileStr.charAt(i);
            if (c == File.separatorChar) {
                c = '.';
            }
            if (Character.isJavaIdentifierPart(c) || c == '.') {
                className.append(c);
            } else {
                className.append('_');
                className.append(Integer.toHexString(c));
            }
            ++i;
        }
        return className.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

