/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet.parser;

import antlr.LLkParser;
import antlr.Parser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import com.urbancode.pagelet.PageletConfig;
import com.urbancode.pagelet.PageletException;
import com.urbancode.pagelet.PageletProfile;
import com.urbancode.pagelet.parser.PageletTokenTypes;
import com.urbancode.pagelet.parser.PageletTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PageletParser
extends LLkParser
implements PageletTokenTypes {
    protected StringBuffer imports = new StringBuffer();
    protected StringBuffer service = new StringBuffer();
    protected StringBuffer declarations = new StringBuffer();
    protected PageletTokenizer tokenizer;
    protected String classname;
    protected PageletConfig config;
    protected Object wsFlag = PageletConfig.WS_INCLUDE;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "DECLARATION", "COMMENT", "EXPRESSION", "IMPORT_DIRECTIVE", "INCLUDE_DIRECTIVE", "SCRIPTLET", "STATIC_CONTENT", "CONTENT", "STRING_CONTENT"};
    private static final long[] _tokenSet_0_data_ = new long[]{2L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);

    public PageletParser(PageletTokenizer tokenizer, PageletConfig config, String classname) {
        this(tokenizer);
        this.tokenizer = tokenizer;
        this.config = config;
        this.classname = classname;
    }

    public String replace(String str, String oldStr, String newStr) {
        if (oldStr == null || oldStr.length() == 0) {
            throw new IllegalArgumentException("String to replace cannot be null or length zero.");
        }
        if (newStr == null) {
            throw new IllegalArgumentException("String replacement cannot be null.");
        }
        int start = 0;
        int replaceLength = oldStr.length();
        start = str.indexOf(oldStr, start);
        while (start >= 0) {
            str = oldStr.length() + start == str.length() ? str.substring(0, start) + newStr : str.substring(0, start) + newStr + str.substring(start + oldStr.length());
            start += newStr.length();
            start = str.indexOf(oldStr, start);
        }
        return str;
    }

    public void parse(Writer out, String packageName, PageletProfile profile) throws PageletException {
        try {
            String profScript;
            Iterator profScripts;
            this.parse();
            if (packageName != null && packageName.length() > 0) {
                out.write("package " + packageName + ";\n\n");
            }
            out.write("import com.urbancode.pagelet.*;\n");
            out.write("import java.io.*;\n");
            out.write("import java.util.*;\n");
            if (profile != null) {
                Iterator profImports = profile.getImports();
                while (profImports.hasNext()) {
                    String profImport = (String)profImports.next();
                    out.write("import " + profImport + ";\n");
                }
            }
            out.write(this.imports.toString());
            out.write("\npublic class " + this.classname + " implements Template {\n\n");
            if (profile != null) {
                Iterator profDecs = profile.getDeclarations();
                while (profDecs.hasNext()) {
                    String profDec = (String)profDecs.next();
                    out.write(profDec + "\n");
                }
            }
            out.write(this.declarations.toString() + "\n");
            out.write("\n\tpublic void service(Map context, Writer out) throws Throwable {\n\n");
            out.write("\t\tPageletFactory pageletFactory = (PageletFactory) context.get(PageletFactory.PAGELET_FACTORY_CONTEXT_KEY);\n\n");
            if (profile != null) {
                profScripts = profile.getScriptletBegins();
                while (profScripts.hasNext()) {
                    profScript = (String)profScripts.next();
                    out.write("\t\t" + profScript + "\n");
                }
            }
            out.write(this.service.toString());
            if (profile != null) {
                profScripts = profile.getScriptletEnds();
                while (profScripts.hasNext()) {
                    profScript = (String)profScripts.next();
                    out.write("\t\t" + profScript + "\n");
                }
            }
            out.write("\t}\n}");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PageletException(e.getMessage());
        }
    }

    protected PageletParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public PageletParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected PageletParser(TokenStream lexer, int k) {
        super(lexer, k);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public PageletParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public PageletParser(ParserSharedInputState state) {
        super(state, 2);
        ((Parser)this).tokenNames = _tokenNames;
    }

    public final void parse() throws RecognitionException, TokenStreamException {
        Token dec = null;
        Token com = null;
        Token exp = null;
        Token imp = null;
        Token inc = null;
        Token scr = null;
        Token stc = null;
        try {
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: {
                        dec = this.LT(1);
                        this.match(4);
                        String decStr = dec.getText().trim();
                        this.declarations.append(decStr + "\t// line " + this.tokenizer.getCurrentLine() + "\n");
                        this.wsFlag = this.config.getDeclarationTagWhitespace();
                        continue block11;
                    }
                    case 5: {
                        com = this.LT(1);
                        this.match(5);
                        this.wsFlag = this.config.getCommentTagWhitespace();
                        continue block11;
                    }
                    case 6: {
                        exp = this.LT(1);
                        this.match(6);
                        String expStr = exp.getText().trim();
                        expStr = this.replace(expStr, "\\%", "%");
                        expStr = this.replace(expStr, "\\>", ">");
                        expStr = this.replace(expStr, "\\<", "<");
                        this.service.append("\t\tout.write(String.valueOf(" + expStr + "));\t// line " + this.tokenizer.getCurrentLine() + "\n");
                        this.wsFlag = this.config.getExpressionTagWhitespace();
                        continue block11;
                    }
                    case 7: {
                        imp = this.LT(1);
                        this.match(7);
                        String content = imp.getText();
                        StringTokenizer tokenizer = new StringTokenizer(content, ",", false);
                        while (tokenizer.hasMoreTokens()) {
                            this.imports.append("import " + tokenizer.nextToken().trim() + ";\t// line " + this.tokenizer.getCurrentLine() + "\n");
                        }
                        this.wsFlag = this.config.getImportTagWhitespace();
                        continue block11;
                    }
                    case 8: {
                        inc = this.LT(1);
                        this.match(8);
                        this.service.append("\t\tpageletFactory.getPagelet(\"" + inc.getText().trim() + "\").service(context, out);\t// line " + this.tokenizer.getCurrentLine() + "\n");
                        this.wsFlag = this.config.getIncludeTagWhitespace();
                        continue block11;
                    }
                    case 9: {
                        scr = this.LT(1);
                        this.match(9);
                        this.service.append("\t\t" + scr.getText().trim() + "\t// line " + this.tokenizer.getCurrentLine() + "\n");
                        this.wsFlag = this.config.getScriptletTagWhitespace();
                        continue block11;
                    }
                    case 10: {
                        stc = this.LT(1);
                        this.match(10);
                        int lineEnds = 0;
                        ArrayList<String> tokens = new ArrayList<String>();
                        String content = stc.getText();
                        content = this.replace(content, "\r", "");
                        StringTokenizer tokenizer = new StringTokenizer(content, "\n", true);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (token.equals("\n")) {
                                tokens.add(token);
                                ++lineEnds;
                                continue;
                            }
                            token = this.replace(token, "\"", "\\\"");
                            token = this.replace(token, "\\%", "%");
                            token = this.replace(token, "\\>", ">");
                            token = this.replace(token, "\\<", "<");
                            tokens.add(token);
                        }
                        boolean firstReturn = true;
                        boolean reachedContent = false;
                        int lineNumber = this.tokenizer.getCurrentLine();
                        int x = 0;
                        while (x < tokens.size()) {
                            String token = (String)tokens.get(x);
                            if (token.equals("\n")) {
                                if (!(x == 0 && this.wsFlag.equals(PageletConfig.WS_IGNORE_FIRST_CR) || !reachedContent && this.wsFlag.equals(PageletConfig.WS_IGNORE))) {
                                    this.service.append("\t\tout.write(\"\\n\");\t// line " + (lineNumber - lineEnds--) + "\n");
                                }
                            } else if (!reachedContent && this.wsFlag.equals(PageletConfig.WS_IGNORE)) {
                                if (token.trim().length() > 0) {
                                    reachedContent = true;
                                    token = token.substring(token.indexOf(token.trim().charAt(0)));
                                    this.service.append("\t\tout.write(\"" + token + "\");\t// line " + (lineNumber - lineEnds) + "\n");
                                }
                            } else {
                                this.service.append("\t\tout.write(\"" + token + "\");\t// line " + (lineNumber - lineEnds) + "\n");
                            }
                            ++x;
                        }
                        this.wsFlag = this.config.getStaticContentWhitespace();
                        continue block11;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
    }
}

