/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet.module.email;

import com.urbancode.pagelet.Pagelet;
import com.urbancode.pagelet.PageletException;
import com.urbancode.pagelet.module.email.EmailModule;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailMessage {
    public static final String EMAIL_MESSAGE = "pagelet.mail.message";
    public static final String MESSAGE_SUBJECT = "pagelet.mail.message.subject";
    public static final String MESSAGE_MULTIPART = "pagelet.mail.message.multipart";
    public static final String MESSAGE_MIME_TYPE = "pagelet.mail.message.mimeType";
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static RecipientType TO = new RecipientType("TO");
    public static RecipientType CC = new RecipientType("CC");
    public static RecipientType BCC = new RecipientType("BCC");
    private EmailModule module;
    private String pageletName;
    private String sender;
    private List recipientsTo = new ArrayList();
    private List recipientsCc = new ArrayList();
    private List recipientsBcc = new ArrayList();

    protected EmailMessage(EmailModule module, String pageletName) {
        this.module = module;
        this.pageletName = pageletName;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void addRecipient(RecipientType type, String recipient) {
        if (TO.equals(type)) {
            this.recipientsTo.add(recipient);
        } else if (CC.equals(type)) {
            this.recipientsCc.add(recipient);
        } else if (BCC.equals(type)) {
            this.recipientsBcc.add(recipient);
        }
    }

    public void addRecipients(RecipientType type, String[] recipients) {
        int i = 0;
        while (i < recipients.length) {
            this.addRecipient(type, recipients[i]);
            ++i;
        }
    }

    public void clearRecipients(RecipientType type) {
        if (TO.equals(type)) {
            this.recipientsTo = new ArrayList();
        } else if (CC.equals(type)) {
            this.recipientsCc = new ArrayList();
        } else if (BCC.equals(type)) {
            this.recipientsBcc = new ArrayList();
        }
    }

    public void send(Map context) throws PageletException {
        try {
            MimeMessage msg = new MimeMessage(this.module.getSession());
            MimeMultipart multipart = new MimeMultipart();
            StringWriter writer = new StringWriter();
            Pagelet pagelet = this.module.getFactory().getPagelet(this.pageletName);
            msg.setFrom((Address)new InternetAddress(this.sender));
            int i = 0;
            while (i < this.recipientsTo.size()) {
                InternetAddress address = new InternetAddress((String)this.recipientsTo.get(i));
                msg.addRecipient(Message.RecipientType.TO, (Address)address);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.recipientsCc.size()) {
                InternetAddress address = new InternetAddress((String)this.recipientsCc.get(i2));
                msg.addRecipient(Message.RecipientType.CC, (Address)address);
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.recipientsBcc.size()) {
                InternetAddress address = new InternetAddress((String)this.recipientsBcc.get(i3));
                msg.addRecipient(Message.RecipientType.BCC, (Address)address);
                ++i3;
            }
            context.put(EMAIL_MESSAGE, msg);
            context.put(MESSAGE_MULTIPART, multipart);
            pagelet.service(context, (Writer)writer);
            MimeBodyPart bodypart = new MimeBodyPart();
            String content = writer.toString();
            String mimeType = (String)context.get(MESSAGE_MIME_TYPE);
            if (mimeType == null) {
                mimeType = DEFAULT_MIME_TYPE;
            }
            bodypart.setContent((Object)content, mimeType);
            multipart.addBodyPart((BodyPart)bodypart);
            msg.setContent((Multipart)multipart);
            msg.setSubject((String)context.get(MESSAGE_SUBJECT));
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            throw new PageletException((Throwable)e);
        }
    }

    public static class RecipientType {
        private String type;

        protected RecipientType(String type) {
            this.type = type;
        }
    }
}

