/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.pagelet.module.email;

import com.urbancode.pagelet.PageletConfig;
import com.urbancode.pagelet.PageletException;
import com.urbancode.pagelet.PageletFactory;
import com.urbancode.pagelet.PageletProfile;
import com.urbancode.pagelet.module.email.EmailMessage;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;

public class EmailModule {
    public static final String EMAIL_PROFILE_FILENAME = "email.profile";
    public static final String EMAIL_PROFILE_PREFIX = "pagelet.profile.module.email";
    public static final String MAIL_HOST = "mail.host";
    protected Session session;
    protected PageletFactory factory;
    protected PageletProfile profile;

    public static synchronized EmailModule getEmailModule(String host, String rootDir, String workDir) throws PageletException {
        return EmailModule.getEmailModule(host, rootDir, workDir, null);
    }

    public static synchronized EmailModule getEmailModule(String host, String rootDir, String workDir, String classpath) throws PageletException {
        EmailModule module = new EmailModule(host, rootDir, workDir, classpath);
        return module;
    }

    protected EmailModule(String host, String rootDir, String workDir, String classpath) throws PageletException {
        Properties props = new Properties();
        ((Hashtable)props).put(MAIL_HOST, host);
        this.session = Session.getDefaultInstance((Properties)props, null);
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream input = loader.getResourceAsStream(EMAIL_PROFILE_FILENAME);
            this.profile = PageletProfile.getProfile((InputStream)input, (String)EMAIL_PROFILE_PREFIX);
        }
        catch (Exception e) {
            throw new PageletException((Throwable)e);
        }
        PageletConfig config = new PageletConfig(rootDir, workDir);
        config.setPageletProfile(this.profile);
        config.setClasspath(classpath);
        this.factory = PageletFactory.getPageletFactory((PageletConfig)config);
    }

    public EmailMessage createMessage(String pageletName) {
        return new EmailMessage(this, pageletName);
    }

    protected Session getSession() {
        return this.session;
    }

    protected PageletFactory getFactory() {
        return this.factory;
    }

    protected PageletProfile getProfile() {
        return this.profile;
    }
}

