/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.AnthillConfig;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.AnthillSchedule;
import com.urbancode.anthill.BuildDaemon;
import com.urbancode.anthill.Buildable;
import com.urbancode.anthill.DependencyGroup;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.anthill.util.Queue;
import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.version.VersionReader;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Anthill {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$Anthill == null ? (class$com$urbancode$anthill$Anthill = Anthill.class$("com.urbancode.anthill.Anthill")) : class$com$urbancode$anthill$Anthill).getName());
    public static final String APP_NAME = "anthill";
    public static final String BUILD_INTERVAL_KEY = "build.interval";
    public static final String ANTHILL_ROOT_DIR_KEY = "anthill.root.dir";
    public static final String NEW_PROJECT_KEY = "_temp";
    public static final String NEW_SCHEDULE_KEY = "_temp";
    public static final String NEW_DEPENDENCY_GROUP_KEY = "_temp";
    public static Anthill anthill = null;
    private static String versionStr = null;
    protected File anthillRootDir = null;
    protected File configDir = null;
    protected File projectsDir = null;
    protected File publishDir = null;
    protected AnthillConfig defaults = null;
    protected Map name2project = new TreeMap();
    protected Map fileName2schedule = new TreeMap();
    protected Map name2schedule = new TreeMap();
    protected Map name2group = new TreeMap();
    protected Queue queue = new Queue();
    protected BuildDaemon buildDeamon = null;
    static /* synthetic */ Class class$com$urbancode$anthill$Anthill;
    static /* synthetic */ Class class$com$urbancode$anthill$AnthillProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        block7: {
            Package anthillPackage;
            block8: {
                if (versionStr != null) break block7;
                anthillPackage = Package.getPackage("com.urbancode.anthill");
                if (anthillPackage != null) break block8;
                InputStream in = null;
                try {
                    System.out.println("anthillPackage was null, getting version from anthill.version");
                    ClassLoader loader = (class$com$urbancode$anthill$AnthillProject == null ? (class$com$urbancode$anthill$AnthillProject = Anthill.class$("com.urbancode.anthill.AnthillProject")) : class$com$urbancode$anthill$AnthillProject).getClassLoader();
                    in = loader.getResourceAsStream("anthill.version");
                    versionStr = VersionReader.readVersionStr((InputStream)in);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block7;
                }
                catch (Exception e) {}
                break block7;
            }
            versionStr = anthillPackage.getImplementationVersion();
        }
        return versionStr;
    }

    public static Anthill getAnthill() throws Exception {
        if (anthill == null) {
            anthill = new Anthill();
        }
        return anthill;
    }

    public static Anthill getAnthill(String anthillRootDirName) throws Exception {
        if (anthill == null) {
            anthill = new Anthill(anthillRootDirName);
        }
        return anthill;
    }

    private Anthill() throws Exception {
        throw new Exception("ANTHILL singleton construction error.");
    }

    private Anthill(String anthillRootDirName) throws Exception {
        this.anthillRootDir = new File(anthillRootDirName);
        if (!this.anthillRootDir.exists() || !this.anthillRootDir.isDirectory()) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("The Anthill root directory is not valid.");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            throw new Exception("The Anthill root directory is not valid.");
        }
        System.out.println("Anthill root dir: " + this.anthillRootDir.getAbsolutePath());
        this.configDir = new File(this.anthillRootDir, "conf");
        this.initialize();
    }

    public void doShutdown() {
        Iterator itr = this.getScheduleIterator();
        AnthillSchedule schedule = null;
        while (itr.hasNext()) {
            schedule = (AnthillSchedule)itr.next();
            schedule.doShutdown();
        }
        this.buildDeamon.doShutdown();
        this.queue.doShutdown();
        log.info((Object)"Anthill.doShutdown() called");
    }

    public void doPause() {
        this.queue.doPause();
        log.info((Object)"Anthill.doPause() called");
    }

    public void doResume() {
        this.queue.doResume();
        log.info((Object)"Anthill.doResume() called");
    }

    public boolean isQueuePaused() {
        return this.queue.isPaused();
    }

    public AnthillProject createProject(String name) throws Exception {
        if (this.name2project.containsKey(name)) {
            throw new IllegalArgumentException("An AnthillProject with the name " + name + " already exists.");
        }
        AnthillProject project = new AnthillProject(this, name);
        this.name2project.put(name, project);
        return project;
    }

    public AnthillSchedule createSchedule(String name) throws Exception {
        if (this.name2schedule.containsKey(name)) {
            throw new IllegalArgumentException("An AnthillSchedule with the name " + name + " already exists.");
        }
        AnthillSchedule schedule = new AnthillSchedule(this, name);
        this.name2schedule.put(name, schedule);
        return schedule;
    }

    public DependencyGroup createDependencyGroup(String name) throws Exception {
        if (this.name2group.containsKey(name)) {
            throw new IllegalArgumentException("A DependencyGroup with the name " + name + " already exists.");
        }
        File file = new File(name + ".dependencies");
        DependencyGroup group = new DependencyGroup(this, file);
        this.name2group.put(name, group);
        log.debug((Object)("added group to map *" + name + "*"));
        return group;
    }

    public void deleteProject(String name) throws Exception {
        if (!this.name2project.containsKey(name)) {
            throw new IllegalArgumentException("Project: " + name + " doesn't exist.");
        }
        AnthillProject proj = this.getProject(name);
        AnthillSchedule schedule = proj.getSchedule();
        schedule.remove(proj);
        File tempProjectFile = new File(this.getAnthillProjectsDir() + File.separator + name + ".anthill");
        if (!tempProjectFile.exists()) {
            throw new IllegalArgumentException("Project file: " + tempProjectFile.getAbsolutePath() + " for project: " + name + " doesn't exist.");
        }
        if (tempProjectFile.delete()) {
            this.name2project.remove(name);
        } else {
            log.error((Object)("Unable to delete project file: " + tempProjectFile.getAbsolutePath()));
        }
    }

    public void deleteSchedule(String name) throws Exception {
        Iterator itr = this.getProjectIterator();
        while (itr.hasNext()) {
            AnthillProject project = (AnthillProject)itr.next();
            AnthillSchedule schedule = project.getSchedule();
            String projScheduleName = schedule.getScheduleName();
            if (!name.equals(projScheduleName)) continue;
            throw new IllegalArgumentException("Schedule - " + name + " - is in use by project " + project.getProjectName());
        }
        if (!this.name2schedule.containsKey(name)) {
            throw new IllegalArgumentException("Schedule: " + name + " doesn't exist.");
        }
        File tempScheduleFile = new File(this.getAnthillProjectsDir() + File.separator + name + ".schedule");
        if (!tempScheduleFile.exists()) {
            throw new IllegalArgumentException("Schedule file: " + tempScheduleFile.getAbsolutePath() + " for schedule: " + name + " doesn't exist.");
        }
        if (tempScheduleFile.delete()) {
            log.debug((Object)("deleted schedule " + name));
            this.name2schedule.remove(name);
        } else {
            log.error((Object)("Unable to delete schedule file: " + tempScheduleFile.getAbsolutePath()));
        }
    }

    public void deleteDependencyGroup(String name) throws Exception {
        if (!this.name2group.containsKey(name)) {
            throw new IllegalArgumentException("Dependency group: " + name + " doesn't exist.");
        }
        DependencyGroup depGroup = this.getDependencyGroup(name);
        AnthillSchedule schedule = depGroup.getSchedule();
        schedule.remove(depGroup);
        File tempDependencyGroupFile = new File(this.getAnthillProjectsDir() + File.separator + name + ".dependencies");
        if (!tempDependencyGroupFile.exists()) {
            throw new IllegalArgumentException("Dependency Group file: " + tempDependencyGroupFile.getAbsolutePath() + " for dependency group: " + name + " doesn't exist.");
        }
        if (tempDependencyGroupFile.delete()) {
            this.name2group.remove(name);
        } else {
            log.error((Object)("Unable to delete dependency group file: " + tempDependencyGroupFile.getAbsolutePath()));
        }
    }

    public AnthillConfig getAnthillConfig() {
        return this.defaults;
    }

    public File getAnthillConfigDir() {
        return this.configDir;
    }

    public File getAnthillDefaultPublishDir() {
        return this.publishDir;
    }

    public File getAnthillProjectsDir() {
        return this.projectsDir;
    }

    public File getAnthillRootDir() {
        return this.anthillRootDir;
    }

    public AnthillProject getProject(String name) {
        if (!this.name2project.containsKey(name)) {
            try {
                this.refreshProjectMap();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (AnthillProject)this.name2project.get(name);
    }

    public Iterator getProjectIterator() {
        try {
            this.refreshProjectMap();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.name2project.values().iterator();
    }

    public DependencyGroup getDependencyGroup(String name) {
        if (!this.name2group.containsKey(name)) {
            try {
                this.refreshDependencyGroupMap();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (DependencyGroup)this.name2group.get(name);
    }

    public Iterator getDependencyGroupIterator() {
        try {
            this.refreshDependencyGroupMap();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.name2group.values().iterator();
    }

    public Queue getBuildQueue() {
        return this.queue;
    }

    public AnthillSchedule getSchedule(String name) {
        if (!this.name2schedule.containsKey(name)) {
            try {
                this.refreshScheduleMap();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (AnthillSchedule)this.name2schedule.get(name);
    }

    public Iterator getScheduleIterator() {
        try {
            this.refreshScheduleMap();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.name2schedule.values().iterator();
    }

    public void runDaemon() throws Exception {
        log.info((Object)"Starting Anthill daemons");
        this.buildDeamon = new BuildDaemon(this.queue);
        this.buildDeamon.start();
        Iterator itr = this.getScheduleIterator();
        AnthillSchedule schedule = null;
        while (itr.hasNext()) {
            schedule = (AnthillSchedule)itr.next();
            schedule.start();
        }
    }

    public Buildable getProjectBeingBuilt() {
        return this.buildDeamon.getProjectBeingBuilt();
    }

    protected void doProjectNameChange(String oldName) {
        AnthillProject project = (AnthillProject)this.name2project.get(oldName);
        if (project == null) {
            throw new IllegalArgumentException("Project with name " + oldName + " does not exist.");
        }
        this.name2project.remove(oldName);
        this.name2project.put(project.getProjectName(), project);
    }

    protected void doScheduleNameChange(String oldName, String oldFileName) {
        AnthillSchedule schedule = (AnthillSchedule)this.name2schedule.get(oldName);
        if (schedule == null) {
            throw new IllegalArgumentException("Schedule with name " + oldName + " does not exist.");
        }
        this.name2schedule.remove(oldName);
        this.name2schedule.put(schedule.getScheduleName(), schedule);
    }

    protected void doDependencyGroupNameChange(String oldName) {
        DependencyGroup group = (DependencyGroup)this.name2group.get(oldName);
        if (group == null) {
            throw new IllegalArgumentException("DependencyGroup with name " + oldName + " does not exist.");
        }
        this.name2group.remove(oldName);
        this.name2group.put(group.getName(), group);
    }

    protected void initialize() throws Exception {
        String propertyFile = this.configDir.getAbsolutePath() + File.separator + "log4j.configuration";
        PropertyConfigurator.configure((String)propertyFile);
        Registry defaultRegistry = Registry.loadFile((File)new File(this.anthillRootDir, "projects/anthill.registry"));
        this.defaults = new AnthillConfig(this, defaultRegistry);
        this.projectsDir = this.defaults.getProjectsDir();
        this.publishDir = this.defaults.getDefaultPublishDir();
        this.refreshScheduleMap();
        this.refreshProjectMap();
        this.refreshDependencyGroupMap();
    }

    protected void refreshProjectMap() throws Exception {
        File[] fileList = this.projectsDir.listFiles();
        AnthillProject project = null;
        String projectName = null;
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].getName().endsWith(".anthill") || this.name2project.containsKey(projectName = FileUtils.getNameMinusExtension(fileList[i]))) continue;
            try {
                project = new AnthillProject(this, fileList[i]);
                this.name2project.put(projectName, project);
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Could not create Anthill project.", (Throwable)e);
                throw e;
            }
        }
    }

    protected void refreshScheduleMap() throws Exception {
        File[] fileList = this.projectsDir.listFiles();
        AnthillSchedule schedule = null;
        String scheduleName = null;
        String scheduleFileName = null;
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].getName().endsWith(".schedule")) continue;
            scheduleFileName = FileUtils.getNameMinusExtension(fileList[i]);
            log.debug((Object)("Anthill.refreshScheduleMap scheduleFileName: " + scheduleFileName));
            if (this.fileName2schedule.containsKey(scheduleFileName)) continue;
            try {
                schedule = new AnthillSchedule(this, fileList[i]);
                scheduleName = schedule.getScheduleName();
                log.debug((Object)("Anthill.refreshScheduleMap scheduleName: " + scheduleName));
                this.name2schedule.put(scheduleName, schedule);
                this.fileName2schedule.put(scheduleFileName, schedule);
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Could not create Anthill schedule.", (Throwable)e);
                throw e;
            }
        }
    }

    protected void refreshDependencyGroupMap() throws Exception {
        File[] fileList = this.projectsDir.listFiles();
        DependencyGroup group = null;
        String groupName = null;
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].getName().endsWith(".dependencies") || this.name2group.containsKey(groupName = FileUtils.getNameMinusExtension(fileList[i]))) continue;
            try {
                group = new DependencyGroup(this, fileList[i]);
                this.name2group.put(groupName, group);
                log.debug((Object)("added group to map *" + groupName + "*"));
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Could not create DependencyGroup.", (Throwable)e);
                throw e;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.out.println("Anthill version: " + Anthill.getVersion() + " loaded.");
    }
}

