/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.registry.RegistryEntry;
import java.io.File;
import org.apache.log4j.Logger;

public class AnthillConfig {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$AnthillConfig == null ? (class$com$urbancode$anthill$AnthillConfig = AnthillConfig.class$("com.urbancode.anthill.AnthillConfig")) : class$com$urbancode$anthill$AnthillConfig).getName());
    public static final String REGISTRY_ENTRY_KEY = "anthill";
    public static final String JAVA_HOME = "jdk.home";
    public static final String ANT_HOME = "ant.home";
    public static final String PROJECTS_DIR = "projects.dir";
    public static final String PUBLISH_DIR = "publish.dir.default";
    public static final String PATH_SEPARATOR = "path.separator";
    private Anthill anthill = null;
    private String jdkHome = null;
    private String defaultUser = null;
    private String antClassPath = null;
    private RegistryEntry regEntry = null;
    private RegistryEntry rootEntry = null;
    private Registry registry = null;
    private File projectsDir = null;
    private File publishDir = null;
    private String anthillUrlStr = null;
    static /* synthetic */ Class class$com$urbancode$anthill$AnthillConfig;

    public AnthillConfig(Anthill anthill, Registry registry) {
        this.anthill = anthill;
        this.registry = registry;
        this.regEntry = registry.getRegistryEntry(REGISTRY_ENTRY_KEY);
        this.rootEntry = registry.getRootRegistryEntry();
        this.anthillUrlStr = this.regEntry.getKeyValue("server");
        this.calculateJdkHome();
        this.calculateAntClassPath();
        this.calculateProjectsDir();
        this.calculateDefaultPublishDir();
    }

    public File getProjectsDir() {
        return this.projectsDir;
    }

    public File getDefaultPublishDir() {
        return this.publishDir;
    }

    public String getAnthillUrlString() {
        return this.anthillUrlStr;
    }

    public String getProperty(String name) {
        String value = null;
        value = this.regEntry.getKeyValue(name);
        if (value == null) {
            value = System.getProperty("anthill." + name);
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.regEntry.setKeyValue(name, value);
        log.debug((Object)("setProperty name: " + name + ", value: " + value));
    }

    public void save() throws Exception {
        this.registry.updateRegistryFile();
        this.calculateJdkHome();
        this.calculateAntClassPath();
        this.calculateProjectsDir();
        this.calculateDefaultPublishDir();
        this.anthill.initialize();
        log.debug((Object)"Saved");
    }

    protected void calculateDefaultPublishDir() {
        String publishDirName = this.getProperty(PUBLISH_DIR);
        if (publishDirName == null) {
            throw new IllegalArgumentException("Publish directory parameter must not be null.");
        }
        File tempPublishDir = FileUtils.makeProperPath(this.anthill.getAnthillRootDir(), publishDirName);
        if (!tempPublishDir.exists()) {
            throw new IllegalArgumentException("Publish directory parameter must point to an existing directory.");
        }
        if (!tempPublishDir.isDirectory()) {
            throw new IllegalArgumentException("Publish directory parameter must point to a directory.");
        }
        this.publishDir = tempPublishDir;
    }

    protected void calculateProjectsDir() {
        String projectsDirName = this.getProperty(PROJECTS_DIR);
        if (projectsDirName == null) {
            throw new IllegalArgumentException("Projects directory parameter must not be null.");
        }
        File tempProjectDir = FileUtils.makeProperPath(this.anthill.getAnthillRootDir(), projectsDirName);
        if (!tempProjectDir.exists()) {
            throw new IllegalArgumentException("Projects directory parameter must point to an existing directory.");
        }
        if (!tempProjectDir.isDirectory()) {
            throw new IllegalArgumentException("Projects directory parameter must point to a directory.");
        }
        this.projectsDir = tempProjectDir;
    }

    protected void calculateJdkHome() {
        this.jdkHome = this.getProperty(JAVA_HOME);
        if (this.jdkHome == null) {
            this.jdkHome = System.getProperty("java.home");
            if (this.jdkHome.endsWith("jre") || this.jdkHome.endsWith("JRE")) {
                log.debug((Object)("JdkHome points to a JRE - " + this.jdkHome));
                String tempJdk = this.jdkHome.substring(0, this.jdkHome.length() - 3);
                log.debug((Object)("Looking for jdkHome in the parentDirectory: " + tempJdk));
                File jdkBin = FileUtils.makeProperPath(this.anthill.getAnthillRootDir(), tempJdk + File.separator + "bin");
                if (jdkBin.exists()) {
                    File jdkHomeFile = FileUtils.makeProperPath(this.anthill.getAnthillRootDir(), tempJdk);
                    this.jdkHome = jdkHomeFile.getAbsolutePath();
                }
            }
        }
        log.debug((Object)("jdkHome: " + this.jdkHome));
    }

    protected void calculateAntClassPath() {
        String pathSeparator = System.getProperty(PATH_SEPARATOR);
        String antHome = this.getProperty(ANT_HOME);
        StringBuffer classpath = new StringBuffer();
        antHome = this.calculateAntHome();
        File antHomeFile = new File(antHome);
        classpath.append(this.jdkHome).append(File.separator).append("lib").append(File.separator).append("tools.jar").append(pathSeparator);
        String[] fileList = antHomeFile.list();
        String file = null;
        for (int i = 0; i < fileList.length; ++i) {
            file = fileList[i];
            if (!file.endsWith(".jar") && !file.endsWith(".zip")) continue;
            classpath.append(antHome).append(File.separator).append(file).append(pathSeparator);
        }
        this.antClassPath = classpath.toString();
        log.debug((Object)("Ant ClassPath: " + this.antClassPath));
    }

    protected String getJdkHome() {
        return this.jdkHome;
    }

    protected String calculateAntHome() {
        String pathSeparator = System.getProperty(PATH_SEPARATOR);
        String antHome = this.getProperty(ANT_HOME);
        if (antHome == null) {
            throw new IllegalStateException("ant.home property not set.");
        }
        if (antHome.endsWith("\\")) {
            antHome = antHome.substring(0, antHome.length() - 1);
        }
        if (antHome.endsWith("/")) {
            antHome = antHome.substring(0, antHome.length() - 1);
        }
        log.debug((Object)("AntHome: " + antHome));
        File antHomeFile = FileUtils.makeProperPath(this.anthill.getAnthillRootDir(), antHome);
        if (antHomeFile.exists() && antHomeFile.isDirectory()) {
            File antJarFile = new File(antHomeFile, "lib/ant.jar");
            if (!antJarFile.exists()) {
                log.error((Object)"Can not find ant.jar in the AntHome location.");
                throw new IllegalStateException("Can not find ant.jar in the AntHome location.");
            }
        } else {
            throw new IllegalStateException("The specified AntHome does not exist or is not a directory.");
        }
        antHome = antHomeFile.getAbsolutePath();
        return antHome;
    }

    protected String getAntClassPath() {
        return this.antClassPath;
    }

    public String getTitleText() {
        String result = this.getProperty("title.text");
        if (result == null || result.length() == 0) {
            result = "Anthill Build Management Server";
        }
        return result;
    }

    public String getBackgroundColor() {
        String result = this.getProperty("background.color");
        if (result == null || result.length() == 0) {
            result = "white";
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

