/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillConfig;
import com.urbancode.anthill.AnthillSchedule;
import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.BuildManager;
import com.urbancode.anthill.Buildable;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.RepositoryAdapter;
import com.urbancode.anthill.adapter.VersionAdapter;
import com.urbancode.anthill.util.FileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnthillProject
implements Buildable {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$AnthillProject == null ? (class$com$urbancode$anthill$AnthillProject = AnthillProject.class$("com.urbancode.anthill.AnthillProject")) : class$com$urbancode$anthill$AnthillProject).getName());
    protected Anthill anthill = null;
    protected AnthillConfig anthillDefaults = null;
    protected ProjectProperties properties = null;
    protected String projectName = null;
    protected BuildManager buildManager = null;
    protected String latestVersion = null;
    protected String branchName = null;
    static /* synthetic */ Class class$com$urbancode$anthill$AnthillProject;

    protected AnthillProject(Anthill anthill, String projectName) throws Exception {
        this.anthill = anthill;
        this.anthillDefaults = anthill.getAnthillConfig();
        this.projectName = projectName;
        this.properties = new ProjectProperties(anthill, this);
        this.buildManager = new BuildManager();
    }

    protected AnthillProject(Anthill anthill, File regFile) throws Exception {
        this.anthill = anthill;
        this.anthillDefaults = anthill.getAnthillConfig();
        this.projectName = FileUtils.getNameMinusExtension(regFile);
        this.properties = new ProjectProperties(anthill, this, regFile);
        this.buildManager = new BuildManager();
    }

    public String getName() {
        return this.getProjectName();
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String name) {
        this.branchName = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Project name cannot be null.");
        }
        String oldProjectName = this.projectName;
        this.projectName = name;
        if (!this.projectName.equals(oldProjectName)) {
            this.anthill.doProjectNameChange(oldProjectName);
        }
    }

    public AnthillConfig getAnthillDefaults() {
        return this.anthillDefaults;
    }

    public void setSchedule(AnthillSchedule schedule) {
        this.properties.setScheduleName(schedule.getScheduleName());
    }

    public AnthillSchedule getSchedule() {
        return this.properties.getSchedule();
    }

    public ProjectProperties getProperties() {
        return this.properties;
    }

    public String getCurrentVersion() {
        String curVer = null;
        curVer = this.getProperties().getProperty("project.version");
        if (curVer == null) {
            curVer = "(not available)";
        }
        return curVer;
    }

    public void save() throws Exception {
        this.properties.save();
    }

    public RepositoryAdapter getRepositoryAdapter() {
        return this.properties.getRepositoryAdapter();
    }

    public VersionAdapter getVersionAdapter() {
        return this.properties.getVersionAdapter();
    }

    public void run() {
        this.releaseProject();
    }

    public synchronized void releaseProject() {
        this.releaseProject(null, null, false);
    }

    public synchronized void releaseProject(String version) {
        this.releaseProject(null, version, false);
    }

    public synchronized void releaseProject(String target, String version, boolean forceBuild) {
        BuildDefinition buildDef = new BuildDefinition(this);
        buildDef.setVersion(version);
        buildDef.setForceBuildFlag(forceBuild);
        this.releaseProject(buildDef);
    }

    public synchronized void releaseProject(BuildDefinition buildDef) {
        try {
            this.buildManager.build(buildDef);
        }
        catch (Exception e) {
            log.error((Object)("Error building project: " + e.getMessage()));
        }
    }

    protected String getJdkHome() {
        return this.anthillDefaults.getJdkHome();
    }

    public void doScheduleNameChanged(AnthillSchedule mySchedule) throws Exception {
        this.properties.setScheduleName(mySchedule.getScheduleName());
        this.save();
    }

    private StringBuffer appendAllKeyValues(Map paramMap, String optionStr) {
        StringBuffer buffer = new StringBuffer();
        Iterator keys = paramMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)paramMap.get(key);
            if (optionStr != null) {
                buffer.append(optionStr);
            }
            buffer.append(key).append("=").append(value).append(" ");
        }
        return buffer;
    }

    private StringBuffer appendAllKeyValues(List paramMap) {
        StringBuffer buffer = new StringBuffer();
        Iterator keys = paramMap.iterator();
        while (keys.hasNext()) {
            buffer.append(keys.next()).append(" ");
        }
        return buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

