/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.Buildable;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.lib.registry.Registry;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class AnthillSchedule
extends Thread {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$AnthillSchedule == null ? (class$com$urbancode$anthill$AnthillSchedule = AnthillSchedule.class$("com.urbancode.anthill.AnthillSchedule")) : class$com$urbancode$anthill$AnthillSchedule).getName());
    public static final String SCHEDULE_FILE_SUFFIX = ".schedule";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("H:mm");
    protected static final String BUILD_INTERVAL_KEY = "schedule.build.interval";
    protected static final String START_INTERVAL_KEY = "schedule.start.time";
    protected static final String SCHEDULE_NAME_KEY = "schedule.name";
    private static final DateFormat DBG_DT_FMT = DateFormat.getDateTimeInstance();
    private transient Anthill anthill = null;
    private transient File file = null;
    private transient String fileSafeName = null;
    private transient List projectSet = new ArrayList();
    private transient Registry registry = null;
    private transient boolean shutdown = false;
    private transient long lastBuildTime = 0L;
    private String scheduleName = null;
    private Calendar startHrMinCal = null;
    private long buildIntervalMillis = 0L;
    static /* synthetic */ Class class$com$urbancode$anthill$AnthillSchedule;

    public AnthillSchedule(Anthill anthill, String name) throws Exception {
        this.anthill = anthill;
        this.registry = Registry.createRegistry();
        this.setScheduleName(name);
        this.startHrMinCal = Calendar.getInstance();
        this.setName("Thread - AnthillSchedule." + this.getScheduleName());
        this.setDaemon(true);
    }

    public AnthillSchedule(Anthill anthill, File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("File parameter can not be null.");
        }
        this.anthill = anthill;
        this.file = file;
        this.fileSafeName = FileUtils.getNameMinusExtension(file);
        log.debug((Object)("Loading schedule file: " + this.fileSafeName));
        this.registry = Registry.loadFile((File)file);
        this.load();
        this.setName("Thread - AnthillSchedule." + this.getScheduleName());
        this.setDaemon(true);
    }

    public void setScheduleName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Project name cannot be null.");
        }
        String oldScheduleName = this.scheduleName;
        this.scheduleName = name;
        String oldFileSafeName = this.fileSafeName;
        this.fileSafeName = FileUtils.makeSafeFileName(this.scheduleName);
        if (oldScheduleName != null && !this.scheduleName.equals(oldScheduleName)) {
            this.anthill.doScheduleNameChange(oldScheduleName, oldFileSafeName);
        }
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public String getFileSafeName() {
        return this.fileSafeName;
    }

    public void doShutdown() {
        this.shutdown = true;
    }

    public void setBuildInterval(int intervalMins) {
        long temp = intervalMins * 60 * 1000;
        if (temp != this.buildIntervalMillis) {
            this.buildIntervalMillis = temp;
            this.interrupt();
        }
    }

    public int getBuildInterval() {
        return (int)(this.buildIntervalMillis / 60000L);
    }

    public int getBuildIntervalInMillis() {
        return (int)this.buildIntervalMillis;
    }

    public void setStartTime(Date startTime) {
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(startTime);
        if (this.startHrMinCal == null || this.startHrMinCal.get(11) != tempCal.get(11) || this.startHrMinCal.get(12) != tempCal.get(12)) {
            this.startHrMinCal = tempCal;
        }
    }

    public Date getStartTime() {
        return this.startHrMinCal.getTime();
    }

    public long getMinutesToNextBuild() {
        return (int)(this.getMillisToNextBuild() / 60000L);
    }

    public long getMillisToNextBuild() {
        long timeToNextBuild = 0L;
        if (this.buildIntervalMillis != 0L) {
            timeToNextBuild = this.getNextBuildTime() - System.currentTimeMillis();
        }
        if (timeToNextBuild < 0L) {
            timeToNextBuild = this.getNextBuildTime() - System.currentTimeMillis();
        }
        return timeToNextBuild;
    }

    protected long getNextBuildTime() {
        long nextBuildTime = 0L;
        if (this.lastBuildTime == 0L) {
            Calendar now = Calendar.getInstance();
            Calendar nextBuildCal = Calendar.getInstance();
            nextBuildCal.set(11, this.startHrMinCal.get(11));
            nextBuildCal.set(12, this.startHrMinCal.get(12));
            nextBuildCal.set(13, 0);
            if (nextBuildCal.before(now)) {
                log.debug((Object)("getNextBuildTime() name: " + this.getScheduleName() + " nextBuildCalMillis: " + nextBuildCal.getTime().getTime()));
                long length = now.getTime().getTime() - nextBuildCal.getTime().getTime();
                log.debug((Object)("getNextBuildTime() name: " + this.getScheduleName() + " millis since start: " + length));
                double count = Math.ceil(length / this.buildIntervalMillis);
                log.debug((Object)("getNextBuildTime() name: " + this.getScheduleName() + " intervals since start: " + (count += 1.0)));
                nextBuildCal.add(14, (int)(count * (double)this.buildIntervalMillis));
            }
            nextBuildTime = nextBuildCal.getTime().getTime();
        } else {
            nextBuildTime = this.lastBuildTime + this.buildIntervalMillis;
        }
        log.debug((Object)("getNextBuildTime() name: " + this.getScheduleName() + " nextBuildTime: " + nextBuildTime + ", " + DBG_DT_FMT.format(new Date(nextBuildTime))));
        log.debug((Object)("getNextBuildTime() name: " + this.getScheduleName() + " currentTime: " + System.currentTimeMillis() + ", " + DBG_DT_FMT.format(new Date())));
        return nextBuildTime;
    }

    public synchronized void add(Buildable project) {
        log.debug((Object)("AnthillSchedule.add(): " + project));
        if (!this.projectSet.contains(project)) {
            this.projectSet.add(project);
        }
    }

    public synchronized void remove(Buildable project) {
        this.projectSet.remove(project);
    }

    public synchronized Iterator getProjectIterator() {
        return this.projectSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug((Object)("run() name: " + this.getScheduleName()));
        log.debug((Object)("run() name: " + this.getScheduleName() + " buildIntervalMillis: " + this.buildIntervalMillis));
        long timeToNextBuild = 0L;
        boolean resetBuild = false;
        if (this.buildIntervalMillis > 0L) {
            log.debug((Object)("run() name: " + this.getScheduleName() + " MillisToNextBuild: " + this.getMillisToNextBuild()));
            while (!this.shutdown) {
                try {
                    timeToNextBuild = this.getMillisToNextBuild();
                    log.debug((Object)("run() name: " + this.getScheduleName() + " sleeping: " + timeToNextBuild));
                    AnthillSchedule.sleep(timeToNextBuild);
                    log.debug((Object)("run() name: " + this.getScheduleName() + " woke up"));
                    List list = this.projectSet;
                    synchronized (list) {
                        log.debug((Object)("Schedule running: " + this.getScheduleName()));
                        this.lastBuildTime = System.currentTimeMillis();
                        Iterator itr = this.projectSet.iterator();
                        Buildable project = null;
                        while (itr.hasNext()) {
                            project = (Buildable)itr.next();
                            this.anthill.getBuildQueue().add(project);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    public void save() throws Exception {
        if (this.file != null) {
            if (!this.fileSafeName.equals(FileUtils.getNameMinusExtension(this.file))) {
                this.file.delete();
                this.file = null;
                this.createFile();
                this.notifyProjectsOfNameChange();
            }
        } else {
            this.createFile();
        }
        this.setProperty(SCHEDULE_NAME_KEY, this.scheduleName);
        this.setProperty(BUILD_INTERVAL_KEY, Long.toString(this.buildIntervalMillis / 60000L));
        this.setProperty(START_INTERVAL_KEY, DATE_FORMAT.format(this.startHrMinCal.getTime()));
        this.registry.updateRegistryFile();
    }

    protected void createFile() throws Exception {
        if (this.file == null) {
            File dir = this.anthill.getAnthillProjectsDir();
            this.file = new File(dir, this.fileSafeName + SCHEDULE_FILE_SUFFIX);
            this.registry.setRegistryFile(this.file);
        }
    }

    protected void load() throws Exception {
        long unitlessBuildInterval;
        String startHrMinStr;
        if (this.scheduleName == null) {
            String tempName = this.getProperty(SCHEDULE_NAME_KEY);
            if (tempName == null) {
                tempName = this.fileSafeName;
            }
            this.setScheduleName(tempName);
        }
        if ((startHrMinStr = this.getProperty(START_INTERVAL_KEY)) == null) {
            startHrMinStr = "12:00";
        }
        Date startHrMinDate = DATE_FORMAT.parse(startHrMinStr);
        this.startHrMinCal = Calendar.getInstance();
        this.startHrMinCal.setTime(startHrMinDate);
        String intervalStr = this.getProperty(BUILD_INTERVAL_KEY);
        if (intervalStr == null) {
            intervalStr = "0";
        }
        this.buildIntervalMillis = (unitlessBuildInterval = Long.parseLong(intervalStr)) >= 100000L ? unitlessBuildInterval : unitlessBuildInterval * 60L * 1000L;
    }

    protected String getProperty(String name) {
        String value = this.registry.getKeyValue(name);
        log.debug((Object)("schedule " + this.scheduleName + " getProperty() " + name + " : " + value));
        return value;
    }

    protected void setProperty(String name, String value) {
        this.registry.setKeyValue(name, value);
    }

    protected void notifyProjectsOfNameChange() throws Exception {
        Iterator itr = this.projectSet.iterator();
        Buildable project = null;
        while (itr.hasNext()) {
            project = (Buildable)itr.next();
            project.doScheduleNameChanged(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

