/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillBuildException;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.PageletResultEmail;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.RepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.adapter.VersionAdapter;
import com.urbancode.pagelet.PageletException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.execute.Execute;
import org.apache.log4j.Logger;

public class BuildManager {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$BuildManager == null ? (class$com$urbancode$anthill$BuildManager = BuildManager.class$("com.urbancode.anthill.BuildManager")) : class$com$urbancode$anthill$BuildManager).getName());
    private static Logger streamLog = Logger.getLogger((String)((class$com$urbancode$anthill$BuildManager == null ? (class$com$urbancode$anthill$BuildManager = BuildManager.class$("com.urbancode.anthill.BuildManager")) : class$com$urbancode$anthill$BuildManager).getName() + "Stream"));
    private static final String LABEL_PREFIX = "Anthill_";
    public static final String UNIX_OS = "Unix";
    public static final String WINDOWS_OS = "Win32";
    protected static String userOS = null;
    static /* synthetic */ Class class$com$urbancode$anthill$BuildManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void build(BuildDefinition def) throws AnthillBuildException, RepositoryException, MessagingException {
        Date buildDate;
        ProjectProperties properties;
        block37: {
            block38: {
                AnthillProject project = def.getProject();
                properties = project.getProperties();
                RepositoryAdapter radapter = null;
                VersionAdapter vadapter = null;
                boolean doBuild = false;
                buildDate = null;
                try {
                    File tempPublishDir;
                    radapter = project.getRepositoryAdapter();
                    vadapter = project.getVersionAdapter();
                    def.appendLogMessage("Anthill version " + Anthill.getVersion() + "\n\n");
                    log.info((Object)("Project: " + project.getProjectName() + " is being released."));
                    log.info((Object)"Initializing repository adapter...");
                    radapter.init(project);
                    try {
                        log.info((Object)"step 0) Clean up working directory");
                        if (radapter != null) {
                            radapter.revert();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    log.info((Object)"step 1) Retrieve working copy of code from repository");
                    def.appendLogMessage("Retrieving project files: ");
                    buildDate = new Date();
                    radapter.getWorkingProjectCopy(def);
                    def.appendLogMessage("OK\n");
                    log.info((Object)"step 2) is project up to date?");
                    if (def.getForceBuildFlag() || this.requiresBuild(def, radapter)) {
                        if (def.getVersion() == null) {
                            log.info((Object)"step 3) Increment version: ");
                            def.appendLogMessage("Incrementing version: ");
                            String tempVersion = vadapter.incrementVersion();
                            def.setVersion(tempVersion);
                            if (properties.getProperty("project.version") == null) {
                                properties.addProperty("project.version", tempVersion);
                            } else {
                                properties.setProperty("project.version", tempVersion);
                            }
                        } else {
                            log.info((Object)"Set version: ");
                            if (!def.getVersionedBuildFlag()) {
                                vadapter.setCurrentVersion(def.getVersion());
                            } else {
                                log.info((Object)"Bypassing update of the version file becuase this is a versioned build. ");
                            }
                            if (properties.getProperty("project.version") == null) {
                                properties.addProperty("project.version", def.getVersion());
                            } else {
                                properties.setProperty("project.version", def.getVersion());
                            }
                        }
                    } else {
                        log.info((Object)"Build NOT required.");
                        return;
                    }
                    log.info((Object)("New version: " + def.getVersion()));
                    def.appendLogMessage("OK\n");
                    properties.save();
                    log.info((Object)"Step 4) Tag project (if set to all): ");
                    if (properties.isTagAllBuildsSelected()) {
                        this.tagProject(def, radapter);
                    }
                    if (!(tempPublishDir = new File(properties.getProjectPublishDirName())).exists() && !tempPublishDir.mkdirs()) {
                        log.error((Object)("Unable to create publish directory: " + tempPublishDir.getAbsolutePath()));
                    }
                    log.info((Object)"Step 5) Build Project: ");
                    this.runBuild(def);
                    log.info((Object)"Step 6) Tag project (if set to success): ");
                    if (properties.isTagSuccessfulBuildSelected()) {
                        if (!def.getErrorFlag()) {
                            this.tagProject(def, radapter);
                        } else {
                            def.appendLogMessage("Tag: skipped").appendLogMessage("\n");
                        }
                    }
                    if (properties.isPublishRunPolicyAlways() || !def.getErrorFlag()) {
                        log.info((Object)"Step 7) Publish Project: ");
                        this.publish(def);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                    def.appendLogMessage("FAILED to build project.  Message: ").appendLogMessage(e.getMessage()).appendLogMessage("\n");
                    def.setErrorFlag(true);
                }
                if (def.getVersionedBuildFlag()) break block38;
                StringBuffer logMessage = new StringBuffer();
                OutputStreamWriter revLogFileWriter = null;
                this.loadRevisions(def, radapter);
                List revList = def.getRevisionList();
                Revision rev = null;
                StringBuffer revLog = new StringBuffer();
                if (revList != null) {
                    for (int i = 0; i < revList.size(); ++i) {
                        rev = (Revision)revList.get(i);
                        revLog.append(rev.toString()).append("\n");
                    }
                }
                StringBuffer revLogFileName = new StringBuffer();
                revLogFileName.append(properties.getBuildLogDir()).append(def.getProject().getProjectName()).append("-").append(def.getVersion()).append("-rev.log");
                revLogFileWriter = new FileWriter(revLogFileName.toString());
                revLogFileWriter.write(revLog.toString());
                revLogFileWriter.close();
                Object var15_19 = null;
                try {
                    if (revLogFileWriter != null) {
                        revLogFileWriter.close();
                    }
                    break block37;
                }
                catch (IOException ioe) {}
                break block37;
                {
                    catch (Throwable e) {
                        log.error((Object)"Exception while writing revision log.", e);
                        logMessage.append("Exception while writing revision log.");
                        Object var15_20 = null;
                        try {
                            if (revLogFileWriter != null) {
                                revLogFileWriter.close();
                            }
                            break block37;
                        }
                        catch (IOException ioe) {}
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    try {
                        if (revLogFileWriter != null) {
                            revLogFileWriter.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            log.info((Object)"Revision logs not created for versioned builds");
        }
        if (properties.isSendEmailPolicyFailedOnlySelected() && def.getErrorFlag() && (properties.getLastBuildSucceededFlag() || !def.isLoginError()) || properties.isSendEmailPolicyAlwaysSelected()) {
            try {
                PageletResultEmail.send(def);
            }
            catch (PageletException e) {
                log.error((Object)"couldn't send result email", (Throwable)e);
            }
        }
        this.saveBuildDate(def, buildDate);
    }

    protected void tagProject(BuildDefinition def, RepositoryAdapter radapter) throws RepositoryException {
        if (def.getVersionedBuildFlag()) {
            def.appendLogMessage("Tag: Bypassed for Versioned Builds").appendLogMessage("\n");
        } else {
            radapter.label(radapter.makeTagFromVersion(def.getVersion()));
            def.appendLogMessage("Tag: OK").appendLogMessage("\n");
        }
    }

    protected void loadRevisions(BuildDefinition buildDef, RepositoryAdapter adapter) {
        ProjectProperties properties = buildDef.getProject().getProperties();
        try {
            if (properties.getLastGoodBuildDate() != null) {
                List revList = adapter.getRevisionsSince(properties.getLastGoodBuildDate());
                if (revList != null) {
                    Collections.sort(revList);
                }
                buildDef.setRevisionList(revList);
                buildDef.appendLogMessage("Got Revisions: OK\n");
                buildDef.setLoginError(false);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            buildDef.appendLogMessage("FAILED to get revision list.  Message: ").appendLogMessage(e.getMessage()).appendLogMessage("\n");
            buildDef.setErrorFlag(true);
            buildDef.setLoginError(true);
        }
    }

    protected boolean requiresBuild(BuildDefinition buildDef, RepositoryAdapter adapter) {
        boolean requiresBuild = true;
        List revList = null;
        ProjectProperties properties = buildDef.getProject().getProperties();
        Date needRevisionsSinceDate = null;
        Date lastGoodDate = null;
        Date lastFailDate = null;
        if (properties.getLastBuildSucceededFlag()) {
            needRevisionsSinceDate = lastGoodDate = properties.getLastGoodBuildDate();
            log.debug((Object)("last good build date: " + lastGoodDate));
        } else {
            lastFailDate = properties.getLastBuildFailDate();
            log.debug((Object)("last build fail date: " + lastFailDate));
            if (lastFailDate != null) {
                needRevisionsSinceDate = lastFailDate;
            }
        }
        try {
            if (needRevisionsSinceDate == null) {
                requiresBuild = true;
                log.info((Object)"Build required - no last build date exists");
            } else {
                revList = adapter.getRevisionsSince(needRevisionsSinceDate);
                buildDef.appendLogMessage("Got Revisions: OK\n");
                requiresBuild = revList != null && !revList.isEmpty();
                if (!requiresBuild) {
                    log.info((Object)"Build NOT required");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            buildDef.appendLogMessage("FAILED to get revision list.  Message: ").appendLogMessage(e.getMessage()).appendLogMessage("\n");
            buildDef.setErrorFlag(true);
        }
        buildDef.setRequiresBuildFlag(requiresBuild);
        return requiresBuild;
    }

    protected void runBuild(BuildDefinition buildDef) {
        StringBuffer logMessage = new StringBuffer();
        ProjectProperties properties = buildDef.getProject().getProperties();
        String anthillUrl = properties.getAnthillUrl();
        String buildUrl = null;
        String pubUrl = properties.getPublishUrl();
        String projectName = buildDef.getProject().getName();
        if (pubUrl.equals("") || pubUrl == null) {
            buildUrl = anthillUrl + "projects/" + URLEncoder.encode(projectName);
        }
        if (pubUrl != null && !pubUrl.equals("")) {
            buildUrl = pubUrl;
        }
        logMessage.append("Project Site: " + buildUrl + "/\n\n").append("Build Log: " + buildUrl + "/buildLogs/").append(URLEncoder.encode(projectName) + "-" + buildDef.getVersion() + "-build.log\n");
        try {
            log.info((Object)"Build Project: ");
            this.buildProject(buildDef);
            buildDef.appendLogMessage("Build: OK\n");
            buildDef.appendLogMessage(logMessage.toString());
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            buildDef.appendLogMessage("FAILED to run build script.  Message: ").appendLogMessage(e.getMessage()).appendLogMessage("\n").appendLogMessage(logMessage.toString());
            buildDef.setErrorFlag(true);
        }
    }

    protected void buildProject(BuildDefinition buildDef) throws Exception {
        AnthillProject project = buildDef.getProject();
        ProjectProperties properties = buildDef.getProject().getProperties();
        ArrayList<String> cmdList = new ArrayList<String>();
        String[] cmdArray = null;
        String antHome = project.getAnthillDefaults().calculateAntHome();
        String antBinDir = antHome + File.separator + "bin" + File.separator;
        String executable = "null";
        if (userOS.equals(WINDOWS_OS)) {
            cmdList.add("cmd");
            cmdList.add("/x/c");
            executable = antBinDir + "ant.bat";
        } else {
            executable = antBinDir + "ant";
        }
        cmdList.add(executable);
        String[] jvmEnvVarArray = null;
        String strJavaOptions = properties.getJavaExtraOptions();
        jvmEnvVarArray = strJavaOptions != null && !strJavaOptions.equals("") ? new String[]{"ANT_OPTS=" + strJavaOptions, "ANT_HOME=" + antHome} : new String[]{"ANT_HOME=" + antHome};
        String deployDir = "-DdeployDir=" + properties.getProjectPublishDirName();
        cmdList.add(deployDir);
        cmdList.add("-Dversion=" + buildDef.getVersion());
        cmdList.add("-Dkit=" + buildDef.getVersion());
        String buildFile = properties.getLocalBuildScriptFilePath();
        cmdList.add("-buildfile");
        cmdList.add(buildFile);
        String logFile = properties.getBuildLogDir() + project.getProjectName() + "-" + buildDef.getVersion() + "-build.log";
        cmdList.add("-logfile");
        cmdList.add(logFile);
        Iterator keys = properties.getBuildAntParams().iterator();
        while (keys.hasNext()) {
            cmdList.add((String)keys.next());
        }
        Iterator pitr = buildDef.getAntParamIterator();
        while (pitr.hasNext()) {
            cmdList.add((String)pitr.next());
        }
        File workDir = new File(properties.getLocalBuildScriptFilePath()).getParentFile();
        cmdArray = new String[cmdList.size()];
        cmdArray = cmdList.toArray(cmdArray);
        log.info((Object)("Build Command: " + this.doStringArray2String(cmdArray)));
        int exitCode = 0;
        Execute exe = new Execute();
        exe.setCommandline(cmdArray);
        exe.setLogger(log);
        exe.setWorkingDirectory(workDir);
        exe.setEnvironment(jvmEnvVarArray);
        exitCode = exe.execute();
        if (exitCode != 0) {
            throw new Exception("Failed to Build project. Error: " + exitCode);
        }
    }

    protected void publish(BuildDefinition buildDef) {
        StringBuffer logMessage = new StringBuffer();
        AnthillProject project = buildDef.getProject();
        ProjectProperties properties = project.getProperties();
        if (properties.getLocalPublishScriptFilePath() == null || properties.getLocalPublishScriptFilePath().equals("")) {
            buildDef.appendLogMessage("\nPublish: NOT REQUIRED\n");
        } else {
            String anthillUrl = properties.getAnthillUrl();
            String buildUrl = null;
            String pubUrl = properties.getPublishUrl();
            if (pubUrl.equals("") || pubUrl == null) {
                buildUrl = anthillUrl + "projects/" + project.getProjectName();
            }
            if (pubUrl != null && !pubUrl.equals("")) {
                buildUrl = pubUrl;
            }
            logMessage.append("Publish Log: " + buildUrl + "/buildLogs/").append(project.getProjectName() + "-" + buildDef.getVersion() + "-publish.log\n");
            try {
                log.info((Object)"Publish Project: ");
                this.publishProject(buildDef);
                buildDef.appendLogMessage("\nPublish: OK\n");
                buildDef.appendLogMessage(logMessage.toString());
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                buildDef.appendLogMessage("FAILED to run publish script.  Message: ").appendLogMessage(e.getMessage()).appendLogMessage("\n");
                buildDef.appendLogMessage(logMessage.toString());
                buildDef.setErrorFlag(true);
            }
        }
    }

    protected void publishProject(BuildDefinition buildDef) throws Exception {
        AnthillProject project = buildDef.getProject();
        ProjectProperties properties = project.getProperties();
        ArrayList<String> cmdList = new ArrayList<String>();
        String[] cmdArray = null;
        File publishDir = new File(properties.getProjectPublishDirName());
        String publishDirAbsPath = publishDir.getAbsolutePath();
        String antHome = project.getAnthillDefaults().calculateAntHome();
        String antBinDir = antHome + File.separator + "bin" + File.separator;
        String executable = null;
        executable = userOS.equals(WINDOWS_OS) ? antBinDir + "ant.bat" : antBinDir + "ant";
        cmdList.add(executable);
        String[] jvmEnvVarArray = null;
        String strJavaOptions = properties.getJavaExtraOptions();
        jvmEnvVarArray = strJavaOptions != null && !strJavaOptions.equals("") ? new String[]{"ANT_OPTS=" + strJavaOptions, "ANT_HOME=" + antHome} : new String[]{"ANT_HOME=" + antHome};
        String deployDir = "-DdeployDir=" + publishDirAbsPath;
        cmdList.add(deployDir);
        cmdList.add("-Dversion=" + buildDef.getVersion());
        String buildFile = properties.getLocalPublishScriptFilePath();
        cmdList.add("-buildfile");
        cmdList.add(buildFile);
        String logFile = properties.getBuildLogDir() + project.getProjectName() + "-" + buildDef.getVersion() + "-publish.log";
        cmdList.add("-logfile");
        cmdList.add(logFile);
        Iterator keys = properties.getPubAntParams().iterator();
        while (keys.hasNext()) {
            cmdList.add((String)keys.next());
        }
        Iterator pitr = buildDef.getAntParamIterator();
        while (pitr.hasNext()) {
            cmdList.add((String)pitr.next());
        }
        cmdArray = new String[cmdList.size()];
        cmdArray = cmdList.toArray(cmdArray);
        File workDir = new File(properties.getLocalPublishScriptFilePath()).getParentFile();
        log.info((Object)("Publish Command: " + this.doStringArray2String(cmdArray)));
        Execute exe = new Execute();
        exe.setCommandline(cmdArray);
        exe.setLogger(log);
        exe.setWorkingDirectory(workDir);
        exe.setEnvironment(jvmEnvVarArray);
        int exitCode = exe.execute();
        if (exitCode != 0) {
            throw new Exception("Failed to Publish project.");
        }
    }

    protected void saveBuildDate(BuildDefinition buildDef, Date buildDate) {
        ProjectProperties properties = buildDef.getProject().getProperties();
        if (!buildDef.getErrorFlag()) {
            if (buildDef.getRequiresBuildFlag() || buildDef.getForceBuildFlag()) {
                properties.setLastGoodBuildDate(buildDate);
                properties.setLastBuildSucceededFlag(true);
            }
        } else {
            properties.setLastBuildFailDate(buildDate);
            properties.setLastBuildSucceededFlag(false);
        }
        try {
            buildDef.getProject().save();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private StringBuffer appendAllKeyValues(Map paramMap, String optionStr) {
        StringBuffer buffer = new StringBuffer();
        Iterator keys = paramMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)paramMap.get(key);
            if (optionStr != null) {
                buffer.append(optionStr);
            }
            buffer.append(key).append("=").append(value).append(" ");
        }
        return buffer;
    }

    private StringBuffer appendAllKeyValues(List paramMap) {
        StringBuffer buffer = new StringBuffer();
        Iterator keys = paramMap.iterator();
        while (keys.hasNext()) {
            buffer.append(keys.next()).append(" ");
        }
        return buffer;
    }

    protected String doStringArray2String(String[] array) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (first) {
                first = false;
            } else {
                result.append(" ");
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        userOS = System.getProperty("os.name");
        userOS = userOS.indexOf("Windows") != -1 ? WINDOWS_OS : UNIX_OS;
    }
}

