/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.AnthillSchedule;
import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.Buildable;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.registry.RegistryEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DependencyGroup
implements Buildable {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$DependencyGroup == null ? (class$com$urbancode$anthill$DependencyGroup = DependencyGroup.class$("com.urbancode.anthill.DependencyGroup")) : class$com$urbancode$anthill$DependencyGroup).getName());
    public static final String DEPENDENCY_GROUP_FILE_SUFFIX = ".dependencies";
    public static final String ARTIFACT_DIR_NAME = "artifacts";
    public static final String SCHEDULE_KEY = "schedule";
    public static final String MEMBER_KEY = "member";
    public static final String PROJECT_KEY = "project";
    public static final String DEPENDENCY_KEY = "dependency";
    public static final String TARGET_KEY = "target";
    protected Anthill anthill = null;
    protected String name = null;
    protected List memberList = new ArrayList();
    protected Map name2member = new HashMap();
    protected File file = null;
    protected RegistryEntry rootEntry = null;
    protected Registry registry = null;
    protected AnthillSchedule schedule = null;
    protected boolean initialized = true;
    static /* synthetic */ Class class$com$urbancode$anthill$DependencyGroup;

    public DependencyGroup(Anthill anthill, File regFile) throws Exception {
        this.anthill = anthill;
        this.setName(FileUtils.getNameMinusExtension(regFile));
        this.file = regFile;
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.registry = Registry.loadFile((File)this.file);
        this.rootEntry = this.registry.getRootRegistryEntry();
        this.restore();
    }

    protected void restore() throws Exception {
        String scheduleName = this.rootEntry.getKeyValue(SCHEDULE_KEY);
        if (scheduleName != null) {
            this.schedule = this.anthill.getSchedule(scheduleName);
            if (this.schedule != null) {
                this.schedule.add(this);
            } else {
                log.error((Object)("DependencyGroup points to a non existing schedule: " + scheduleName));
                throw new IllegalStateException("DependencyGroup points to a non existing schedule: " + scheduleName);
            }
        }
        Iterator itr = null;
        RegistryEntry memberEntry = null;
        String projectName = null;
        Member member = null;
        AnthillProject project = null;
        itr = this.rootEntry.getChildRegistryEntries(MEMBER_KEY);
        while (itr.hasNext()) {
            memberEntry = (RegistryEntry)itr.next();
            projectName = memberEntry.getKeyValue(PROJECT_KEY);
            project = this.anthill.getProject(projectName);
            if (project == null) {
                log.error((Object)("DependencyGroup points to a nonexisting project: " + projectName));
                throw new IllegalStateException("DependencyGroup points to a nonexisting project: " + projectName);
            }
            member = this.createNewMember(project);
        }
        Iterator depItr = null;
        String depName = null;
        Object forceBuildStr = null;
        Member depMember = null;
        RegistryEntry depEntry = null;
        itr = this.rootEntry.getChildRegistryEntries(MEMBER_KEY);
        while (itr.hasNext()) {
            memberEntry = (RegistryEntry)itr.next();
            projectName = memberEntry.getKeyValue(PROJECT_KEY);
            member = (Member)this.name2member.get(projectName);
            depItr = memberEntry.getKeyValues(DEPENDENCY_KEY);
            while (depItr.hasNext()) {
                depName = (String)depItr.next();
                depMember = (Member)this.name2member.get(depName);
                if (depMember == null) {
                    log.error((Object)("DependencyGroup member: " + projectName + "points to a nonexisting " + "dependency: " + depName));
                    throw new IllegalStateException("DependencyGroup member: " + projectName + "points to a nonexisting " + "dependency: " + depName);
                }
                depEntry = memberEntry.getChildRegistryEntry("dependency." + depName);
                member.addDependency(depMember);
            }
        }
        this.initialized = true;
    }

    protected void store() throws Exception {
        this.registry.clear();
        if (this.schedule != null) {
            this.rootEntry.setKeyValue(SCHEDULE_KEY, this.schedule.getScheduleName());
        }
        Iterator itr = null;
        Iterator depItr = null;
        Object regEntry = null;
        RegistryEntry memberEntry = null;
        Member member = null;
        Member depMember = null;
        itr = this.getMemberIterator();
        while (itr.hasNext()) {
            member = (Member)itr.next();
            memberEntry = this.rootEntry.addKeyValue("member.project", member.getName());
            depItr = member.getDependencyIterator();
            while (depItr.hasNext()) {
                depMember = (Member)depItr.next();
                memberEntry.addKeyValue(DEPENDENCY_KEY, depMember.getName());
            }
        }
    }

    public void save() throws Exception {
        this.store();
        if (this.file != null) {
            if (!this.name.equals(FileUtils.getNameMinusExtension(this.file))) {
                this.file.delete();
                this.file = null;
            } else {
                try {
                    this.registry.updateRegistryFile();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
        if (this.file == null) {
            File projectsDir = this.anthill.getAnthillProjectsDir();
            this.file = new File(projectsDir, this.name + DEPENDENCY_GROUP_FILE_SUFFIX);
            try {
                this.registry.setRegistryFile(this.file);
                this.registry.updateRegistryFile();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        log.debug((Object)"Saved");
    }

    public void doScheduleNameChanged(AnthillSchedule mySchedule) throws Exception {
        this.save();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        if (oldName != null && !oldName.equals(name)) {
            this.anthill.doDependencyGroupNameChange(oldName);
        }
    }

    public void setSchedule(AnthillSchedule newSchedule) {
        if (this.schedule != null && !this.schedule.equals(newSchedule)) {
            this.schedule.remove(this);
        }
        if (newSchedule != null && !newSchedule.equals(this.schedule)) {
            newSchedule.add(this);
        }
        this.schedule = newSchedule;
    }

    public AnthillSchedule getSchedule() {
        return this.schedule;
    }

    public Member createNewMember(AnthillProject project) {
        Member member = null;
        member = new Member(project);
        this.memberList.add(member);
        this.name2member.put(project.getProjectName(), member);
        return member;
    }

    public void deleteMember(Member member) {
        this.name2member.remove(member.getName());
        this.memberList.remove(member);
    }

    public Member getMember(String name) {
        return (Member)this.name2member.get(name);
    }

    public Iterator getMemberIterator() {
        return this.memberList.iterator();
    }

    public Iterator getPotentialProjectIterator() {
        ArrayList tempList = new ArrayList();
        Iterator projectItr = this.anthill.getProjectIterator();
        while (projectItr.hasNext()) {
            tempList.add(projectItr.next());
        }
        Member member = null;
        Iterator itr = this.getMemberIterator();
        while (itr.hasNext()) {
            member = (Member)itr.next();
            tempList.remove(member.getProject());
        }
        return tempList.iterator();
    }

    public void run() {
        ArrayList buildList = new ArrayList(this.memberList);
        Object memberItr = null;
        Member member = null;
        log.debug((Object)("run  - inside DepGroup " + this.getName()));
        Object tempMember = null;
        Scope scope = new Scope();
        int i = 0;
        boolean forceFlag = false;
        boolean tempForceFlag = false;
        while (!buildList.isEmpty()) {
            i = 0;
            while (i < buildList.size()) {
                member = (Member)buildList.get(i);
                if (member.areDependenciesBuilt(scope)) {
                    while (this.anthill.isQueuePaused()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    tempForceFlag = member.getBuildDefinition().getForceBuildFlag();
                    if (tempForceFlag || forceFlag) {
                        member.getBuildDefinition().setForceBuildFlag(true);
                    }
                    log.info((Object)("inside run " + member.getName()));
                    log.info((Object)("inside run buildDef forced: " + member.getBuildDefinition().getForceBuildFlag()));
                    log.info((Object)("inside run buildDef areDependenciesSuccessfullyBuilt: " + member.areDependenciesSuccessfullyBuilt(scope)));
                    member.build(scope);
                    buildList.remove(i);
                    if ((member.getBuildDefinition().getRequiresBuildFlag() || member.getBuildDefinition().getForceBuildFlag()) && !member.getBuildDefinition().getErrorFlag()) {
                        forceFlag = true;
                    }
                    member.resetBuildDefinition();
                    continue;
                }
                ++i;
            }
        }
    }

    public static Logger getLog() {
        return log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Scope {
        protected Set builtSet = new HashSet();
        protected Set successfullyBuiltSet = new HashSet();

        public void setBuilt(Member dependency, boolean flag) {
            if (flag) {
                this.builtSet.add(dependency);
            } else {
                this.builtSet.remove(dependency);
            }
        }

        public void setSuccessfullyBuilt(Member dependency, boolean flag) {
            if (flag) {
                this.successfullyBuiltSet.add(dependency);
            } else {
                this.successfullyBuiltSet.remove(dependency);
            }
        }

        public boolean isBuilt(Member dependency) {
            boolean result = this.builtSet.contains(dependency);
            return result;
        }

        public boolean isSuccessfullyBuilt(Member dependency) {
            boolean result = this.successfullyBuiltSet.contains(dependency);
            return result;
        }
    }

    public class Member {
        protected AnthillProject project = null;
        protected List dependencyList = new ArrayList();
        protected Map name2dependency = new HashMap();
        protected BuildDefinition buildDef = null;

        protected Member(AnthillProject project) {
            this.project = project;
        }

        public BuildDefinition getBuildDefinition() {
            if (this.buildDef == null) {
                this.buildDef = new BuildDefinition();
                this.buildDef.setProject(this.project);
                ProjectProperties properties = this.project.getProperties();
                File publishRootDir = properties.getAnthillDefaultPublishDir();
                File properPath = FileUtils.makeProperPath(publishRootDir, "depDir" + File.separatorChar + DependencyGroup.this.getName());
                if (!properPath.exists()) {
                    properPath.mkdirs();
                }
                String path = properPath.getAbsolutePath();
                this.buildDef.addAntParam("-D" + properties.getDependencyArtifactProperty() + "=" + path);
                String depTargetName = properties.getDependencyTargetName();
                if (depTargetName != null && !depTargetName.equals("")) {
                    this.buildDef.addAntParam(depTargetName);
                }
            }
            return this.buildDef;
        }

        public String getName() {
            String name = null;
            name = this.project != null ? this.project.getProjectName() : null;
            return name;
        }

        public AnthillProject getProject() {
            return this.project;
        }

        public void setProject(AnthillProject project) {
            this.project = project;
        }

        public void addDependency(Member dependency) {
            this.dependencyList.add(dependency);
            this.name2dependency.put(dependency.getName(), dependency);
        }

        public void deleteDependency(Member dependency) {
            this.dependencyList.remove(dependency);
            this.name2dependency.remove(dependency.getName());
        }

        public Member getDependency(String name) {
            return (Member)this.name2dependency.get(name);
        }

        public Iterator getDependencyIterator() {
            return this.dependencyList.iterator();
        }

        public Iterator getPotentialDependencyIterator() {
            List tempList = (List)((ArrayList)DependencyGroup.this.memberList).clone();
            tempList.removeAll(this.dependencyList);
            tempList.remove(this);
            Iterator itr = tempList.iterator();
            Member member = null;
            while (itr.hasNext()) {
                member = (Member)itr.next();
                if (!member.isDependency(this)) continue;
                itr.remove();
            }
            return tempList.iterator();
        }

        public boolean isDependency(Member dependency) {
            Member tempDep = null;
            boolean result = false;
            for (int i = 0; i < this.dependencyList.size(); ++i) {
                tempDep = (Member)this.dependencyList.get(i);
                if (tempDep.equals(dependency)) {
                    result = true;
                    break;
                }
                if (!tempDep.isDependency(dependency)) continue;
                result = true;
                break;
            }
            return result;
        }

        public boolean isBuilt(Scope scope) {
            return scope.isBuilt(this);
        }

        public boolean isSuccessfullyBuilt(Scope scope) {
            return scope.isSuccessfullyBuilt(this);
        }

        public void build(Scope scope) {
            BuildDefinition buildDef = this.getBuildDefinition();
            buildDef.setVersion(null);
            boolean areDependenciesSuccessfullyBuilt = false;
            if (this.areDependenciesSuccessfullyBuilt(scope)) {
                areDependenciesSuccessfullyBuilt = true;
                DependencyGroup.getLog().info((Object)("inside build - dependencies (if any exist) are successfully built, so performing build of " + this.getName()));
                buildDef.run();
            } else {
                DependencyGroup.getLog().info((Object)("inside build - dependencies are NOT successfully built, so NOT performing build of " + this.getName() + " (EVEN if it was forced)"));
            }
            boolean lastBuildSucceeded = false;
            if (this.getProject().getProperties().getLastBuildSucceededFlag()) {
                lastBuildSucceeded = true;
            } else {
                DependencyGroup.getLog().info((Object)("inside build - last build of " + this.getName() + " was NOT successful"));
            }
            if (areDependenciesSuccessfullyBuilt && lastBuildSucceeded) {
                DependencyGroup.getLog().info((Object)("inside build - for " + this.getName() + ", dependencies are successfully built,  and it's last build was successful, so flagging it as a successful build."));
                scope.setSuccessfullyBuilt(this, true);
            }
            scope.setBuilt(this, true);
        }

        public boolean areDependenciesBuilt(Scope scope) {
            Member tempDep = null;
            boolean result = false;
            if (this.dependencyList.isEmpty()) {
                result = true;
            } else {
                result = true;
                for (int i = 0; i < this.dependencyList.size(); ++i) {
                    tempDep = (Member)this.dependencyList.get(i);
                    if (tempDep.isBuilt(scope)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        public boolean areDependenciesSuccessfullyBuilt(Scope scope) {
            Member tempDep = null;
            boolean result = false;
            if (this.dependencyList.isEmpty()) {
                result = true;
            } else {
                result = true;
                for (int i = 0; i < this.dependencyList.size(); ++i) {
                    tempDep = (Member)this.dependencyList.get(i);
                    if (tempDep.isSuccessfullyBuilt(scope)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        public void resetBuildDefinition() {
            this.buildDef.reset();
        }
    }
}

