/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillBuildException;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.AnthillSchedule;
import com.urbancode.anthill.PropertyFilter0to1;
import com.urbancode.anthill.adapter.RepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryAdapterFactory;
import com.urbancode.anthill.adapter.VersionAdapter;
import com.urbancode.anthill.adapter.VersionAdapterFactory;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.registry.RegistryEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectProperties {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$ProjectProperties == null ? (class$com$urbancode$anthill$ProjectProperties = ProjectProperties.class$("com.urbancode.anthill.ProjectProperties")) : class$com$urbancode$anthill$ProjectProperties).getName());
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final String ANTHILL_FILE_SUFFIX = ".anthill";
    public static final String REGISTRY_ENTRY_KEY = "anthill";
    public static final String PROJECT_NAME = "project.name";
    public static final String BUILD_SCRIPT_PATH = "build.script";
    public static final String PARAMS = "params";
    public static final String BUILD_SCRIPT_SYS_PARAMS = "build";
    public static final String BUILD_SCRIPT_ANT_PARAMS = "build.ant";
    public static final String BUILD_SCRIPT_PARAMS = "build.params";
    public static final String PUBLISH_SCRIPT_PATH = "publish.script";
    public static final String PUBLISH_SCRIPT_RUN_POLICY = "publish.run_policy";
    public static final String PUBLISH_SCRIPT_SYS_PARAMS = "publish";
    public static final String PUBLISH_SCRIPT_ANT_PARAMS = "publish.ant";
    public static final String PUBLISH_SCRIPT_PARAMS = "publish.params";
    public static final String BUILD_ANT_PARAM_NAME_KEY = "build.ant.params.name";
    public static final String PUB_ANT_PARAM_NAME_KEY = "publish.ant.params.name";
    public static final String BUILD_ANT_PARAM_VALUE_KEY = "build.ant.params.value";
    public static final String PUB_ANT_PARAM_VALUE_KEY = "publish.ant.params.value";
    public static final String BUILD_ANT_PARAMS = "build.ant.params";
    public static final String PUB_ANT_PARAMS = "publish.ant.params";
    public static final String TAG_BUILD = "build.tag";
    public static final String EMAIL_POLICY = "mail.policy";
    public static final String BUILD_PUB_PARAM_VALUE_KEY = "value";
    public static final String PUBLISH_DIR_NAME = "publish.dir";
    public static final String VERSION_ADAPTER = "version.adapter";
    public static final String VERSION_FILE_PATH = "version.file";
    public static final String VERSION_PROPERTIES = "version";
    public static final String REPOSITORY_ADAPTER = "repository.adapter";
    public static final String REPOSITORY_PROPERTIES = "repository";
    public static final String SCHEDULE_KEY = "schedule";
    public static final String MAIL_HOST_KEY = "mail.host";
    public static final String MAIL_FROM_KEY = "mail.from";
    public static final String USER_KEY = "users";
    public static final String LAST_GOOD_BUILD_DATE_KEY = "lastGoodBuildDate";
    public static final String LAST_BUILD_FAIL_DATE_KEY = "lastBuildFailDate";
    public static final String LAST_BUILD_SUCCEEDED_KEY = "lastBuildSucceeded";
    public static final String ANTHILL_URL_KEY = "server";
    public static final String PUBLISH_URL_KEY = "publish.url";
    public static final String LOCK_VERSION_KEY = "lock.version.file";
    public static final String TARGETS_KEY = "targets";
    public static final String DEFAULT_WORK_DIR = "work.dir";
    public static final String WORK_DIR_KEY = "repository.cvs.work.dir";
    public static final String DEPENDENCY_TARGET_KEY = "dependency.target";
    public static final String DEPENDENCY_ARTIFACT_PROP_KEY = "dependency.artifact.property";
    public static final String REGISTRY_FORMAT_VERSION = "registry.format.version";
    public static final String PROJECT_VERSION = "project.version";
    public static final String CVS_BRANCH_KEY = "repository.cvs.branch";
    public static final String TAG_BUILD_ALL = "all";
    public static final String TAG_BUILD_SUCCESS = "success";
    public static final String TAG_BUILD_NONE = "none";
    public static final String SEND_EMAIL_POLICY_ALWAYS = "always";
    public static final String SEND_EMAIL_POLICY_FAILED_ONLY = "failed.only";
    public static final String PUBLISH_RUN_POLICY_ALWAYS = "always";
    public static final String PUBLISH_RUN_POLICY_SUCCESS_ONLY = "success.only";
    public static final String JAVA_EXTRA_OPTIONS = "java.extra.options";
    protected Anthill anthill = null;
    protected AnthillProject project = null;
    protected File file = null;
    protected Registry registry = null;
    protected RegistryEntry projectRegEntry = null;
    protected RepositoryAdapter repositoryAdapter = null;
    protected VersionAdapter versionAdapter = null;
    protected AnthillSchedule schedule = null;
    protected String repositoryAdapterName = null;
    protected String versionAdapterName = null;
    protected String scheduleName = null;
    protected String anthillUrl = null;
    protected String publishUrl = null;
    protected Map buildSysParams = new HashMap();
    protected Map pubSysParams = new HashMap();
    protected List buildAntParams = new ArrayList();
    protected List pubAntParams = new ArrayList();
    protected String publishRunPolicy = null;
    protected Map notificationUserMap = new HashMap();
    protected String mailHost = null;
    protected String mailFrom = null;
    protected String lastGoodBuildDate = null;
    protected String lastBuildFailDate = null;
    protected String lastBuildSucceeded = null;
    protected String buildScriptPath = null;
    protected String publishScriptPath = null;
    protected String publishDirName = null;
    protected String workDir = null;
    protected String dependencyTargetName = null;
    protected String dependencyArtifactProp = null;
    protected String tagBuild = "success";
    protected String sendEmail = "always";
    protected String javaExtraOptions = "";
    static /* synthetic */ Class class$com$urbancode$anthill$ProjectProperties;

    public ProjectProperties(Anthill anthill, AnthillProject project) throws Exception {
        this.anthill = anthill;
        this.project = project;
        this.registry = Registry.createRegistry();
        this.projectRegEntry = this.registry.createChildRegistryEntry(REGISTRY_ENTRY_KEY);
        this.setupProperties(this.projectRegEntry);
        this.projectRegEntry.addKeyValue(REGISTRY_FORMAT_VERSION, "1.1");
    }

    public ProjectProperties(Anthill anthill, AnthillProject project, File regFile) throws FileNotFoundException, Exception {
        this.anthill = anthill;
        this.project = project;
        this.registry = Registry.loadFile((File)regFile);
        File projectFile = new File(anthill.getAnthillProjectsDir() + File.separator + project.getProjectName() + ANTHILL_FILE_SUFFIX);
        PropertyFilter0to1 pf = new PropertyFilter0to1(this.registry, projectFile);
        this.projectRegEntry = this.registry.getRegistryEntry(REGISTRY_ENTRY_KEY);
        this.setupProperties(this.projectRegEntry);
    }

    public ProjectProperties(Anthill anthill, AnthillProject project, Registry registry) throws Exception {
        this.anthill = anthill;
        this.project = project;
        this.registry = registry;
        File projectFile = new File(anthill.getAnthillProjectsDir() + File.separator + project.getProjectName() + ANTHILL_FILE_SUFFIX);
        PropertyFilter0to1 pf = new PropertyFilter0to1(registry, projectFile);
        this.projectRegEntry = registry.getRegistryEntry(REGISTRY_ENTRY_KEY);
        this.setupProperties(this.projectRegEntry);
    }

    public ProjectProperties mergeProperties(RegistryEntry regEntry) throws Exception {
        ProjectProperties properties = new ProjectProperties(this.anthill, this.project, this.registry);
        properties.setupProperties(this.projectRegEntry);
        properties.setupProperties(regEntry);
        return properties;
    }

    public RegistryEntry addProperty(String name, String value) {
        return this.projectRegEntry.addKeyValue(name, value);
    }

    public String getProperty(String propName) {
        String propValue = this.projectRegEntry.getKeyValue(propName);
        if (propValue == null) {
            propValue = this.anthill.getAnthillConfig().getProperty(propName);
        }
        return propValue;
    }

    public RegistryEntry setProperty(String name, String value) {
        return this.projectRegEntry.setKeyValue(name, value);
    }

    public RepositoryAdapter getRepositoryAdapter() {
        if (this.repositoryAdapter == null || !this.repositoryAdapter.getClass().getName().equals(this.repositoryAdapterName)) {
            try {
                this.repositoryAdapter = RepositoryAdapterFactory.getRepositoryAdapter(this.project, this.repositoryAdapterName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("exception while getting " + this.repositoryAdapterName + " instance: " + e.getMessage());
            }
        }
        return this.repositoryAdapter;
    }

    public String getRepositoryAdapterName() {
        return this.repositoryAdapterName;
    }

    public void setRepositoryAdapterName(String repositoryAdapterName) {
        this.setProperty(REPOSITORY_ADAPTER, repositoryAdapterName);
        this.repositoryAdapterName = repositoryAdapterName;
        this.repositoryAdapter = null;
    }

    public VersionAdapter getVersionAdapter() {
        if (this.versionAdapter == null || !this.versionAdapter.getClass().getName().equals(this.versionAdapterName)) {
            try {
                this.versionAdapter = VersionAdapterFactory.getVersionAdapter(this.project, this.versionAdapterName);
            }
            catch (Exception e) {
                throw new IllegalStateException("exception while getting " + this.versionAdapterName + " instance: " + e.getMessage());
            }
        }
        return this.versionAdapter;
    }

    public String getVersionAdapterName() {
        return this.versionAdapterName;
    }

    public void setVersionAdapterName(String versionAdapterName) {
        this.setProperty(VERSION_ADAPTER, versionAdapterName);
        this.versionAdapterName = versionAdapterName;
        this.versionAdapter = null;
    }

    public AnthillSchedule getSchedule() {
        return this.schedule;
    }

    public void setScheduleName(String scheduleName) {
        this.setProperty(SCHEDULE_KEY, scheduleName);
        this.scheduleName = scheduleName;
    }

    public String getAnthillUrl() {
        return this.anthillUrl;
    }

    public void setAnthillUrl(String anthillUrl) {
        this.setProperty(ANTHILL_URL_KEY, anthillUrl);
        this.anthillUrl = anthillUrl;
    }

    public String getPublishUrl() {
        return this.publishUrl;
    }

    public void setPublishUrl(String publishUrl) {
        this.setProperty(PUBLISH_URL_KEY, publishUrl);
        this.publishUrl = publishUrl;
    }

    public String getMailHost() {
        return this.anthill.getAnthillConfig().getProperty(MAIL_HOST_KEY);
    }

    public void setMailHost(String mailHost) {
        this.anthill.getAnthillConfig().setProperty(MAIL_HOST_KEY, mailHost);
        this.mailHost = mailHost;
    }

    public String getMailFrom() {
        return this.anthill.getAnthillConfig().getProperty(MAIL_FROM_KEY);
    }

    public void setMailFrom(String mailFrom) {
        this.anthill.getAnthillConfig().setProperty(MAIL_FROM_KEY, mailFrom);
        this.mailFrom = mailFrom;
    }

    public Date getLastGoodBuildDate() {
        Date date = null;
        if (this.lastGoodBuildDate != null) {
            try {
                date = DATE_FORMAT.parse(this.lastGoodBuildDate);
            }
            catch (ParseException pe) {
                log.error((Object)"exception parsing lastGoodBuildDate", (Throwable)pe);
            }
        }
        return date;
    }

    public void setLastGoodBuildDate(Date date) {
        String dateStr = DATE_FORMAT.format(date);
        this.setProperty(LAST_GOOD_BUILD_DATE_KEY, dateStr);
        this.lastGoodBuildDate = dateStr;
    }

    public Date getLastBuildFailDate() {
        Date date = null;
        if (this.lastBuildFailDate != null) {
            try {
                date = DATE_FORMAT.parse(this.lastBuildFailDate);
            }
            catch (ParseException pe) {
                log.error((Object)"exception parsing lastBuildFailDate", (Throwable)pe);
            }
        }
        return date;
    }

    public void setLastBuildFailDate(Date date) {
        String dateStr = DATE_FORMAT.format(date);
        this.setProperty(LAST_BUILD_FAIL_DATE_KEY, dateStr);
        this.lastBuildFailDate = dateStr;
    }

    public boolean getLastBuildSucceededFlag() {
        return this.lastBuildSucceeded == null || this.lastBuildSucceeded.equals("true");
    }

    public void setLastBuildSucceededFlag(boolean succeededFlag) {
        String flagStr = succeededFlag ? "true" : "false";
        this.setProperty(LAST_BUILD_SUCCEEDED_KEY, flagStr);
        this.lastBuildSucceeded = flagStr;
    }

    public boolean isTagAllBuildsSelected() {
        return TAG_BUILD_ALL.equalsIgnoreCase(this.tagBuild);
    }

    public boolean isTagSuccessfulBuildSelected() {
        return TAG_BUILD_SUCCESS.equalsIgnoreCase(this.tagBuild) || !this.isTagAllBuildsSelected() && !this.isTagNoBuildsSelected();
    }

    public boolean isTagNoBuildsSelected() {
        return this.tagBuild.equalsIgnoreCase("no") || this.tagBuild.equalsIgnoreCase(TAG_BUILD_NONE);
    }

    public String getTagBuildSetting() {
        return this.tagBuild;
    }

    public boolean isSendEmailPolicyAlwaysSelected() {
        return "always".equalsIgnoreCase(this.sendEmail) || !this.isSendEmailPolicyFailedOnlySelected();
    }

    public boolean isSendEmailPolicyFailedOnlySelected() {
        return SEND_EMAIL_POLICY_FAILED_ONLY.equalsIgnoreCase(this.sendEmail);
    }

    public String getSendEmailPolicySetting() {
        return this.sendEmail;
    }

    public String getBuildScriptPath() {
        return this.buildScriptPath;
    }

    public String getLocalBuildScriptFilePath() {
        String localBuildScriptFilePath = this.project.getRepositoryAdapter().getLocalProjectDirName() + File.separator + this.buildScriptPath;
        localBuildScriptFilePath = FileUtils.getOSDependentPath(localBuildScriptFilePath);
        return localBuildScriptFilePath;
    }

    public String getPublishScriptPath() {
        return this.publishScriptPath;
    }

    public String getLocalPublishScriptFilePath() {
        String localPublishScriptFilePath = null;
        log.debug((Object)("publishScriptPath =" + this.publishScriptPath));
        if (this.publishScriptPath != null && !this.publishScriptPath.equals("")) {
            localPublishScriptFilePath = this.project.getRepositoryAdapter().getLocalProjectDirName() + File.separator + this.publishScriptPath;
        }
        if (localPublishScriptFilePath != null) {
            localPublishScriptFilePath = FileUtils.getOSDependentPath(localPublishScriptFilePath);
        }
        return localPublishScriptFilePath;
    }

    public String getPublishRunPolicy() {
        return this.publishRunPolicy;
    }

    public boolean isPublishRunPolicyAlways() {
        boolean result = false;
        if ("always".equals(this.publishRunPolicy)) {
            result = true;
        }
        return result;
    }

    public File getAnthillDefaultPublishDir() {
        return this.anthill.getAnthillDefaultPublishDir();
    }

    public String getPublishDir() {
        return this.publishDirName;
    }

    public String getProjectPublishDirName() {
        String dirName = this.publishDirName;
        if (dirName == null || dirName.equals("")) {
            dirName = this.project.getProjectName();
            File publishRootDir = this.anthill.getAnthillDefaultPublishDir();
            File properPath = FileUtils.makeProperPath(publishRootDir, dirName);
            dirName = properPath.getAbsolutePath();
        }
        return dirName;
    }

    public String getBuildLogDir() {
        String buildLogDirName = this.getProjectPublishDirName() + File.separator + "buildLogs" + File.separator;
        File buildLogDir = new File(buildLogDirName);
        if (!buildLogDir.exists()) {
            buildLogDir.mkdirs();
        }
        return buildLogDirName;
    }

    public String getDependencyTargetName() {
        if (this.dependencyTargetName == null) {
            return "dependency";
        }
        return this.dependencyTargetName;
    }

    public String getDependencyArtifactProperty() {
        if (this.dependencyArtifactProp == null) {
            return "dependency.artifact.dir";
        }
        return this.dependencyArtifactProp;
    }

    public void addBuildAntParam(String value) {
        RegistryEntry regEntry = this.addProperty(BUILD_ANT_PARAM_VALUE_KEY, value);
        this.buildAntParams.add(value);
        log.debug((Object)("adding build param: " + value));
    }

    public void addPubAntParam(String value) {
        RegistryEntry regEntry = this.addProperty(PUB_ANT_PARAM_VALUE_KEY, value);
        this.pubAntParams.add(value);
    }

    public List getBuildAntParams() {
        return this.buildAntParams;
    }

    public List getPubAntParams() {
        return this.pubAntParams;
    }

    public void removeBuildParamSysProperty(String key) {
        this.removeParamProperty(this.projectRegEntry.getChildRegistryEntry(BUILD_SCRIPT_SYS_PARAMS), key);
    }

    public void removeBuildParamAntProperty(String key) {
        this.removeParamProperty(this.projectRegEntry.getChildRegistryEntry(BUILD_SCRIPT_ANT_PARAMS), key);
        log.debug((Object)("trying to remove key: " + key));
        this.buildAntParams.remove(key);
    }

    public void removePublishParamSysProperty(String key) {
        this.removeParamProperty(this.projectRegEntry.getChildRegistryEntry(PUBLISH_SCRIPT_SYS_PARAMS), key);
    }

    public void removePublishParamAntProperty(String key) {
        this.removeParamProperty(this.projectRegEntry.getChildRegistryEntry(PUBLISH_SCRIPT_ANT_PARAMS), key);
        log.debug((Object)("Trying to remove key: " + key));
        this.pubAntParams.remove(key);
    }

    public String getJavaExtraOptions() {
        return this.javaExtraOptions;
    }

    public void setJavaExtraOptions(String opt) {
        this.setProperty(JAVA_EXTRA_OPTIONS, opt);
        this.javaExtraOptions = opt;
    }

    public void addNotificationUser(String userName, String email) {
        this.setProperty(userName, email);
        this.notificationUserMap.put(userName, email);
    }

    public Map getNotificationUserMap() {
        return this.notificationUserMap;
    }

    public void removeNotificationUser(String userName) {
        RegistryEntry regEntry = this.projectRegEntry.getChildRegistryEntry(USER_KEY);
        if (regEntry != null) {
            regEntry.removeKey(userName);
        }
        this.notificationUserMap.remove(userName);
    }

    public void save() throws Exception {
        if (this.scheduleName != null) {
            AnthillSchedule newSchedule = this.anthill.getSchedule(this.scheduleName);
            if (!newSchedule.equals(this.schedule)) {
                if (this.schedule != null) {
                    this.schedule.remove(this.project);
                }
                newSchedule.add(this.project);
            }
            this.schedule = newSchedule;
        } else {
            if (this.schedule != null) {
                this.schedule.remove(this.project);
            }
            this.schedule = null;
        }
        if (this.file != null) {
            if (!this.project.getProjectName().equals(FileUtils.getNameMinusExtension(this.file))) {
                this.file.delete();
                this.file = null;
            } else {
                try {
                    this.registry.updateRegistryFile();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
        if (this.file == null) {
            File projectsDir = this.anthill.getAnthillProjectsDir();
            this.file = new File(projectsDir, this.project.getProjectName() + ANTHILL_FILE_SUFFIX);
            try {
                this.registry.setRegistryFile(this.file);
                this.registry.updateRegistryFile();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        log.debug((Object)(this.project.getProjectName() + " properties saved"));
        this.setupProperties(this.projectRegEntry);
    }

    protected void setupProperties(RegistryEntry regEntry) throws AnthillBuildException {
        this.repositoryAdapterName = this.getPropValue(regEntry, REPOSITORY_ADAPTER, this.repositoryAdapterName);
        this.repositoryAdapter = null;
        this.versionAdapterName = this.getPropValue(regEntry, VERSION_ADAPTER, this.versionAdapterName);
        this.versionAdapter = null;
        this.scheduleName = this.getPropValue(regEntry, SCHEDULE_KEY, this.scheduleName);
        if (this.scheduleName != null) {
            this.schedule = this.anthill.getSchedule(this.scheduleName);
            if (this.schedule == null) {
                throw new AnthillBuildException("Did not find schedule: " + this.scheduleName);
            }
            this.schedule.add(this.project);
        }
        this.anthillUrl = this.getPropValue(regEntry, ANTHILL_URL_KEY, this.anthillUrl);
        this.publishUrl = this.getPropValue(regEntry, PUBLISH_URL_KEY, this.publishUrl);
        this.mailHost = this.getPropValue(regEntry, MAIL_HOST_KEY, this.mailHost);
        this.mailFrom = this.getPropValue(regEntry, MAIL_FROM_KEY, this.mailFrom);
        this.lastBuildSucceeded = this.getPropValue(regEntry, LAST_BUILD_SUCCEEDED_KEY, this.lastBuildSucceeded);
        this.lastGoodBuildDate = this.getPropValue(regEntry, LAST_GOOD_BUILD_DATE_KEY, this.lastGoodBuildDate);
        this.lastBuildFailDate = this.getPropValue(regEntry, LAST_BUILD_FAIL_DATE_KEY, this.lastBuildFailDate);
        this.buildScriptPath = this.getPropValue(regEntry, BUILD_SCRIPT_PATH, this.buildScriptPath);
        this.publishScriptPath = this.getPropValue(regEntry, PUBLISH_SCRIPT_PATH, this.publishScriptPath);
        this.publishDirName = this.getPropValue(regEntry, PUBLISH_DIR_NAME, this.publishDirName);
        this.publishRunPolicy = this.getPropValue(regEntry, PUBLISH_SCRIPT_RUN_POLICY, this.publishRunPolicy);
        this.workDir = this.getPropValue(regEntry, WORK_DIR_KEY, this.workDir);
        this.dependencyTargetName = this.getPropValue(regEntry, DEPENDENCY_TARGET_KEY, this.dependencyTargetName);
        this.dependencyArtifactProp = this.getPropValue(regEntry, DEPENDENCY_ARTIFACT_PROP_KEY, this.dependencyArtifactProp);
        this.tagBuild = this.getPropValue(regEntry, TAG_BUILD, this.tagBuild);
        this.buildAntParams.clear();
        this.buildAntParams.addAll(this.buildParamList(regEntry.getChildRegistryEntry(BUILD_SCRIPT_ANT_PARAMS)));
        this.pubAntParams.clear();
        this.pubAntParams.addAll(this.buildParamList(regEntry.getChildRegistryEntry(PUBLISH_SCRIPT_ANT_PARAMS)));
        Map tempNotificationUserMap = this.buildUserMap(regEntry.getChildRegistryEntry(USER_KEY));
        this.notificationUserMap.putAll(tempNotificationUserMap);
        this.javaExtraOptions = this.getPropValue(regEntry, JAVA_EXTRA_OPTIONS, this.javaExtraOptions);
        this.sendEmail = this.getPropValue(regEntry, EMAIL_POLICY, this.tagBuild);
    }

    protected String getPropValue(RegistryEntry regEntry, String propName, String curPropValue) {
        String propValue = regEntry.getKeyValue(propName);
        if (propValue == null) {
            propValue = curPropValue == null ? this.anthill.getAnthillConfig().getProperty(propName) : curPropValue;
        }
        return propValue;
    }

    protected Map buildUserMap(RegistryEntry userEntry) {
        HashMap<String, String> userMap = new HashMap<String, String>();
        if (userEntry != null) {
            Iterator userNameItr = userEntry.getKeyIterator();
            String userName = null;
            if (userNameItr != null) {
                while (userNameItr.hasNext()) {
                    userName = (String)userNameItr.next();
                    userMap.put(userName, userEntry.getKeyValue(userName));
                }
            }
        }
        return userMap;
    }

    protected void removeParamProperty(RegistryEntry paramsReg, String key) {
        if (paramsReg != null) {
            Iterator paramsRegItr = paramsReg.getChildRegistryEntries(PARAMS);
            while (paramsRegItr.hasNext()) {
                RegistryEntry keyReg = (RegistryEntry)paramsRegItr.next();
                if (!key.equals(keyReg.getKeyValue(BUILD_PUB_PARAM_VALUE_KEY))) continue;
                paramsReg.removeChildRegistryEntry(keyReg);
                break;
            }
        }
    }

    protected void oldRemoveParamProperty(RegistryEntry paramsReg, String key) {
        if (paramsReg != null) {
            Iterator paramsRegItr = paramsReg.getChildRegistryEntries(PARAMS);
            while (paramsRegItr.hasNext()) {
                RegistryEntry keyReg = (RegistryEntry)paramsRegItr.next();
                if (!key.equals(keyReg.getKeyValue("name"))) continue;
                paramsReg.removeChildRegistryEntry(keyReg);
                break;
            }
        }
    }

    protected Map buildParamMap(RegistryEntry paramEntry) {
        Iterator regEntryItr;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (paramEntry != null && (regEntryItr = paramEntry.getChildRegistryEntries(PARAMS)) != null) {
            while (regEntryItr.hasNext()) {
                RegistryEntry regEntry = (RegistryEntry)regEntryItr.next();
                String paramName = regEntry.getKeyValue("name");
                String paramValue = regEntry.getKeyValue(BUILD_PUB_PARAM_VALUE_KEY);
                if (paramName == null || paramValue == null) continue;
                paramMap.put(paramName, paramValue);
            }
        }
        return paramMap;
    }

    protected List buildParamList(RegistryEntry paramEntry) {
        ArrayList<String> paramList = new ArrayList<String>();
        if (paramEntry != null) {
            Iterator paramItr = paramEntry.getChildRegistryEntries(PARAMS);
            if (paramItr != null) {
                while (paramItr.hasNext()) {
                    RegistryEntry regEntry = (RegistryEntry)paramItr.next();
                    String paramValue = regEntry.getKeyValue(BUILD_PUB_PARAM_VALUE_KEY);
                    paramList.add(paramValue);
                    log.debug((Object)("Adding param: " + paramValue));
                }
            } else {
                log.error((Object)"param Iterator was null!  Unable to buildParamList");
            }
        }
        return paramList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

