/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CVSRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$CVSRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$CVSRepositoryAdapter = CVSRepositoryAdapter.class$("com.urbancode.anthill.adapter.CVSRepositoryAdapter")) : class$com$urbancode$anthill$adapter$CVSRepositoryAdapter).getName());
    private static Logger streamLog = Logger.getLogger((String)((class$com$urbancode$anthill$adapter$CVSRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$CVSRepositoryAdapter = CVSRepositoryAdapter.class$("com.urbancode.anthill.adapter.CVSRepositoryAdapter")) : class$com$urbancode$anthill$adapter$CVSRepositoryAdapter).getName() + "Stream"));
    public static final String ADAPTER_SUFFIX = "cvs";
    protected static final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    protected static final String COMMAND_INIT = "getCommandInit.pgl";
    public static final String MODULE_KEY = "repository.cvs.module";
    public static final String ROOT_KEY = "repository.cvs.root";
    public static final String BRANCH_KEY = "repository.cvs.branch";
    public static final String WORK_DIR_KEY = "repository.cvs.work.dir";
    public static SimpleDateFormat CVS_IN_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat CVS_OUT_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String FILE_DELIM_TOKEN = "=============================================================================";
    private static final String WORKING_FILE_TOKEN = "Working file: ";
    private static final String REV_DELIM_TOKEN = "----------------------------";
    private static final String REV_NUMB_TOKEN = "revision ";
    private static final String REV_DATE_TOKEN = "date:";
    private static final String REV_REVISIONS_TOKEN = "total revisions:";
    private static final String SYMBOLIC_LIST_TOKEN = "symbolic names:";
    private static final String KEYWORD_SUBSTITUTIONS_TOKEN = "keyword substitution:";
    private static final String REV_STATE_DEAD_TOKEN = "dead";
    private static final String CVS_AUTHOR_TOKEN = "author";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String CVS_TRAPPED_ERROR = "cvs [checkout aborted]: end of file from server (consult above messages if any)";
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$CVSRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        try {
            this.repositoryRoot = this.project.getProperties().getProperty(ROOT_KEY);
            this.moduleName = this.project.getProperties().getProperty(MODULE_KEY);
            this.branchName = this.project.getProperties().getProperty(BRANCH_KEY);
            if (this.branchName != null && this.branchName.trim().equals("")) {
                this.branchName = null;
            }
            this.calculateWorkDirName(WORK_DIR_KEY);
            this.calculateLocalProjectDirName(MODULE_KEY);
            log.info((Object)("repository root: " + this.repositoryRoot));
            log.info((Object)("Module: " + this.moduleName));
            log.info((Object)("Branch: " + this.branchName));
            log.info((Object)("Work directory: " + this.workDirName));
            log.info((Object)("Local project directory: " + this.localProjectDirName));
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        block2: {
            try {
                super.getWorkingProjectCopy(def);
            }
            catch (RepositoryException e) {
                log.info((Object)("RepositoryException in checkout. message: " + e.getMessage()));
                if (e.getMessage().indexOf(CVS_TRAPPED_ERROR) <= -1) break block2;
                log.info((Object)"CVS returned checkout aborted error. Trying again");
                super.getWorkingProjectCopy(def);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        ArrayList revisionList;
        int exitcode;
        block8: {
            Process p = null;
            Thread errorPumper = null;
            exitcode = 0;
            revisionList = new ArrayList();
            try {
                try {
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    tempMap.put("Adapter", this);
                    tempMap.put("Properties", this.project.getProperties());
                    tempMap.put("Date", date);
                    Pagelet pagelet = CVSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(GET_REVISIONS_SINCE_PAGELET));
                    String commandString = pagelet.service(tempMap);
                    log.info((Object)("Get revisions since command: " + commandString));
                    p = Runtime.getRuntime().exec(this.toArray(commandString));
                    errorPumper = new StreamPumper(p.getErrorStream(), "getRevisions", System.err, true);
                    errorPumper.start();
                    InputStream input = p.getInputStream();
                    this.parseLogCommandResult(input, revisionList);
                    exitcode = p.waitFor();
                }
                catch (Exception e) {
                    log.error((Object)(e.getMessage() + " thrown in new catch"));
                    e.printStackTrace();
                    throw new RepositoryException(e.getMessage());
                }
                Object var11_11 = null;
                if (errorPumper == null) break block8;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (errorPumper == null) throw throwable;
                try {
                    errorPumper.join();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new RepositoryException(e);
                }
            }
            try {}
            catch (InterruptedException e) {
                throw new RepositoryException(e);
            }
            errorPumper.join();
        }
        if (exitcode != 0) {
            throw new RepositoryException("cvs log failed.  Exit code: " + exitcode);
        }
        log.debug((Object)"returning revisionList");
        return revisionList;
    }

    protected void parseLogCommandResult(InputStream in, List revList) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        List fileRevList = this.parseLogCommandResultFileBlock(reader);
        while (fileRevList != null) {
            revList.addAll(fileRevList);
            fileRevList = this.parseLogCommandResultFileBlock(reader);
        }
    }

    protected List parseLogCommandResultFileBlock(BufferedReader reader) throws IOException {
        List revList = null;
        String line = null;
        line = reader.readLine();
        log.debug((Object)line);
        while (line != null && !line.startsWith(WORKING_FILE_TOKEN)) {
            line = reader.readLine();
            log.debug((Object)line);
        }
        if (line != null) {
            log.debug((Object)"***** Found WORKING_FILE_TOKEN ****");
            String fileName = line.substring(WORKING_FILE_TOKEN.length());
            ArrayList<String> symList = new ArrayList<String>();
            if (this.branchName != null) {
                while (line != null && !line.startsWith(SYMBOLIC_LIST_TOKEN)) {
                    line = reader.readLine();
                    log.debug((Object)line);
                }
                if (line != null) {
                    line = reader.readLine();
                    while (line != null && !line.startsWith(KEYWORD_SUBSTITUTIONS_TOKEN)) {
                        int symEndIndex = line.indexOf(":");
                        if (symEndIndex < 0) {
                            symEndIndex = line.length();
                        }
                        symList.add(line.substring(0, symEndIndex).trim());
                        line = reader.readLine();
                    }
                    log.debug((Object)"Found keyword substitutions");
                }
            }
            revList = this.parseLogCommandResultRevisionBlock(reader, fileName, symList);
        }
        return revList;
    }

    protected List parseLogCommandResultRevisionBlock(BufferedReader reader, String fileName, List symList) throws IOException {
        ArrayList<Revision> revList = new ArrayList<Revision>();
        String line = null;
        boolean newFile = false;
        boolean totalRevs = false;
        boolean wasAdded = false;
        line = reader.readLine();
        if (line == null) {
            log.debug((Object)"Returning from parseLogCommandResultRevisionBlock ran into null up top.");
            return revList;
        }
        log.debug((Object)line);
        if (line.startsWith(FILE_DELIM_TOKEN)) {
            newFile = true;
        }
        while (line != null && !newFile) {
            String tempVerFile;
            while (line != null && !newFile && !line.startsWith(REV_NUMB_TOKEN)) {
                line = reader.readLine();
                log.debug((Object)line);
                if (line == null || !line.startsWith(FILE_DELIM_TOKEN)) continue;
                newFile = true;
            }
            if (line == null || newFile) continue;
            log.debug((Object)"***** Found REV_NUMB_TOKEN ****");
            String revNum = line.substring(REV_NUMB_TOKEN.length(), line.length());
            line = reader.readLine();
            log.debug((Object)line);
            while (line != null && !newFile && !line.startsWith(REV_DATE_TOKEN)) {
                line = reader.readLine();
                log.debug((Object)line);
                if (!line.startsWith(FILE_DELIM_TOKEN)) continue;
                newFile = true;
            }
            if (line == null || newFile) continue;
            log.debug((Object)"***** Found REV_DATE_TOKEN ****");
            Revision rev = new Revision();
            rev.fileName = fileName;
            StringTokenizer tokenizer = new StringTokenizer(line, ";,  ");
            tokenizer.nextToken();
            String date = tokenizer.nextToken();
            date = date.replace('/', '-');
            String time = tokenizer.nextToken();
            try {
                rev.date = CVS_OUT_DATE.parse(date + " " + time);
            }
            catch (Exception e) {
                log.error((Object)"Can't parse revision date.", (Throwable)e);
            }
            tokenizer.nextToken();
            rev.userName = tokenizer.nextToken();
            if (rev.userName.startsWith(CVS_AUTHOR_TOKEN)) {
                rev.userName = tokenizer.nextToken();
            }
            tokenizer.nextToken();
            String stateToken = tokenizer.nextToken();
            if (stateToken.equals(REV_STATE_DEAD_TOKEN)) {
                if (revNum.trim().equals("1.1")) {
                    rev.wasDeleted = false;
                    rev.wasAdded = true;
                } else {
                    rev.wasDeleted = true;
                    rev.wasAdded = false;
                }
            }
            if ((tempVerFile = this.project.getProperties().getProperty("version.file")) != null && fileName.indexOf(tempVerFile) != -1) {
                log.debug((Object)"Not adding revision to the version file");
                rev.wasAdded = true;
            } else {
                log.debug((Object)("Not version file: " + fileName));
            }
            if (this.branchName == null) {
                if (!rev.wasAdded) {
                    revList.add(rev);
                }
            } else if (symList.contains(this.branchName.trim())) {
                log.debug((Object)("SymList contained branch name: " + this.branchName));
                if (!rev.wasAdded) {
                    log.debug((Object)"Wasn't added!  Need to build!");
                    revList.add(rev);
                }
            } else {
                log.debug((Object)("SymList did NOT contain branch name: " + this.branchName));
                log.debug((Object)"list contents:");
                for (int i = 0; i < symList.size(); ++i) {
                    log.debug((Object)((String)symList.get(i)));
                }
            }
            while (tokenizer.hasMoreTokens()) {
                String key = tokenizer.nextToken();
                log.debug((Object)("extra token:" + key));
                if (!key.startsWith("lines")) continue;
                String linesAdded = tokenizer.nextToken();
                linesAdded = linesAdded.substring(1);
                String linesDeleted = tokenizer.nextToken();
                linesDeleted = linesDeleted.substring(1);
                rev.linesAdded = Integer.parseInt(linesAdded);
                rev.linesDeleted = Integer.parseInt(linesDeleted);
            }
            rev.comment = new String();
            line = reader.readLine();
            log.debug((Object)line);
            if (line.equals(FILE_DELIM_TOKEN)) {
                newFile = true;
            }
            while (!(line == null || newFile || line.equals(REV_DELIM_TOKEN) || line.equals(FILE_DELIM_TOKEN))) {
                rev.comment = rev.comment + line + NEW_LINE;
                line = reader.readLine();
                log.debug((Object)line);
                if (line == null || !line.equals(FILE_DELIM_TOKEN)) continue;
                newFile = true;
            }
        }
        return revList;
    }

    public String makeTagFromVersion(String version) {
        if (!Character.isLetter(version.charAt(0))) {
            return "v" + version;
        }
        return version;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

