/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class MKSIntegrityRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter = MKSIntegrityRepositoryAdapter.class$("com.urbancode.anthill.adapter.MKSIntegrityRepositoryAdapter")) : class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter).getName());
    private static Logger streamLog = Logger.getLogger((String)((class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter = MKSIntegrityRepositoryAdapter.class$("com.urbancode.anthill.adapter.MKSIntegrityRepositoryAdapter")) : class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter).getName() + "Stream"));
    public static final String ADAPTER_SUFFIX = "integrity";
    public static final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    public static final String PROJECT_FILE = "repository.integrity.project.file";
    public static final String BRANCH_KEY = "repository.integrity.branch";
    public static final String WORK_DIR_KEY = "repository.integrity.work.dir";
    private String branchName = "";
    public static SimpleDateFormat IN_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat OUT_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final String ARCHIVE_TOKEN = "Archive file: ";
    private final String WORKING_FILE_TOKEN = "Working file: ";
    private final String REVISION_BOUNDARY = "----------------------------";
    private final String REVISION_END = "===============================================================================";
    private final String SYMBOLIC_TOKEN = "symbolic names:";
    private final String COMMENT_LEADER_TOKEN = "comment leader:";
    private final String DATE_TOKEN = "date:";
    private final String REVISION_TOKEN = "revision";
    private final String STATE_TOKEN = "state: ";
    private final String AUTHOR_TOKEN = "author: ";
    private final String SELECTED_TOKEN = "selected revisions:";
    private final String LINES_CHANGED_TOKEN = "lines:";
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$MKSIntegrityRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        this.workDirName = this.localProjectDirName = this.project.getProperties().getProperty(WORK_DIR_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        ArrayList revList;
        block11: {
            revList = new ArrayList();
            Process p = null;
            StreamPumper errorPumper = null;
            boolean exitcode = false;
            BufferedReader br = null;
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("Date", date);
            Pagelet pagelet = MKSIntegrityRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(GET_REVISIONS_SINCE_PAGELET));
            String commandString = pagelet.service(tempMap);
            log.info((Object)("Get revisions since command: " + commandString));
            p = Runtime.getRuntime().exec(commandString);
            errorPumper = new StreamPumper(p.getErrorStream(), "getRevisions", System.err, false);
            errorPumper.start();
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.parseRevisionHistory(br, revList);
            Object var11_11 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block11;
            }
            catch (IOException ioe) {}
            break block11;
            {
                catch (Exception e) {
                    log.error((Object)e);
                    e.printStackTrace();
                    Object var11_12 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block11;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return revList;
    }

    public List parseRevisionHistory(BufferedReader br, List revList) {
        try {
            String tempLine = br.readLine();
            ArrayList symList = new ArrayList();
            String fileName = null;
            boolean hasBranchOrNoBranch = true;
            while (tempLine != null) {
                if (tempLine.startsWith("Archive file: ")) {
                    fileName = tempLine.substring(tempLine.indexOf("Working file: ") + "Working file: ".length(), tempLine.length());
                    log.debug((Object)("Found file: " + fileName));
                    if (this.branchName != null && !this.branchName.trim().equals("")) {
                        tempLine = br.readLine();
                        while (tempLine != null && !tempLine.startsWith("symbolic names:")) {
                            tempLine = br.readLine();
                        }
                        if (tempLine != null) {
                            if (tempLine.indexOf(this.branchName) == -1) {
                                hasBranchOrNoBranch = false;
                            }
                        } else {
                            log.error((Object)"templine was null looking for symbolic tokens!");
                        }
                    }
                    if (tempLine != null) {
                        this.parseRevisions(br, revList, fileName, hasBranchOrNoBranch);
                    }
                }
                tempLine = br.readLine();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return revList;
    }

    public List parseRevisions(BufferedReader br, List revList, String fileName, boolean hasBranchOrNoBranch) {
        try {
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.trim().equals("===============================================================================")) {
                while (tempLine.equals("----------------------------")) {
                    tempLine = this.parseRevision(br, revList, fileName, hasBranchOrNoBranch);
                }
                if (!tempLine.equals("===============================================================================")) {
                    tempLine = br.readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return revList;
    }

    public String parseRevision(BufferedReader br, List revList, String fileName, boolean hasBranchOrNoBranch) {
        Revision r = null;
        String revision = null;
        String tempLine = null;
        try {
            String author;
            tempLine = br.readLine();
            if (tempLine != null && tempLine.startsWith("selected revisions:")) {
                return tempLine;
            }
            if (tempLine != null && !tempLine.startsWith("revision")) {
                log.error((Object)("Unexpected string in revision: " + tempLine));
                log.error((Object)"Expecting revision token");
            }
            r = new Revision();
            r.fileName = fileName;
            revision = tempLine.substring("revision".length(), tempLine.length()).trim();
            log.debug((Object)("Revision: " + revision));
            tempLine = br.readLine();
            if (tempLine != null && !tempLine.startsWith("date:")) {
                log.error((Object)("Unexpected string in revision: " + tempLine));
                log.error((Object)"Expecting date token");
            }
            int semiIndex = tempLine.indexOf(";");
            String date = tempLine.substring("date:".length(), semiIndex);
            log.debug((Object)("Date: " + date));
            r.date = OUT_DATE.parse(date.substring(0, date.length() - 1));
            r.userName = author = tempLine.substring(semiIndex + "author: ".length(), tempLine.indexOf(";", tempLine.indexOf("author: ")));
            log.debug((Object)("Author: " + author));
            semiIndex = tempLine.indexOf("state: ");
            String state = tempLine.substring(semiIndex + "state: ".length(), tempLine.indexOf(";", tempLine.indexOf("state: ")));
            log.debug((Object)("State: " + state));
            int linesIndex = tempLine.indexOf("lines:");
            if (linesIndex != -1) {
                String linesChanged = tempLine.substring(linesIndex + "lines:".length(), tempLine.length());
                StringTokenizer st = new StringTokenizer(linesChanged, "+- ");
                r.linesAdded = Integer.parseInt(st.nextToken());
                r.linesDeleted = Integer.parseInt(st.nextToken());
            }
            tempLine = br.readLine();
            String comment = "";
            while (tempLine != null && !tempLine.trim().equals("----------------------------") && !tempLine.trim().equals("===============================================================================")) {
                comment = comment + tempLine.trim();
                tempLine = br.readLine();
            }
            if (comment.trim().equals("")) {
                comment = "no comment";
            }
            r.comment = comment;
            log.debug((Object)("Comment: " + comment));
            boolean addRevision = true;
            if (this.branchName != null && !this.branchName.trim().equals("") && !hasBranchOrNoBranch) {
                log.debug((Object)("Sym list did not contain branch: " + this.branchName));
                addRevision = false;
            }
            String tempVerFile = this.project.getProperties().getProperty("version.file");
            String revFileName = r.fileName;
            tempVerFile = FileUtils.getOSDependentPath(tempVerFile);
            if ((revFileName = FileUtils.getOSDependentPath(revFileName)).indexOf(tempVerFile.trim()) != -1) {
                log.debug((Object)"Not adding revision to version file.");
                addRevision = false;
            }
            if (revision.trim().equals("1.1") && state.equals("dead")) {
                addRevision = false;
            }
            if (addRevision) {
                log.debug((Object)("Adding revision: " + r));
                revList.add(r);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return tempLine;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

