/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.execute.Execute;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;

public class PVCSRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$PVCSRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$PVCSRepositoryAdapter = PVCSRepositoryAdapter.class$("com.urbancode.anthill.adapter.PVCSRepositoryAdapter")) : class$com$urbancode$anthill$adapter$PVCSRepositoryAdapter).getName());
    public static final String ADAPTER_SUFFIX = "pvcs";
    protected static final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    protected static final String WORKING_PROJECT_PAGELET = "getWorkingProject.pgl";
    protected static final String LABEL_PAGELET = "label.pgl";
    protected static final String SCRIPT_PAGELET = "runScript.pgl";
    public static final String WORK_DIR = "repository.pvcs.work.dir";
    public static final String DB_DIR = "repository.pvcs.projectDir";
    public static final String PROJECT = "repository.pvcs.project";
    public static final String BRANCH_KEY = "repository.pvcs.branch";
    public static final String ARCHIVE_DIR = "repository.pvcs.archiveDir";
    public static final String PVCS_DATE_FORMAT_KEY = "repository.pvcs.dateFormat";
    public static final String DEFAULT_LOG_DATE_FORMAT_STR = "MMM dd yyyy HH:mm:ss";
    public static final String LIST_SCRIPT = "myscript.pcli";
    public static final String TEMP_FILE = "file.tmp";
    private String revStart = "-----------------------------------";
    private String endOfFileBlock = "===================================";
    private SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
    private SimpleDateFormat LOG_QUERY_FORMAT = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");
    private String archiveFileString = "Archive:";
    private String workFileString = "Workfile:";
    private String versionLabelString = "Version labels:";
    private String descriptionString = "Description:";
    private String revString = "Rev";
    private String lockedByString = "Locked by:";
    private String checkedInString = "Checked in:";
    private String authorString = "Author id:";
    private String linesString = "lines deleted/added/moved:";
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$PVCSRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        try {
            ProjectProperties pp = this.project.getProperties();
            String logDateFormatStr = pp.getProperty(PVCS_DATE_FORMAT_KEY);
            if (logDateFormatStr == null || logDateFormatStr.trim().length() == 0) {
                logDateFormatStr = DEFAULT_LOG_DATE_FORMAT_STR;
            }
            log.info((Object)("Revision log date format: " + logDateFormatStr));
            this.LOG_DATE_FORMAT = new SimpleDateFormat(logDateFormatStr);
            this.calculateBranchName(BRANCH_KEY);
            this.calculateWorkDirName(WORK_DIR);
            this.calculateLocalProjectDirName(PROJECT);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        File f = new File(this.localProjectDirName.trim());
        if (!f.exists()) {
            if (f.mkdirs()) {
                log.info((Object)("Successfully made local project directory: " + f.getAbsolutePath()));
            } else {
                log.info((Object)("Error creating local project directory: " + f.getAbsolutePath()));
            }
        }
        log.debug((Object)("Getting working copy of project: " + this.project.getProjectName()));
        if (this.branchName != null && !this.branchName.equals("")) {
            log.debug((Object)("Retrieving branch: " + this.branchName));
        }
        try {
            Pagelet pagelet;
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            if (def.getVersionedBuildFlag()) {
                log.info((Object)("Retrieving project version " + def.getVersion()));
                tempMap.put("Version", def.getVersion().trim());
            }
            if ((pagelet = PVCSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(WORKING_PROJECT_PAGELET))) != null) {
                log.debug((Object)"Have checkout pagelet.");
            } else {
                log.debug((Object)"Pagelet is null in checkout!");
            }
            String commandString = pagelet.service(tempMap);
            log.debug((Object)("Checkout Command: " + commandString));
            this.executeCommand(commandString, "checkout");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Checkout failed: " + e.getMessage(), e);
        }
    }

    public void label(String tag) throws RepositoryException {
        if (tag == null || tag.length() == 0) {
            throw new RepositoryException("No label specified");
        }
        tag = tag.replace('$', '_').replace(',', '_').replace('*', '_').replace(':', '_').replace(';', '_').replace('@', '_').replace('+', '_').replace('-', '_');
        log.info((Object)("Tagging entire project with label: " + tag));
        int exitCode = -1;
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("ScriptPath", "conf" + File.separator + "profiles" + File.separator + LIST_SCRIPT);
            tempMap.put("Label", tag);
            Pagelet pagelet = PVCSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(SCRIPT_PAGELET));
            String commandString = pagelet.service(tempMap);
            log.info((Object)("Label Script Command: " + commandString));
            Execute exe = new Execute();
            exe.setLogger(log);
            exe.setCommandline(this.toArray(commandString));
            if (exitCode != 0) {
                throw new RepositoryException("PVCSRepositoryAdapter: Error running script in pvcs label.  Exit code: " + exitCode);
            }
            try {
                this.checkAndFixUNC();
            }
            catch (Exception e) {
                throw new RepositoryException("PVCSRepositoryAdapter: Error executing checkAndFixUNC:" + e.getMessage().toString());
            }
            pagelet = PVCSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(LABEL_PAGELET));
            commandString = pagelet.service(tempMap);
            log.info((Object)("PVCS label command: " + commandString));
            exe = new Execute();
            exe.setCommandline(this.toArray(commandString));
            if (exitCode != 0) {
                throw new RepositoryException("PVCSRepositoryAdapter: Error Executing pvcs label.  Exit code: " + exitCode);
            }
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        ArrayList revList;
        block24: {
            Exception e322;
            BufferedReader br;
            Thread err;
            block22: {
                revList = new ArrayList();
                int exitCode = -1;
                String dateString = this.LOG_QUERY_FORMAT.format(date);
                String currentDate = this.LOG_QUERY_FORMAT.format(new Date());
                err = null;
                br = null;
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("Adapter", this);
                tempMap.put("Properties", this.project.getProperties());
                tempMap.put("ScriptPath", "conf" + File.separator + "profiles" + File.separator + LIST_SCRIPT);
                tempMap.put("DateString", dateString);
                tempMap.put("CurrentDate", currentDate);
                Pagelet pagelet = PVCSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(SCRIPT_PAGELET));
                String commandString = pagelet.service(tempMap);
                log.info((Object)("getRevisionsSince script command: " + commandString));
                Execute exe = new Execute();
                exe.setLogger(log);
                exe.setCommandline(this.toArray(commandString));
                if (exitCode != 0) {
                    throw new RepositoryException("PVCSRepositoryAdapter: Error executing: " + commandString + ".  Exit Code: " + exitCode);
                }
                try {
                    this.checkAndFixUNC();
                }
                catch (Exception e2) {
                    throw new RepositoryException("PVCSRepositoryAdapter: Error executing checkAndFixUNC:" + e2.getMessage().toString());
                }
                pagelet = PVCSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(GET_REVISIONS_SINCE_PAGELET));
                commandString = pagelet.service(tempMap);
                log.info((Object)("Executing: " + commandString));
                Runtime rt = Runtime.getRuntime();
                Process p2 = rt.exec(commandString);
                err = new StreamPumper(p2.getErrorStream(), "testerr", System.err, true);
                err.start();
                br = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                this.parseFileLog(br, revList);
                String tempLine = br.readLine();
                while (tempLine != null) {
                    this.parseFileLog(br, revList);
                    tempLine = br.readLine();
                }
                exitCode = p2.waitFor();
                Object var16_18 = null;
                if (err == null) break block22;
                try {
                    err.join();
                }
                catch (Exception e322) {
                    log.error((Object)e322);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e322) {}
            }
            break block24;
            {
                catch (RepositoryException e4) {
                    throw e4;
                }
                catch (Exception e5) {
                    Exception e322;
                    log.error((Object)e5);
                    Object var16_19 = null;
                    if (err != null) {
                        try {
                            err.join();
                        }
                        catch (Exception e322) {
                            log.error((Object)e322);
                        }
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var16_20 = null;
                if (err != null) {
                    try {
                        err.join();
                    }
                    catch (Exception e322) {
                        log.error((Object)e322);
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return revList;
    }

    public void parseFileLog(BufferedReader br, List revList) {
        try {
            String tempLine = br.readLine();
            if (tempLine == null) {
                log.debug((Object)"first line encountered in parseFileLog was null.");
                return;
            }
            String archiveLocation = this.project.getProperties().getProperty(ARCHIVE_DIR);
            String currentFilePath = "";
            String projectName = this.project.getProperties().getProperty(PROJECT);
            while (!tempLine.startsWith(this.archiveFileString)) {
                tempLine = br.readLine();
                if (tempLine == null) {
                    log.debug((Object)"No more revisions.");
                    return;
                }
                log.debug((Object)tempLine);
            }
            String archiveString = tempLine.substring(this.archiveFileString.length(), tempLine.length()).trim();
            log.debug((Object)("Archive String: " + archiveString));
            String chopOff = archiveLocation + File.separator + projectName + File.separator;
            log.debug((Object)("Chopoff String: " + chopOff + "(" + chopOff.length() + ")"));
            currentFilePath = archiveString.substring(chopOff.length() - 1, archiveString.length());
            if (currentFilePath.endsWith("-arc")) {
                currentFilePath = currentFilePath.substring(0, currentFilePath.length() - 4);
            }
            while (tempLine != null && !tempLine.startsWith(this.workFileString)) {
                tempLine = br.readLine();
            }
            String branchName = this.project.getProperties().getProperty(BRANCH_KEY);
            boolean haveRevisions = false;
            int numSpaces = 0;
            if (branchName != null && !branchName.trim().equals("")) {
                log.debug((Object)("Searching revisions for branch: " + branchName));
                if (tempLine != null) {
                    log.debug((Object)("Workfile: " + tempLine.substring(this.workFileString.length(), tempLine.length()).trim()));
                    Vector labels = this.getLabels(br);
                    log.debug((Object)"Labels:");
                    for (int i = 0; i < labels.size(); ++i) {
                        String tempLabel = (String)labels.elementAt(i);
                        if (tempLabel.indexOf(branchName) == -1) continue;
                        haveRevisions = true;
                        StringTokenizer st = new StringTokenizer(tempLabel, " = \"");
                        String branchRevNum = st.nextToken();
                        int numDots = 0;
                        branchRevNum = st.nextToken();
                        log.debug((Object)("Branch revision: " + branchRevNum));
                        for (int j = 0; j < branchRevNum.length(); ++j) {
                            if (branchRevNum.charAt(j) != '.') continue;
                            ++numDots;
                        }
                        numSpaces = 2 * numDots - 2;
                        break;
                    }
                }
            } else {
                haveRevisions = true;
            }
            if (haveRevisions) {
                log.debug((Object)"going into getRevisions.");
                this.getRevisions(br, revList, currentFilePath, numSpaces);
            }
            log.debug((Object)"Finished parsing log.");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public Vector getLabels(BufferedReader br) {
        Vector<String> v = new Vector<String>();
        try {
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.startsWith(this.versionLabelString)) {
                tempLine = br.readLine();
            }
            if (tempLine != null) {
                tempLine = br.readLine();
                while (!tempLine.equals(this.descriptionString)) {
                    v.addElement(tempLine.trim());
                    tempLine = br.readLine();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return v;
    }

    public void getRevisions(BufferedReader br, List revList, String fileName, int numSpaces) {
        log.debug((Object)("Getting revisions for file: " + fileName));
        try {
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.equals(this.revStart)) {
                tempLine = br.readLine();
            }
            while (tempLine != null && !tempLine.equals(this.endOfFileBlock)) {
                if (tempLine.equals(this.revStart)) {
                    log.debug((Object)"START OF REVISION");
                    tempLine = this.getRevision(br, revList, fileName, numSpaces);
                    if (tempLine != null && tempLine.equals(this.endOfFileBlock)) {
                        log.debug((Object)"END OF FILE BLOCK!");
                        return;
                    }
                    if (tempLine != null && tempLine.equals(this.revStart)) {
                        log.debug((Object)"START OF REVISION");
                        tempLine = this.getRevision(br, revList, fileName, numSpaces);
                        continue;
                    }
                    log.debug((Object)("Unexpected String: " + tempLine));
                    return;
                }
                log.debug((Object)"not rev start again...");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getRevision(BufferedReader br, List revList, String fileName, int numSpaces) {
        Revision rev = new Revision();
        rev.fileName = fileName;
        String spaceString = "";
        boolean addRevision = true;
        for (int i = 0; i < numSpaces; ++i) {
            spaceString = spaceString + " ";
        }
        try {
            String tempLine = br.readLine();
            if (tempLine != null) {
                if (!tempLine.startsWith(spaceString + this.revString)) {
                    addRevision = false;
                }
                tempLine = tempLine.trim();
                log.debug((Object)("Revision: " + tempLine.substring(this.revString.length(), tempLine.length())));
                tempLine = br.readLine();
                if (tempLine.startsWith(spaceString + this.lockedByString)) {
                    log.debug((Object)tempLine);
                    tempLine = br.readLine();
                }
                if (!tempLine.startsWith(spaceString + this.checkedInString)) {
                    addRevision = false;
                }
                tempLine = tempLine.trim();
                String stringDate = tempLine.substring(this.checkedInString.length(), tempLine.length()).trim();
                log.debug((Object)("Checked in: " + this.LOG_DATE_FORMAT.parse(stringDate)));
                rev.date = this.LOG_DATE_FORMAT.parse(stringDate);
                tempLine = br.readLine();
                tempLine = br.readLine();
                if (!tempLine.startsWith(spaceString + this.authorString)) {
                    addRevision = false;
                }
                tempLine = tempLine.trim();
                RE authorRE = new RE("Author id: ([\\w-]+)");
                RE linesRE = new RE("lines deleted/added/moved: (\\d)/(\\d)/(\\d)");
                int index = 0;
                if (authorRE.match(tempLine, index)) {
                    rev.userName = authorRE.getParen(1);
                    index = authorRE.getParenEnd(0);
                    if (linesRE.match(tempLine, index)) {
                        log.debug((Object)("Lines info " + linesRE.getParen(1) + ", " + linesRE.getParen(2) + ", " + linesRE.getParen(3)));
                        rev.linesAdded = Integer.parseInt(linesRE.getParen(2));
                        rev.linesDeleted = Integer.parseInt(linesRE.getParen(1));
                    }
                } else {
                    addRevision = false;
                }
                tempLine = br.readLine();
                String comment = "";
                while (tempLine != null && !tempLine.equals(this.endOfFileBlock) && !tempLine.equals(this.revStart)) {
                    comment = comment + tempLine.trim();
                    tempLine = br.readLine().trim();
                }
                rev.comment = comment;
                log.debug((Object)("Comment: " + comment.trim()));
                String versionFile = this.project.getProperties().getProperty("version.file");
                if (versionFile != null) {
                    if (fileName.indexOf(versionFile) != -1) {
                        log.debug((Object)"Not adding revision of version file");
                    } else if (addRevision) {
                        revList.add(rev);
                    } else {
                        log.debug((Object)"Not adding revision on branch.");
                    }
                }
                return tempLine;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void executeCommand(String command, String name) throws RepositoryException {
        boolean exitCode = false;
        Object bos = null;
        Object sbos = null;
        super.executeCommand(command, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndFixUNC() throws Exception, RepositoryException, IOException {
        BufferedWriter _bw;
        FileReader _reader;
        File i_file;
        block10: {
            if (!this.project.getProperties().getProperty(DB_DIR).startsWith("\\\\")) {
                return;
            }
            log.info((Object)"Changing UNC maps for command line functions.");
            i_file = new File(this.getLocalProjectDirName() + File.separator + TEMP_FILE);
            File o_file = new File(this.getLocalProjectDirName() + File.separator + TEMP_FILE);
            _reader = null;
            FileWriter _writer = null;
            BufferedReader _br = null;
            _bw = null;
            StringBuffer _buf = null;
            try {
                try {
                    _reader = new FileReader(i_file);
                    _br = new BufferedReader(_reader);
                    int fileLengthInBytes = (int)i_file.length();
                    _buf = new StringBuffer(fileLengthInBytes);
                    int readChar = 0;
                    while ((readChar = _br.read()) >= 0) {
                        _buf.append((char)readChar);
                    }
                    for (int i = _buf.length() - 4; i > -1; --i) {
                        if (!_buf.substring(i, i + 3).equals("\"\\\\")) continue;
                        _buf.insert(i + 1, "\\");
                    }
                    _writer = new FileWriter(o_file);
                    _bw = new BufferedWriter(_writer);
                    _bw.write(_buf.toString());
                    _bw.flush();
                }
                catch (Exception e) {
                    throw new RepositoryException(e.getMessage().toString());
                }
                Object var12_12 = null;
                if (_br == null) break block10;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (_br != null) {
                    _br.close();
                }
                _reader = null;
                i_file = null;
                if (_bw != null) {
                    _bw.close();
                }
                _writer = null;
                o_file = null;
                throw throwable;
            }
            _br.close();
        }
        _reader = null;
        i_file = null;
        if (_bw == null) return;
        _bw.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

