/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;

public class PerforceRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$PerforceRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$PerforceRepositoryAdapter = PerforceRepositoryAdapter.class$("com.urbancode.anthill.adapter.PerforceRepositoryAdapter")) : class$com$urbancode$anthill$adapter$PerforceRepositoryAdapter).getName());
    private final String FORM_FILE = "formFile.txt";
    private final String FORM_FILE_OUT = "formFileOut.txt";
    public static final String CLIENT_KEY = "repository.perforce.P4CLIENT";
    public static final String PASSWD_KEY = "repository.perforce.P4PASSWD";
    public static final String PORT_KEY = "repository.perforce.P4PORT";
    public static final String USER_KEY = "repository.perforce.P4USER";
    public static final String VIEW_KEY = "repository.perforce.P4VIEW";
    private final String DATE_STRING = "yyyy/MM/dd HH:mm:ss";
    public static final String ADAPTER_SUFFIX = "perforce";
    private final String GET_CLIENT_INFO_PAGELET = "getClientInfo.pgl";
    private final String EDIT_PAGELET = "edit.pgl";
    private final String DESCRIBE_PAGELET = "describe.pgl";
    private final String LOCK_PAGELET = "lock.pgl";
    private final String CHANGE_PAGELET = "change.pgl";
    private final String SUBMIT_PAGELET = "submit.pgl";
    private final String LABEL_PAGELET = "label.pgl";
    private final String PRE_LABEL_PAGELET = "preLabel.pgl";
    private final String LABEL_SYNC_PAGELET = "labelSync.pgl";
    private final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    private final String REVERT_PAGELET = "revert.pgl";
    private SimpleDateFormat PERFORCE_DATE = null;
    private final String ROOT_TOKEN = "Root:";
    private final String VIEW_TOKEN = "View:";
    private final String CHANGE_TOKEN = "Change ";
    private final String AFFECTED_TOKEN = "Affected files";
    private final String DIFFERENCES_TOKEN = "Differences";
    private String rootString = null;
    private List clientViewList = new ArrayList();
    private List depotViewList = new ArrayList();
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$PerforceRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        log.debug((Object)"calculateRepositoryProperties()");
        try {
            this.PERFORCE_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            this.branchName = null;
            this.parseClientOutput();
            this.calculateLocalProjectDirName();
            log.debug((Object)("calculateRepositoryProperties() localProjectDirName: " + this.localProjectDirName));
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
    }

    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        File f = new File(this.localProjectDirName.trim());
        if (!f.exists()) {
            if (f.mkdirs()) {
                log.info((Object)("Successfully made local project directory: " + f.getAbsolutePath()));
            } else {
                log.info((Object)("Error creating local project directory: " + f.getAbsolutePath()));
            }
        }
        super.getWorkingProjectCopy(def);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseClientOutput() throws RepositoryException {
        Thread err = null;
        this.depotViewList.clear();
        this.clientViewList.clear();
        ByteArrayOutputStream bos = null;
        BufferedReader br = null;
        try {
            try {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("Adapter", this);
                tempMap.put("Properties", this.project.getProperties());
                Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("getClientInfo.pgl"));
                if (pagelet == null) {
                    throw new RepositoryException("PerforceAdapter: getClientInfo.pgl pagelet not found.");
                }
                String commandString = pagelet.service(tempMap);
                log.info((Object)("Command for client info: " + commandString));
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(commandString);
                bos = new ByteArrayOutputStream();
                err = new StreamPumper(p.getErrorStream(), "testerr", bos, true);
                err.start();
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String tempLine = br.readLine();
                while (tempLine != null) {
                    if (tempLine.startsWith("Root:")) {
                        log.debug((Object)("Found root token!  Root: " + tempLine.substring("Root:".length(), tempLine.length()).trim()));
                        this.rootString = tempLine.substring("Root:".length(), tempLine.length()).trim();
                    } else if (tempLine.startsWith("View:")) {
                        log.debug((Object)"Found view token!");
                        tempLine = br.readLine();
                        while (tempLine != null) {
                            if (tempLine.trim().equals("")) {
                                log.debug((Object)"Finished processing views");
                                break;
                            }
                            log.debug((Object)("View: " + tempLine.trim()));
                            String viewString = tempLine.trim();
                            String depotView = viewString.substring(viewString.indexOf("//"), viewString.lastIndexOf("//")).trim();
                            this.depotViewList.add(depotView);
                            log.debug((Object)("Depot View: " + depotView));
                            String clientView = viewString.substring(viewString.lastIndexOf("//")).trim();
                            this.clientViewList.add(clientView);
                            log.debug((Object)("Client View: " + clientView));
                            tempLine = br.readLine();
                        }
                    }
                    tempLine = br.readLine();
                }
                int errorCode = p.waitFor();
                if (errorCode != 0) throw new RepositoryException("PerforceAdapter: could not get client info. " + new String(bos.toByteArray()));
                if (this.rootString == null) throw new RepositoryException("PerforceAdapter: could not get client info. " + new String(bos.toByteArray()));
                if (this.rootString.length() == 0) throw new RepositoryException("PerforceAdapter: could not get client info. " + new String(bos.toByteArray()));
                if (this.depotViewList.isEmpty()) {
                    throw new RepositoryException("PerforceAdapter: could not get client info. " + new String(bos.toByteArray()));
                }
                Object var14_16 = null;
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RepositoryException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {
                if (err != null) {
                    err.join();
                }
                if (bos != null) {
                    bos.close();
                }
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (err != null) {
            err.join();
        }
        if (bos != null) {
            bos.close();
        }
        if (br == null) return;
        br.close();
        return;
    }

    public void revert() throws RepositoryException {
    }

    protected void calculateLocalProjectDirName() {
        String viewName = this.project.getProperties().getProperty(VIEW_KEY);
        if (viewName != null && viewName.length() > 0) {
            try {
                int start = viewName.indexOf("/", 2) + 1;
                int end = viewName.length() - "/...".length();
                String viewDirectoryName = FileUtils.getOSDependentPath(viewName.substring(start, end));
                this.localProjectDirName = this.rootString + File.separator + viewDirectoryName;
            }
            catch (Exception e) {
                log.error((Object)("CalculateProjectDirName() Invalid view name: " + viewName + " Unable to parse correctly. Should be " + "of the form //client/project_directory/... or " + "//depot/project_directory/..."));
            }
        } else {
            this.localProjectDirName = this.rootString;
        }
        log.debug((Object)("CalculateProjectDirName() localProjectDirName: " + this.localProjectDirName));
    }

    public void prepareFileForEdit(String file) throws RepositoryException {
        file = FileUtils.getOSDependentPath(file);
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("File", file);
            Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("edit.pgl"));
            String commandString = pagelet.service(tempMap);
            log.info((Object)("Edit Command: " + commandString));
            this.executeCommand(commandString, "prepareForEdit");
            log.debug((Object)"Have file opened for editing...attempting to lock file");
            pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("lock.pgl"));
            commandString = pagelet.service(tempMap);
            log.info((Object)("Lock command: " + commandString));
            this.executeCommand(commandString, "lock");
        }
        catch (Exception e) {
            throw new RepositoryException("preparing file for edit failed: " + e.getMessage());
        }
    }

    public void postFileEdit(String file, String msg) throws RepositoryException {
        file = FileUtils.getOSDependentPath(file);
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("FormFile", "formFile.txt");
            tempMap.put("FormFileOut", "formFileOut.txt");
            Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("change.pgl"));
            String commandString = pagelet.service(tempMap);
            log.info((Object)("Change Command: " + commandString));
            this.executeCommand(commandString, "postEdit");
            this.readWriteSubmitFormFile("Labeled by Anthill");
            pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("submit.pgl"));
            tempMap.put("SubmitFile", file);
            commandString = pagelet.service(tempMap);
            log.info((Object)("Submit command: " + commandString));
            this.executeCommand(commandString, "submit");
            this.deleteTempFiles();
        }
        catch (Exception e) {
            this.deleteTempFiles();
            throw new RepositoryException("post file edit failed: " + e.getMessage());
        }
    }

    public void label(String tag) throws RepositoryException {
        if (tag == null || tag.length() == 0) {
            throw new RepositoryException("No label specified");
        }
        tag = tag.replace('$', '_').replace(',', '_').replace('.', '_').replace(':', '_').replace(';', '_').replace('@', '_');
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("FormFile", "formFile.txt");
            tempMap.put("FormFileOut", "formFileOut.txt");
            tempMap.put("Label", tag);
            Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("preLabel.pgl"));
            String commandString = pagelet.service(tempMap);
            log.info((Object)("Pre-label Command: " + commandString));
            this.executeCommand(commandString, "preLabel");
            this.readWriteLabelFormFile();
            pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("label.pgl"));
            commandString = pagelet.service(tempMap);
            log.info((Object)("Label command: " + commandString));
            this.executeCommand(commandString, "label");
            pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("labelSync.pgl"));
            commandString = pagelet.service(tempMap);
            log.info((Object)("Label sync command: " + commandString));
            this.executeCommand(commandString, "labelSynch");
            this.deleteTempFiles();
        }
        catch (Exception e) {
            this.deleteTempFiles();
            throw new RepositoryException("Label failed: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        String fromDate = "";
        ArrayList<Revision> revList = new ArrayList<Revision>();
        SimpleDateFormat PERFORCE_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        BufferedReader br = null;
        int exitCode = -1;
        try {
            try {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("Adapter", this);
                tempMap.put("Properties", this.project.getProperties());
                tempMap.put("Date", PERFORCE_DATE.format(date));
                Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("getRevisionsSince.pgl"));
                String commandString = pagelet.service(tempMap);
                log.debug((Object)("Get Revisions Since command: " + commandString));
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(commandString);
                StreamPumper err = new StreamPumper(p.getErrorStream(), "testerr", System.err, true);
                err.start();
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String tempLine = br.readLine();
                while (tempLine != null) {
                    RE changeRE;
                    if (tempLine.startsWith("Change ") && (changeRE = new RE("\\D+(\\d+)")).match(tempLine)) {
                        log.debug((Object)("Change: " + changeRE.getParen(1)));
                        Collection revisions = this.getChangeRevisions(Integer.parseInt(changeRE.getParen(1)));
                        Iterator revIt = revisions.iterator();
                        while (revIt.hasNext()) {
                            Revision r = (Revision)revIt.next();
                            String verFile = this.project.getProperties().getProperty("version.file");
                            String tempFileName = FileUtils.getOSDependentPath(r.fileName);
                            verFile = FileUtils.getOSDependentPath(verFile);
                            if ((tempFileName = tempFileName.toLowerCase()).indexOf(verFile = verFile.toLowerCase()) == -1) {
                                revList.add(r);
                                continue;
                            }
                            log.debug((Object)"not adding revision to version file.");
                        }
                    }
                    tempLine = br.readLine();
                }
                Object var21_21 = null;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new RepositoryException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            try {
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (br == null) return revList;
        br.close();
        return revList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getChangeRevisions(int changeNum) throws RepositoryException {
        Revision template = new Revision();
        HashMap<String, Revision> revisions = new HashMap<String, Revision>();
        int exitCode = -1;
        SimpleDateFormat PERFORCE_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        BufferedReader br = null;
        try {
            try {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("Adapter", this);
                tempMap.put("Properties", this.project.getProperties());
                tempMap.put("ChangeNum", "" + changeNum);
                Pagelet pagelet = PerforceRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("describe.pgl"));
                String commandString = pagelet.service(tempMap);
                log.debug((Object)("Get Change Revision command: " + commandString));
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(commandString);
                StreamPumper err = new StreamPumper(p.getErrorStream(), "testerr", System.err, true);
                err.start();
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String tempLine = br.readLine();
                while (tempLine != null) {
                    if (tempLine.startsWith("Change ")) {
                        RE dateRE = new RE("(\\d+)/(\\d+)/(\\d+) (\\d+):(\\d+):(\\d+)");
                        RE userRE = new RE("(\\S+)@");
                        if (userRE.match(tempLine)) {
                            log.debug((Object)("User: " + userRE.getParen(1)));
                            template.userName = userRE.getParen(1);
                            if (dateRE.match(tempLine, userRE.getParenEnd(0))) {
                                log.debug((Object)("Date: " + dateRE.getParen(0)));
                                template.date = PERFORCE_DATE.parse(dateRE.getParen(0));
                            }
                        } else {
                            log.error((Object)"Couldn't find user!");
                        }
                        tempLine = br.readLine();
                        String comment = "";
                        while (tempLine != null && !tempLine.startsWith("Affected files")) {
                            comment = comment + tempLine.trim();
                            tempLine = br.readLine();
                        }
                        log.debug((Object)("Comment: " + comment));
                        template.comment = comment;
                        while (tempLine != null && !tempLine.startsWith("Differences")) {
                            int poundIndex;
                            tempLine = br.readLine();
                            while (tempLine != null && !tempLine.startsWith("...")) {
                                tempLine = br.readLine();
                            }
                            String fileName = "";
                            if (tempLine == null || (poundIndex = tempLine.indexOf("#")) == -1) continue;
                            Revision r = new Revision();
                            r.comment = template.comment;
                            r.date = template.date;
                            r.userName = template.userName;
                            fileName = tempLine.substring(tempLine.indexOf("/"), poundIndex);
                            log.debug((Object)("File: " + fileName));
                            r.fileName = fileName;
                            revisions.put(fileName, r);
                        }
                    } else {
                        log.debug((Object)tempLine);
                    }
                    tempLine = br.readLine();
                }
                Object var21_21 = null;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new RepositoryException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            try {
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (br == null) return revisions.values();
        br.close();
        return revisions.values();
    }

    /*
     * Loose catch block
     */
    public void readWriteSubmitFormFile(String description) throws RepositoryException {
        block22: {
            IOException ioe22;
            BufferedWriter writer;
            BufferedReader reader;
            File formFileOut;
            File formFile;
            block21: {
                formFile = new File(this.localProjectDirName + File.separator + "formFile.txt");
                formFileOut = new File(this.localProjectDirName + File.separator + "formFileOut.txt");
                log.debug((Object)("Writing description for submit to form file: " + formFileOut.getAbsolutePath()));
                if (!formFile.isFile()) {
                    throw new RepositoryException("Form file for submit doesn't exist: " + formFile.getAbsolutePath());
                }
                if (!formFileOut.exists()) {
                    try {
                        if (!formFileOut.createNewFile()) {
                            log.error((Object)("Unable to create form file out! " + formFileOut.getAbsolutePath()));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                        throw new RepositoryException(e);
                    }
                }
                reader = null;
                writer = null;
                reader = new BufferedReader(new FileReader(formFile));
                writer = new BufferedWriter(new FileWriter(formFileOut));
                String tempLine = reader.readLine();
                while (tempLine != null) {
                    if (tempLine.startsWith("Description:")) {
                        writer.write(tempLine);
                        writer.newLine();
                        tempLine = reader.readLine();
                        writer.write("\t" + description);
                        writer.newLine();
                    } else {
                        writer.write(tempLine);
                        writer.newLine();
                    }
                    tempLine = reader.readLine();
                }
                Object var8_9 = null;
                if (reader == null) break block21;
                try {
                    reader.close();
                }
                catch (IOException ioe22) {
                    log.error((Object)("Form file for submit not closed: " + formFile.getAbsolutePath()));
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    log.error((Object)("Form file for submit not closed: " + formFileOut.getAbsolutePath()));
                }
            }
            break block22;
            {
                catch (Exception e) {
                    log.error((Object)e);
                    throw new RepositoryException(e);
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var8_10 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        log.error((Object)("Form file for submit not closed: " + formFile.getAbsolutePath()));
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        log.error((Object)("Form file for submit not closed: " + formFileOut.getAbsolutePath()));
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void readWriteLabelFormFile() throws RepositoryException {
        block23: {
            IOException ioe22;
            BufferedWriter writer;
            BufferedReader reader;
            File formFileOut;
            File formFile;
            block22: {
                formFile = new File(this.localProjectDirName + File.separator + "formFile.txt");
                formFileOut = new File(this.localProjectDirName + File.separator + "formFileOut.txt");
                log.debug((Object)("Writing description for label to form file: " + formFileOut.getAbsolutePath()));
                if (!formFile.isFile()) {
                    throw new RepositoryException("Form file for label doesn't exist: " + formFile.getAbsolutePath());
                }
                if (!formFileOut.exists()) {
                    try {
                        if (!formFileOut.createNewFile()) {
                            log.error((Object)("Unable to create form file out! " + formFileOut.getAbsolutePath()));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                        throw new RepositoryException(e);
                    }
                }
                reader = null;
                writer = null;
                reader = new BufferedReader(new FileReader(formFile));
                writer = new BufferedWriter(new FileWriter(formFileOut));
                String tempLine = reader.readLine();
                while (tempLine != null) {
                    if (tempLine.startsWith("View:")) {
                        writer.write(tempLine);
                        writer.newLine();
                        String view = this.project.getProperties().getProperty(VIEW_KEY);
                        if (view != null && view.length() > 0) {
                            writer.write("\t" + view);
                            writer.newLine();
                            break;
                        }
                        for (int i = 0; i < this.depotViewList.size(); ++i) {
                            writer.write("\t" + (String)this.depotViewList.get(i));
                            writer.newLine();
                        }
                        break;
                    }
                    writer.write(tempLine);
                    writer.newLine();
                    tempLine = reader.readLine();
                }
                Object var9_10 = null;
                if (reader == null) break block22;
                try {
                    reader.close();
                }
                catch (IOException ioe22) {
                    log.error((Object)("Form file for label not closed: " + formFile.getAbsolutePath()));
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    log.error((Object)("Form file for label not closed: " + formFileOut.getAbsolutePath()));
                }
            }
            break block23;
            {
                catch (Exception e) {
                    log.error((Object)e);
                    throw new RepositoryException(e);
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var9_11 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        log.error((Object)("Form file for label not closed: " + formFile.getAbsolutePath()));
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        log.error((Object)("Form file for label not closed: " + formFileOut.getAbsolutePath()));
                    }
                }
                throw throwable;
            }
        }
    }

    public void deleteTempFiles() throws RepositoryException {
        try {
            File tempFormFile = new File(this.localProjectDirName + File.separator + "formFile.txt");
            File tempOutFile = new File(this.localProjectDirName + File.separator + "formFileOut.txt");
            if (tempFormFile.exists()) {
                log.debug((Object)"Found temporary form file...attempting to delete.");
                if (tempFormFile.delete()) {
                    log.debug((Object)"Successfully removed temporary form file.");
                } else {
                    log.error((Object)("Unable to delete temporaroy form file: " + tempFormFile.getAbsolutePath()));
                }
            } else {
                log.debug((Object)("Unable to find temporory file: " + tempFormFile.getAbsolutePath()));
            }
            if (tempOutFile.exists()) {
                log.debug((Object)"Found out file");
                if (tempOutFile.delete()) {
                    log.debug((Object)"Successfully removed out file");
                } else {
                    log.error((Object)("Unable to remove out file: " + tempOutFile.getAbsolutePath()));
                }
            } else {
                log.debug((Object)("Unable to find temporary file: " + tempOutFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new RepositoryException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

