/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.adapter.RepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.util.FileRemover;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.anthill.util.PageletFactoryMaker;
import com.urbancode.pagelet.Pagelet;
import com.urbancode.pagelet.PageletFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.execute.Execute;
import org.apache.commons.execute.ExecuteException;
import org.apache.log4j.Logger;

public abstract class ProfileRepositoryAdapter
implements RepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$ProfileRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$ProfileRepositoryAdapter = ProfileRepositoryAdapter.class$("com.urbancode.anthill.adapter.ProfileRepositoryAdapter")) : class$com$urbancode$anthill$adapter$ProfileRepositoryAdapter).getName());
    protected static final String IN_DATE_KEY = "profile.in.date.format";
    protected static final String OUT_DATE_KEY = "profile.out.date.format";
    protected static final String CHECKOUT_LOCATION_KEY = "profile.checkout.location";
    protected static final String COMMENT_KEY = "profile.comment";
    protected static final String WORKING_PROJECT_PAGELET = "getWorkingProject.pgl";
    protected static final String POST_FILE_EDIT_PAGELET = "postEditPagelet.pgl";
    protected static final String PRE_FILE_EDIT_PAGELET = "preEditPagelet.pgl";
    protected static final String LABEL_PAGELET = "label.pgl";
    public static final String WINDOWS_OS = "Win32";
    public static final String UNIX_OS = "Unix";
    public static final String ANTHILL_ROOT_DIR_KEY = "anthill.root.dir";
    public static final String PROFILE_KEY = "repository.profile";
    protected static String pageletWorkDirName = System.getProperty("pagelet.work");
    protected static PageletFactory pageletFactory = null;
    protected AnthillProject project = null;
    protected String profileDirName = null;
    protected String branchName = null;
    protected String workDirName = null;
    protected String localProjectDirName = null;
    protected String moduleName = null;
    protected String repositoryRoot = null;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$ProfileRepositoryAdapter;

    protected static PageletFactory getPageletFactory() {
        if (pageletFactory == null) {
            pageletFactory = ProfileRepositoryAdapter.createPageletFactory();
        }
        return pageletFactory;
    }

    protected static PageletFactory createPageletFactory() {
        String userOS = System.getProperty("os.name");
        String pageletRootDirName = "conf" + File.separator + "profiles";
        return PageletFactoryMaker.create(pageletRootDirName);
    }

    public void init(AnthillProject p) throws RepositoryException {
        this.project = p;
        try {
            String userOS;
            String adapterFolder = "";
            String adapterSuffix = this.getAdapterSuffix();
            if (adapterSuffix == null || adapterSuffix.equals("")) {
                log.error((Object)"No adapter suffix specified!  Please include getAdapterSuffix() method in your adapter implementation");
            }
            if ((userOS = System.getProperty("os.name")).indexOf("Windows") != -1) {
                userOS = WINDOWS_OS;
                adapterFolder = "win_" + adapterSuffix;
            } else {
                userOS = UNIX_OS;
                adapterFolder = "unix_" + adapterSuffix;
            }
            this.profileDirName = userOS + File.separator + adapterFolder;
            this.calculateRepositoryProperties();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RepositoryException(t.getMessage(), t);
        }
    }

    public abstract String getAdapterSuffix();

    protected void calculateRepositoryProperties() throws RepositoryException {
        log.debug((Object)"In ProfileRepositoryAdapter calculateRepositoryProperties!");
    }

    protected void calculateWorkDirName(String workDirKey) throws RepositoryException {
        Anthill anthill = null;
        try {
            anthill = Anthill.getAnthill();
        }
        catch (Exception e) {
            log.error((Object)("ANTHILL SINGLETON" + e.getMessage().toString()));
        }
        String tempWorkDir = this.project.getProperties().getProperty(workDirKey);
        this.workDirName = FileUtils.isAbsolutePath(tempWorkDir) ? tempWorkDir : anthill.getAnthillRootDir().getAbsolutePath() + File.separator + tempWorkDir;
        log.debug((Object)("WorkDirName after: " + this.workDirName));
        if (this.workDirName == null) {
            throw new RepositoryException("work dir property not set");
        }
        if (this.workDirName.endsWith(File.separator)) {
            this.workDirName = this.workDirName.substring(0, this.workDirName.length() - 1);
        }
        if (this.branchName != null) {
            this.workDirName = this.workDirName + File.separator + this.branchName;
        }
        this.workDirName = FileUtils.getOSDependentPath(this.workDirName);
        log.debug((Object)("workDirName in calculateWorkDirName: " + this.workDirName));
    }

    protected void calculateLocalProjectDirName(String moduleKey) throws RepositoryException {
        log.debug((Object)"calculateLocalProjectDirName(moduleKey)");
        if (this.workDirName == null || this.workDirName.equals("")) {
            throw new RepositoryException("Work directory hasn't been set!");
        }
        String moduleName = this.project.getProperties().getProperty(moduleKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Module: " + moduleName));
        }
        this.localProjectDirName = this.workDirName + File.separator + moduleName;
        this.localProjectDirName = FileUtils.getOSDependentPath(this.localProjectDirName);
        File tempFile = new File(this.localProjectDirName);
        this.localProjectDirName = tempFile.getAbsolutePath();
        log.debug((Object)("localProjectDirName: " + this.localProjectDirName));
    }

    protected void calculateBranchName(String branchKey) {
        if (this.project.getProperties() == null) {
            log.info((Object)"Project properties is null in calculateBranchName!");
        }
        this.branchName = this.project.getProperties().getProperty(branchKey);
        if (this.branchName == null || this.branchName.equals("")) {
            this.branchName = null;
        }
    }

    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        log.debug((Object)("Getting working copy of project: " + this.project.getProjectName()));
        if (this.branchName != null && !this.branchName.equals("")) {
            log.debug((Object)("Retrieving branch: " + this.branchName));
        }
        try {
            Pagelet pagelet;
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            if (def.getVersionedBuildFlag()) {
                log.info((Object)("Retrieving project version " + def.getVersion()));
                tempMap.put("Version", def.getVersion().trim());
            }
            if ((pagelet = ProfileRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(WORKING_PROJECT_PAGELET))) != null) {
                log.debug((Object)"Have checkout pagelet.");
            } else {
                log.debug((Object)"Pagelet is null in checkout!");
            }
            String commandString = pagelet.service(tempMap);
            log.debug((Object)("Checkout Command: " + commandString));
            this.executeCommand(commandString, "checkout");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Checkout failed: " + e.getMessage(), e);
        }
    }

    public void revert() throws RepositoryException {
        try {
            log.info((Object)"Cleaning up local files: ");
            if (!log.isDebugEnabled()) {
                File file = new File(this.getLocalProjectDirName());
                FileRemover.removeFile(file);
            }
        }
        catch (Exception e) {
            throw new RepositoryException("revert failed", e);
        }
    }

    public void postFileEdit(String file, String msg) throws RepositoryException {
        file = FileUtils.getOSDependentPath(file);
        log.info((Object)("Post file edit on file: " + file));
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("File", file);
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("msg", msg);
            Pagelet pagelet = ProfileRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(POST_FILE_EDIT_PAGELET));
            this.executeCommand(pagelet.service(tempMap), "unlock");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("unlock failed: " + e.getMessage(), e);
        }
    }

    public void prepareFileForEdit(String file) throws RepositoryException {
        file = FileUtils.getOSDependentPath(file);
        log.info((Object)("Preparing file: " + file + " for editing."));
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("File", file);
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            Pagelet pagelet = ProfileRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(PRE_FILE_EDIT_PAGELET));
            this.executeCommand(pagelet.service(tempMap), "prepareForEdit");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("preparing file: " + file + " failed: " + e.getMessage(), e);
        }
    }

    public void label(String tag) throws RepositoryException {
        if (tag == null || tag.length() == 0) {
            throw new RepositoryException("No label specified");
        }
        tag = tag.replace('$', '_').replace(',', '_').replace('.', '_').replace(':', '_').replace(';', '_').replace('@', '_').replace(' ', '_');
        log.info((Object)("Tagging entire project with label: " + tag));
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("Adapter", this);
            tempMap.put("Tag", tag);
            tempMap.put("Properties", this.project.getProperties());
            Pagelet pagelet = ProfileRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(LABEL_PAGELET));
            this.executeCommand(pagelet.service(tempMap), "Label");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Label failed: " + e.getMessage(), e);
        }
    }

    public List getRevisionsSince(Date date) throws RepositoryException {
        return null;
    }

    public String getLocalProjectDirName() {
        return this.localProjectDirName;
    }

    protected void executeCommand(String command, String name) throws RepositoryException {
        int exitCode = 0;
        try {
            exitCode = this.executeCommand(this.toArray(command));
            if (exitCode != 0) {
                throw new RepositoryException("ProfileAdapter " + name + " failed: " + exitCode);
            }
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    protected int executeCommand(String[] commandArgs) throws IOException, ExecuteException {
        log.info((Object)("Executing Command: " + this.doStringArray2String(commandArgs)));
        Execute exe = new Execute();
        exe.setCommandline(commandArgs);
        exe.setLogger(log);
        return exe.execute();
    }

    protected String[] toArray(String commandString) throws Exception {
        String userOS = System.getProperty("os.name");
        if (commandString == null || commandString.length() == 0) {
            return new String[0];
        }
        commandString = commandString.replace('\t', ' ').replace('\f', ' ').replace('\r', ' ').replace('\n', ' ').trim();
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(commandString, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        if (!WINDOWS_OS.equals(userOS)) continue block4;
                        current.append(nextTok);
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        if (!WINDOWS_OS.equals(userOS)) continue block4;
                        current.append(nextTok);
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                if (WINDOWS_OS.equals(userOS)) {
                    current.append(nextTok);
                }
            } else if ("\"".equals(nextTok)) {
                state = 2;
                if (WINDOWS_OS.equals(userOS)) {
                    current.append(nextTok);
                }
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new Exception("unbalanced quotes in " + commandString);
        }
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            itr.remove();
        }
        String[] args = new String[list.size()];
        args = list.toArray(args);
        return args;
    }

    public String makeTagFromVersion(String version) {
        return version;
    }

    protected String makeProfilePageletName(String pglName) {
        return this.profileDirName + File.separator + pglName;
    }

    protected String doStringArray2String(String[] array) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < array.length; ++i) {
            if (first) {
                first = false;
            } else {
                result.append(" ");
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

