/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.VersionAdapter;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class ProjectPropertyFileVersionAdapter
extends VersionAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$ProjectPropertyFileVersionAdapter == null ? (class$com$urbancode$anthill$adapter$ProjectPropertyFileVersionAdapter = ProjectPropertyFileVersionAdapter.class$("com.urbancode.anthill.adapter.ProjectPropertyFileVersionAdapter")) : class$com$urbancode$anthill$adapter$ProjectPropertyFileVersionAdapter).getName());
    public static final String VERSION_NUMBER_PROP_KEY = "version";
    public static final String REPOSITORY_ADAPTER_KEY = "repository.adapter";
    private static final int PREFIX = 1;
    private static final int DIGIT = 2;
    private static final int POSTFIX = 3;
    protected String versionFile = null;
    protected ProjectProperties properties = null;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$ProjectPropertyFileVersionAdapter;

    protected void setAnthillProject(AnthillProject project) {
        this.project = project;
        this.properties = project.getProperties();
    }

    public String incrementVersion() throws Exception {
        String raName = this.project.getProperties().getProperty(REPOSITORY_ADAPTER_KEY);
        log.debug((Object)("Repository Adapter: " + raName));
        String branch = null;
        try {
            Field branchField = Class.forName(raName).getField("BRANCH_KEY");
            String branchPropertyName = branchField.get(null).toString();
            branch = this.project.getProperties().getProperty(branchPropertyName);
            log.info((Object)("Branch from the repository adapter: " + branch));
        }
        catch (Exception e) {
            log.debug((Object)"No branch field defined...skipping check for branch name in version string");
        }
        String versionStr = "1.0.0";
        versionStr = this.properties.getProperty(VERSION_NUMBER_PROP_KEY);
        String newVersionStr = null;
        log.info((Object)("Incrementing version: " + versionStr));
        if (branch != null && versionStr.indexOf(branch) == -1) {
            throw new IllegalStateException("Version string is illegal.  It does not contain the Branch name. versionStr: " + versionStr);
        }
        newVersionStr = this.incrementVersion0(versionStr);
        this.properties.setProperty(VERSION_NUMBER_PROP_KEY, newVersionStr);
        return newVersionStr;
    }

    public String getCurrentVersion() throws Exception {
        String versionStr = this.properties.getProperty(VERSION_NUMBER_PROP_KEY);
        return versionStr;
    }

    public void setCurrentVersion(String newVersion) throws Exception {
        log.info((Object)("setting version: " + newVersion));
        this.properties.setProperty(VERSION_NUMBER_PROP_KEY, newVersion);
    }

    protected String incrementVersion0(String versionStr) {
        StringBuffer prefix = new StringBuffer();
        StringBuffer digits = new StringBuffer();
        StringBuffer postfix = new StringBuffer();
        int state = 3;
        for (int i = versionStr.length() - 1; i >= 0; --i) {
            char c = versionStr.charAt(i);
            if (!Character.isDigit(c)) {
                if (state == 3) {
                    postfix.insert(0, c);
                    continue;
                }
                if (state == 2) {
                    state = 1;
                }
                prefix.insert(0, c);
                continue;
            }
            if (state == 3 || state == 2) {
                state = 2;
                digits.insert(0, c);
                continue;
            }
            prefix.insert(0, c);
        }
        int build = 0;
        try {
            build = Integer.parseInt(digits.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Version String illegal. Can't parse build number. versionStr: " + versionStr);
        }
        String newVersionStr = prefix.toString() + String.valueOf(++build) + postfix.toString();
        return newVersionStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

