/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.FileUtils;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StarTeamRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter = StarTeamRepositoryAdapter.class$("com.urbancode.anthill.adapter.StarTeamRepositoryAdapter")) : class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter).getName());
    private static Logger streamLog = Logger.getLogger((String)((class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter = StarTeamRepositoryAdapter.class$("com.urbancode.anthill.adapter.StarTeamRepositoryAdapter")) : class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter).getName() + "Stream"));
    private final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    private final String ADAPTER_SUFFIX = "starteam";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss a z");
    private final String FOLDER_KEY = "Folder: ";
    private final String FILE_KEY = "History for: ";
    private final String REVISION_START_KEY = "----------------------------";
    private final String REVISION_SECTION_END_KEY = "=============================================================================";
    private final String AUTHOR_KEY = "Author: ";
    private final String DATE_KEY = "Date: ";
    private final String REVISION_KEY = "Branch Revision: ";
    private final String WORKING_DIR_KEY = "(working dir:";
    public static final String CONNECT_KEY = "repository.starteam.access";
    public static final String WORK_DIR_KEY = "repository.starteam.work.dir";
    public static final String PASSWD_FILE_KEY = "repository.starteam.passwd.file";
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$StarTeamRepositoryAdapter;

    public String getAdapterSuffix() {
        return "starteam";
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        this.calculateWorkDirName(WORK_DIR_KEY);
        this.calculateLocalProjectDirName();
    }

    public void calculateLocalProjectDirName() {
        this.localProjectDirName = this.workDirName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        BufferedReader br;
        ArrayList revList;
        block12: {
            String connectString = this.project.getProperties().getProperty(CONNECT_KEY);
            revList = new ArrayList();
            Thread errStream = null;
            br = null;
            int exitCode = -1;
            try {
                try {
                    Runtime rt = Runtime.getRuntime();
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    tempMap.put("Adapter", this);
                    tempMap.put("Properties", this.project.getProperties());
                    tempMap.put("Date", date);
                    Pagelet pagelet = StarTeamRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("getRevisionsSince.pgl"));
                    String command = pagelet.service(tempMap);
                    Process p = rt.exec(this.toArray(command));
                    errStream = new StreamPumper(p.getErrorStream(), "err", System.err, true);
                    errStream.start();
                    br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    this.parseHistory(br, revList, date);
                    exitCode = p.waitFor();
                    if (exitCode != 0) {
                        throw new RepositoryException("Error getting revisions!Exit code: " + exitCode);
                    }
                    Object var13_13 = null;
                    if (errStream == null) break block12;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RepositoryException("get revisions since failed: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (errStream != null) {
                    try {
                        errStream.join();
                    }
                    catch (Exception se) {
                        se.printStackTrace();
                        throw new RepositoryException("get revisions since failed: " + se.getMessage());
                    }
                }
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RepositoryException("get revisions since failed: " + e.getMessage());
                }
            }
            try {}
            catch (Exception se) {
                se.printStackTrace();
                throw new RepositoryException("get revisions since failed: " + se.getMessage());
            }
            errStream.join();
        }
        try {}
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("get revisions since failed: " + e.getMessage());
        }
        br.close();
        return revList;
    }

    public List parseHistory(BufferedReader br, List revList, Date date) throws Exception {
        String fileName = "";
        Object rev = null;
        try {
            String tempLine = br.readLine();
            while (tempLine != null) {
                if (tempLine.startsWith("Folder: ")) {
                    revList = this.getFileRevisions(br, revList, this.getFolder(tempLine), date);
                } else if (tempLine.startsWith("History for: ")) {
                    fileName = tempLine.substring("History for: ".length(), tempLine.length());
                    log.debug((Object)("Processing file up top: " + fileName));
                    this.getFileRevision(br, fileName, revList, date);
                }
                if (tempLine == null) continue;
                tempLine = br.readLine();
            }
            log.debug((Object)"Done parsing log");
            log.debug((Object)("Found " + revList.size() + " revisions"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("get revisions since failed: " + e.getMessage());
        }
        return revList;
    }

    public String getFolder(String folderString) {
        int index = folderString.indexOf("(working dir:");
        String tempFolder = folderString.substring(index + "(working dir:".length(), folderString.length() - 1);
        return tempFolder;
    }

    public List getFileRevisions(BufferedReader br, List revList, String folder, Date date) throws Exception {
        String fileName = "";
        try {
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.equals("=============================================================================")) {
                if (tempLine.startsWith("History for: ")) {
                    fileName = tempLine.substring("History for: ".length(), tempLine.length());
                    this.getFileRevision(br, folder + File.separator + fileName, revList, date);
                } else if (tempLine.startsWith("Folder: ")) {
                    folder = this.getFolder(tempLine);
                }
                tempLine = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("get revisions since failed: " + e.getMessage());
        }
        return revList;
    }

    public void getFileRevision(BufferedReader br, String file, List revList, Date date) throws Exception {
        Anthill anthill = null;
        try {
            anthill = Anthill.getAnthill();
        }
        catch (Exception e) {
            log.error((Object)("ANTHILL SINGLETON" + e.getMessage().toString()));
        }
        Revision rev = null;
        try {
            String tempLine = br.readLine();
            while (tempLine != null && !tempLine.equals("=============================================================================")) {
                if (tempLine.equals("----------------------------")) {
                    rev = new Revision();
                    rev.fileName = file;
                    tempLine = br.readLine();
                    tempLine = br.readLine();
                    int dateStartIndex = tempLine.indexOf("Date: ");
                    rev.userName = tempLine.substring("Author: ".length(), dateStartIndex);
                    rev.date = this.dateFormat.parse(tempLine.substring(dateStartIndex + "Date: ".length(), tempLine.length()));
                    tempLine = br.readLine();
                    String comment = "";
                    if (tempLine.equals("=============================================================================") || tempLine.equals("----------------------------") || tempLine.trim().equals("")) {
                        rev.comment = "empty comment";
                    } else {
                        while (!(tempLine == null || tempLine.trim().equals("") || tempLine.equals("----------------------------") || tempLine.equals("============================================================================="))) {
                            comment = comment + tempLine;
                            tempLine = br.readLine();
                        }
                        rev.comment = comment;
                    }
                    if (!rev.date.after(date)) continue;
                    String anthillRootDirName = anthill.getAnthillRootDir().getAbsolutePath();
                    String tempVerFile = anthillRootDirName + File.separator;
                    tempVerFile = tempVerFile + this.project.getProperties().getProperty(WORK_DIR_KEY);
                    tempVerFile = tempVerFile + File.separator + this.project.getProperties().getProperty("version.file");
                    tempVerFile = FileUtils.getOSDependentPath(tempVerFile);
                    if (file.trim().equalsIgnoreCase(tempVerFile.trim())) {
                        log.debug((Object)"not adding revision to version file!");
                        continue;
                    }
                    revList.add(rev);
                    continue;
                }
                tempLine = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException("get revisions since failed: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

