/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.adapter.ChangesetRevision;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SubversionRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter = SubversionRepositoryAdapter.class$("com.urbancode.anthill.adapter.SubversionRepositoryAdapter")) : class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter).getName());
    private static Logger streamLog = Logger.getLogger((String)((class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter = SubversionRepositoryAdapter.class$("com.urbancode.anthill.adapter.SubversionRepositoryAdapter")) : class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter).getName() + "Stream"));
    public static final String ADAPTER_SUFFIX = "subversion";
    protected static final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    protected static final String COMMAND_INIT = "getCommandInit.pgl";
    public static final String WORK_DIR_KEY = "repository.subversion.work.dir";
    public static final String URL_KEY = "repository.subversion.url";
    public static final String TAGS_URL_KEY = "repository.subversion.tags.url";
    public static final String USER_KEY = "repository.subversion.anthill.user";
    public static final String PASSWORD_KEY = "repository.subversion.anthill.password";
    public static final String BUILD_INCREMENT_COMMENT = "Anthill: Increment build number";
    public static String SUBVERSION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss ZZZZZ";
    public static String SUBVERSION_DATE_FORMAT_PRE1_4 = "yyyy-MM-dd HH:mm:ss";
    public static SimpleDateFormat SUBVERSION_DATE;
    private static final String REV_DELIM_TOKEN = "------------------------------------------------------------------------";
    private static final String NEW_LINE;
    protected String buildRevision;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$SubversionRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        this.calculateWorkDirName(WORK_DIR_KEY);
        this.localProjectDirName = this.workDirName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        int exitcode;
        block11: {
            super.getWorkingProjectCopy(def);
            log.debug((Object)("Getting working copy of project: " + this.project.getProjectName()));
            Process p = null;
            Thread errorPumper = null;
            exitcode = 0;
            try {
                try {
                    Pagelet pagelet;
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    tempMap.put("Adapter", this);
                    tempMap.put("Properties", this.project.getProperties());
                    if (def.getVersionedBuildFlag()) {
                        log.info((Object)("Retrieving project version " + def.getVersion()));
                        tempMap.put("Version", def.getVersion().trim());
                    }
                    if ((pagelet = SubversionRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("getWorkingProject.pgl"))) != null) {
                        log.debug((Object)"Have checkout pagelet.");
                    } else {
                        log.debug((Object)"Pagelet is null in checkout!");
                    }
                    String commandString = pagelet.service(tempMap);
                    log.debug((Object)("Checkout Command: " + commandString));
                    p = Runtime.getRuntime().exec(this.toArray(commandString));
                    errorPumper = new StreamPumper(p.getErrorStream(), "getRevisions", System.err, true);
                    errorPumper.start();
                    this.parseCheckoutCommandResult(p.getInputStream());
                    exitcode = p.waitFor();
                }
                catch (RepositoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RepositoryException("Checkout failed: " + e.getMessage(), e);
                }
                Object var9_10 = null;
                if (errorPumper == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (errorPumper == null) throw throwable;
                try {
                    errorPumper.join();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new RepositoryException(e);
                }
            }
            try {}
            catch (InterruptedException e) {
                throw new RepositoryException(e);
            }
            errorPumper.join();
        }
        if (exitcode == 0) return;
        throw new RepositoryException("svn checkout failed.  Exit code: " + exitcode);
    }

    protected void parseCheckoutCommandResult(InputStream in) throws IOException, RepositoryException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        RE checkedOutRE = null;
        String lastLine = null;
        String line = br.readLine();
        while (line != null) {
            lastLine = line;
            line = br.readLine();
        }
        try {
            checkedOutRE = new RE("(\\d+)");
        }
        catch (RESyntaxException rse) {
            log.error((Object)rse);
            throw new RepositoryException(rse);
        }
        if (!checkedOutRE.match(lastLine)) {
            log.error((Object)("No revision number in last line of checkout" + lastLine));
            throw new RepositoryException("No revision number in " + lastLine);
        }
        this.buildRevision = checkedOutRE.getParen(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        ArrayList revisionList;
        int exitcode;
        block8: {
            Process p = null;
            Thread errorPumper = null;
            exitcode = 0;
            revisionList = new ArrayList();
            try {
                try {
                    HashMap<String, Object> tempMap = new HashMap<String, Object>();
                    tempMap.put("Adapter", this);
                    tempMap.put("Properties", this.project.getProperties());
                    tempMap.put("Date", date);
                    Pagelet pagelet = SubversionRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(GET_REVISIONS_SINCE_PAGELET));
                    String commandString = pagelet.service(tempMap);
                    log.debug((Object)("Get revisions since command: " + commandString));
                    p = Runtime.getRuntime().exec(this.toArray(commandString));
                    errorPumper = new StreamPumper(p.getErrorStream(), "getRevisions", System.err, true);
                    errorPumper.start();
                    InputStream input = p.getInputStream();
                    this.parseLogCommandResult(input, revisionList, date);
                    exitcode = p.waitFor();
                }
                catch (Exception e) {
                    log.error((Object)(e.getMessage() + " thrown in new catch"));
                    e.printStackTrace();
                    throw new RepositoryException(e.getMessage());
                }
                Object var11_11 = null;
                if (errorPumper == null) break block8;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (errorPumper == null) throw throwable;
                try {
                    errorPumper.join();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new RepositoryException(e);
                }
            }
            try {}
            catch (InterruptedException e) {
                throw new RepositoryException(e);
            }
            errorPumper.join();
        }
        if (exitcode != 0) {
            throw new RepositoryException("svn log failed.  Exit code: " + exitcode);
        }
        log.debug((Object)"returning revisionList");
        return revisionList;
    }

    protected void parseLogCommandResult(InputStream in, List revList, Date firstDate) throws IOException, RepositoryException {
        boolean PARSE_REV_START = true;
        int PARSE_REV_FILELIST = 2;
        int PARSE_REV_COMMENT = 3;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ChangesetRevision rev = null;
        StringBuffer comment = new StringBuffer();
        RE headerRE = null;
        RE fileRE = null;
        int parseState = 1;
        try {
            headerRE = new RE("^r(\\d+) \\| (\\S+) \\| ([^\\(]+)");
            fileRE = new RE("^   ([ADMR]) [/\\\\](\\S+)");
        }
        catch (RESyntaxException rse) {
            log.error((Object)rse);
            throw new RepositoryException(rse);
        }
        String line = br.readLine();
        while (line != null) {
            switch (parseState) {
                case 1: {
                    if (!headerRE.match(line)) break;
                    try {
                        String revId = headerRE.getParen(1);
                        String user = headerRE.getParen(2);
                        Date date = SUBVERSION_DATE.parse(headerRE.getParen(3));
                        rev = new ChangesetRevision("Revision " + revId, user, date);
                        log.debug((Object)("RevID: " + revId));
                        log.debug((Object)("User: " + user));
                        log.debug((Object)("Date: " + rev.date));
                    }
                    catch (ParseException pe) {
                        log.warn((Object)pe);
                    }
                    parseState = 2;
                    break;
                }
                case 2: {
                    if (fileRE.match(line)) {
                        char ftype = fileRE.getParen(1).charAt(0);
                        log.debug((Object)("Change Char Found: " + ftype));
                        Revision fileRevision = new Revision();
                        fileRevision.fileName = fileRE.getParen(2);
                        switch (ftype) {
                            case 'A': {
                                rev.addAddedFile(fileRevision);
                                break;
                            }
                            case 'D': {
                                rev.addDeletedFile(fileRevision);
                                break;
                            }
                            case 'M': {
                                rev.addModifiedFile(fileRevision);
                                break;
                            }
                            case 'R': {
                                rev.addReplacedFile(fileRevision);
                            }
                        }
                        break;
                    }
                    if (line.trim().length() != 0) break;
                    parseState = 3;
                    break;
                }
                case 3: {
                    if (line.startsWith(REV_DELIM_TOKEN)) {
                        if (!(rev == null || firstDate != null && rev.date != null && rev.date.before(firstDate) || comment.toString().lastIndexOf(BUILD_INCREMENT_COMMENT) >= 0)) {
                            rev.comment = comment.toString();
                            revList.add(rev);
                        }
                        comment.setLength(0);
                        rev = null;
                        parseState = 1;
                        break;
                    }
                    comment.append(line);
                    comment.append(NEW_LINE);
                }
            }
            line = br.readLine();
        }
    }

    public void prepareFileForEdit(String file) throws RepositoryException {
    }

    public void label(String tag) throws RepositoryException {
        if (tag == null || tag.length() == 0) {
            throw new RepositoryException("No label specified");
        }
        tag = tag.replace('$', '_').replace(',', '_').replace('.', '_').replace(':', '_').replace(';', '_').replace('@', '_');
        log.info((Object)("Tagging entire project with label: " + tag));
        try {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("Adapter", this);
            tempMap.put("Tag", tag);
            tempMap.put("BuildRevision", this.buildRevision);
            Pagelet pagelet = SubversionRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName("label.pgl"));
            this.executeCommand(pagelet.service(tempMap), "Label");
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Label failed: " + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NEW_LINE = System.getProperty("line.separator");
        String javaver = System.getProperty("java.version");
        char major = javaver.charAt(0);
        char dot = javaver.charAt(1);
        char minor = javaver.charAt(2);
        String fmt = SUBVERSION_DATE_FORMAT;
        if (major == '1' && dot == '.' && minor <= '3') {
            fmt = SUBVERSION_DATE_FORMAT_PRE1_4;
        }
        SUBVERSION_DATE = new SimpleDateFormat(fmt);
    }
}

