/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.RepositoryAdapter;
import com.urbancode.anthill.adapter.VersionAdapter;
import com.urbancode.anthill.adapter.VersionModifier;
import com.urbancode.anthill.util.FileUtils;
import java.io.File;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class UrbanCodeVersionAdapter
extends VersionAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$UrbanCodeVersionAdapter == null ? (class$com$urbancode$anthill$adapter$UrbanCodeVersionAdapter = UrbanCodeVersionAdapter.class$("com.urbancode.anthill.adapter.UrbanCodeVersionAdapter")) : class$com$urbancode$anthill$adapter$UrbanCodeVersionAdapter).getName());
    public static final String VERSION_FILE_KEY = "version.file";
    public static final String REPOSITORY_ADAPTER_KEY = "repository.adapter";
    private static final int PREFIX = 1;
    private static final int DIGIT = 2;
    private static final int POSTFIX = 3;
    protected String versionFile = null;
    protected ProjectProperties properties = null;
    protected RepositoryAdapter repositoryAdapter = null;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$UrbanCodeVersionAdapter;

    protected void setAnthillProject(AnthillProject project) {
        this.project = project;
        this.properties = project.getProperties();
        this.repositoryAdapter = this.properties.getRepositoryAdapter();
        this.calculateVersionFile();
    }

    protected void calculateVersionFile() {
        String localVersionFilePath = this.project.getRepositoryAdapter().getLocalProjectDirName() + File.separator + this.properties.getProperty(VERSION_FILE_KEY);
        localVersionFilePath = FileUtils.getOSDependentPath(localVersionFilePath);
        this.versionFile = new File(localVersionFilePath).getAbsolutePath();
        log.debug((Object)("Version file calculated as: " + this.versionFile));
    }

    public String incrementVersion() throws Exception {
        log.debug((Object)"increment version in urbancode version adapter");
        String raName = this.project.getProperties().getProperty(REPOSITORY_ADAPTER_KEY);
        log.debug((Object)("Repository Adapter: " + raName));
        String branch = null;
        try {
            Field branchField = Class.forName(raName).getField("BRANCH_KEY");
            String branchPropertyName = branchField.get(null).toString();
            branch = this.project.getProperties().getProperty(branchPropertyName);
            log.info((Object)("Branch from the repository adapter: " + branch));
        }
        catch (Exception e) {
            log.debug((Object)"No branch field defined...skipping check for branch name in version string");
        }
        if (this.versionFile == null) {
            throw new IllegalStateException("no version file set.");
        }
        File f = new File(this.versionFile);
        log.info((Object)("Incrementing version file: " + f.getAbsolutePath()));
        VersionModifier modifier = new VersionModifier(f);
        String versionStr = modifier.readVersionStr();
        String newVersionStr = null;
        if (branch != null && versionStr.indexOf(branch) == -1) {
            throw new IllegalStateException("Version string is illegal.  It does not contain the Branch name. versionStr: " + versionStr);
        }
        this.doPreVersionFileModify();
        newVersionStr = this.incrementVersion0(versionStr);
        modifier.writeVersionStr(newVersionStr);
        this.doPostVersionFileModify();
        f = null;
        modifier = null;
        return newVersionStr;
    }

    public String getCurrentVersion() throws Exception {
        if (this.versionFile == null) {
            throw new IllegalStateException("no version file set.");
        }
        File f = new File(this.versionFile);
        log.info((Object)("getting version file: " + f.getPath()));
        VersionModifier modifier = new VersionModifier(f);
        String versionStr = modifier.readVersionStr();
        return versionStr;
    }

    public void setCurrentVersion(String newVersion) throws Exception {
        if (this.versionFile == null) {
            throw new IllegalStateException("no version file set.");
        }
        File f = new File(this.versionFile);
        log.info((Object)("setting version file: " + f.getPath()));
        this.doPreVersionFileModify();
        VersionModifier modifier = new VersionModifier(f);
        modifier.writeVersionStr(newVersion);
        this.doPostVersionFileModify();
    }

    protected String incrementVersion0(String versionStr) {
        StringBuffer prefix = new StringBuffer();
        StringBuffer digits = new StringBuffer();
        StringBuffer postfix = new StringBuffer();
        int state = 3;
        for (int i = versionStr.length() - 1; i >= 0; --i) {
            char c = versionStr.charAt(i);
            if (!Character.isDigit(c)) {
                if (state == 3) {
                    postfix.insert(0, c);
                    continue;
                }
                if (state == 2) {
                    state = 1;
                }
                prefix.insert(0, c);
                continue;
            }
            if (state == 3 || state == 2) {
                state = 2;
                digits.insert(0, c);
                continue;
            }
            prefix.insert(0, c);
        }
        int build = 0;
        try {
            build = Integer.parseInt(digits.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Version String illegal. Can't parse build number. versionStr: " + versionStr);
        }
        String newVersionStr = prefix.toString();
        if (++build < 10) {
            for (int i = 1; i < digits.length(); ++i) {
                newVersionStr = newVersionStr + "0";
            }
        }
        newVersionStr = newVersionStr + String.valueOf(build);
        newVersionStr = newVersionStr + postfix.toString();
        return newVersionStr;
    }

    protected void doPreVersionFileModify() throws Exception {
        this.repositoryAdapter.prepareFileForEdit(this.properties.getProperty(VERSION_FILE_KEY));
    }

    protected void doPostVersionFileModify() throws Exception {
        this.repositoryAdapter.postFileEdit(this.properties.getProperty(VERSION_FILE_KEY), "Committed_by_Anthill");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

