/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.BuildDefinition;
import com.urbancode.anthill.ProjectProperties;
import com.urbancode.anthill.adapter.ProfileRepositoryAdapter;
import com.urbancode.anthill.adapter.RepositoryException;
import com.urbancode.anthill.adapter.Revision;
import com.urbancode.anthill.util.StreamPumper;
import com.urbancode.pagelet.Pagelet;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.execute.Execute;
import org.apache.log4j.Logger;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.ReaderCharacterIterator;

public class VSSRepositoryAdapter
extends ProfileRepositoryAdapter {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$VSSRepositoryAdapter == null ? (class$com$urbancode$anthill$adapter$VSSRepositoryAdapter = VSSRepositoryAdapter.class$("com.urbancode.anthill.adapter.VSSRepositoryAdapter")) : class$com$urbancode$anthill$adapter$VSSRepositoryAdapter).getName());
    public static final String ADAPTER_SUFFIX = "vss";
    protected static final String GET_REVISIONS_SINCE_PAGELET = "getRevisionsSince.pgl";
    public static final String MODULE_KEY = "repository.vss.module";
    public static final String ROOT_KEY = "repository.vss.root";
    public static final String BRANCH_KEY = "repository.vss.branch";
    public static final String WORK_DIR_KEY = "repository.vss.work.dir";
    public static final String VSS_USER_KEY = "repository.vss.anthill.user";
    public static final String VSS_PASSWD_KEY = "repository.vss.user.password";
    public static final String VSS_HOME_KEY = "repository.vss.home";
    public static final String VSS_DATE_FORMAT_KEY = "repository.vss.dateFormat";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy;hh:mma";
    private String vssRoot;
    private String vssUser;
    private String vssPass;
    private String vssWorkDir;
    private String vssModule;
    private String vssBranch;
    private String vssHome;
    private String vssDateFormat;
    private SimpleDateFormat VSS_IN_DATE = null;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$VSSRepositoryAdapter;

    public String getAdapterSuffix() {
        return ADAPTER_SUFFIX;
    }

    protected void calculateRepositoryProperties() throws RepositoryException {
        try {
            ProjectProperties pp = this.project.getProperties();
            this.vssRoot = pp.getProperty(ROOT_KEY);
            this.vssUser = pp.getProperty(VSS_USER_KEY);
            this.vssPass = pp.getProperty(VSS_PASSWD_KEY);
            this.vssWorkDir = pp.getProperty(WORK_DIR_KEY);
            this.vssModule = pp.getProperty(MODULE_KEY);
            this.vssBranch = pp.getProperty(BRANCH_KEY);
            this.vssHome = pp.getProperty(VSS_HOME_KEY);
            this.vssDateFormat = pp.getProperty(VSS_DATE_FORMAT_KEY);
            if (this.vssDateFormat == null || this.vssDateFormat.trim().length() == 0) {
                this.vssDateFormat = DEFAULT_DATE_FORMAT;
            }
            this.VSS_IN_DATE = new SimpleDateFormat(this.vssDateFormat);
            this.calculateBranchName(BRANCH_KEY);
            this.calculateWorkDirName(WORK_DIR_KEY);
            this.calculateLocalProjectDirName(MODULE_KEY);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public void getWorkingProjectCopy(BuildDefinition def) throws RepositoryException {
        File f = new File(this.localProjectDirName.trim());
        if (!f.exists()) {
            if (f.mkdirs()) {
                log.info((Object)("Successfully made local project directory: " + f.getAbsolutePath()));
            } else {
                log.info((Object)("Error creating local project directory: " + f.getAbsolutePath()));
            }
        }
        super.getWorkingProjectCopy(def);
    }

    /*
     * Loose catch block
     */
    public List getRevisionsSince(Date date) throws RepositoryException {
        ArrayList revList;
        block22: {
            log.debug((Object)("Retrieving revisions since: " + date + " for project: " + this.project.getProjectName()));
            revList = new ArrayList();
            String dateString = this.VSS_IN_DATE.format(date);
            String currentDate = this.VSS_IN_DATE.format(new Date());
            if (dateString.toUpperCase().endsWith("M")) {
                dateString = dateString.substring(0, dateString.length() - 1);
                currentDate = currentDate.substring(0, currentDate.length() - 1);
            }
            String command = "";
            int exitCode = -1;
            Thread err = null;
            BufferedReader br = null;
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("Adapter", this);
            tempMap.put("Properties", this.project.getProperties());
            tempMap.put("CurrentDate", currentDate);
            tempMap.put("DateString", dateString);
            Pagelet pagelet = VSSRepositoryAdapter.getPageletFactory().getPagelet(this.makeProfilePageletName(GET_REVISIONS_SINCE_PAGELET));
            command = pagelet.service(tempMap);
            log.info((Object)("get revisions since command: " + command));
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(this.toArray(command));
            err = new StreamPumper(p.getErrorStream(), "testerr", System.err, true);
            err.start();
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            ReaderCharacterIterator rci = new ReaderCharacterIterator((Reader)br);
            RE labelRE = new RE("(\\*{22})[:space:]+", 4);
            RE checkinRE = new RE("\\*{5}(\\s+\\S+\\s+)\\*{5}", 4);
            RE otherRE = new RE("\\*{17}(\\s+)Version (\\d+)(\\s+)\\*{17}", 4);
            RE checkinRevisionRE = new RE("([^*]+)(\\*{1,4})([^*]+)|([^*]+)");
            RE catchAllRE = new RE("((\\*{22}[^*])|(\\*{5}(\\s+)(\\S+)(\\s+)\\*{5})|(\\*{17}(\\s+)Version (\\d+)(\\s+)\\*{17}))");
            boolean matches = true;
            int index = 0;
            while (matches) {
                if (catchAllRE.match((CharacterIterator)rci, index)) {
                    String fileName = null;
                    if (checkinRE.match(catchAllRE.getParen(0))) {
                        fileName = checkinRE.getParen(1);
                    }
                    index = this.readRevision(rci, catchAllRE.getParenEnd(0), checkinRevisionRE, fileName, revList);
                } else {
                    log.debug((Object)"Doesn't match label, checkin, or other...");
                    index = -1;
                }
                matches = index != -1;
            }
            exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new RepositoryException("Exception when getting revisions.");
            }
            Object var23_24 = null;
            try {
                if (err != null) {
                    err.join();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (br != null) {
                    br.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (RepositoryException re) {
                    throw re;
                }
                catch (Exception e) {
                    log.error((Object)("Error in getRevisionsSince: " + e.getMessage()));
                    e.printStackTrace();
                    throw new RepositoryException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var23_25 = null;
                try {
                    if (err != null) {
                        err.join();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return revList;
    }

    public int readRevision(ReaderCharacterIterator rci, int index, RE r, String fileName, List revList) {
        try {
            if (!r.match((CharacterIterator)rci, index)) {
                log.debug((Object)"Couldn't match the actual revision");
                return index;
            }
            this.getInformation(r.getParen(0), fileName, revList);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return r.getParenEnd(0);
    }

    public void getInformation(String revision, String fileName, List revList) {
        boolean addRevision = true;
        try {
            Revision rev = new Revision();
            RE versionRE = new RE("Version ([:digit:]+)");
            RE labelRE = new RE("Label: ([^\\n]+)\\n");
            RE userRE = new RE("User: (\\S+)");
            RE dateRE = new RE("Date:\\s+(\\S+)");
            RE timeRE = new RE("Time:\\s+(\\S+)");
            RE vssCommentRE = new RE("(\\S+[^\\n]+)\\n");
            RE userCommentRE = new RE("((Comment: )|(comment: ))\\S+(([^\\n]+)\\n)+");
            int index = 0;
            if (versionRE.match(revision)) {
                log.debug((Object)("***Version: " + versionRE.getParen(1)));
                index = versionRE.getParenEnd(0);
            } else if (labelRE.match(revision)) {
                log.debug((Object)("***Label: " + labelRE.getParen(1) + " (WOULD IGNORE THIS WHOLE REVISION)"));
                index = labelRE.getParenEnd(0);
                addRevision = false;
            } else {
                log.debug((Object)"***Didn't find label or version!***");
            }
            if (userRE.match(revision, index)) {
                log.debug((Object)("User: " + userRE.getParen(1)));
                index = userRE.getParenEnd(0);
                rev.userName = userRE.getParen(1);
                if (dateRE.match(revision, userRE.getParenEnd(0))) {
                    log.debug((Object)("Date: " + dateRE.getParen(1)));
                    index = dateRE.getParenEnd(0);
                    if (timeRE.match(revision, dateRE.getParenEnd(0))) {
                        log.debug((Object)("Time: " + timeRE.getParen(1)));
                        index = timeRE.getParenEnd(0);
                        rev.date = this.VSS_IN_DATE.parse(dateRE.getParen(1) + ";" + timeRE.getParen(1) + "m");
                    } else {
                        log.error((Object)"ERROR! Time not found!");
                    }
                } else {
                    log.error((Object)"ERROR!  Date not found!");
                }
            } else {
                log.error((Object)"Couldn't find the user tag!");
            }
            if (vssCommentRE.match(revision, index)) {
                log.debug((Object)("VSS Comment: " + vssCommentRE.getParen(1)));
                if (this.needRevision(vssCommentRE.getParen(1))) {
                    if (fileName != null) {
                        String versionFile = this.project.getProperties().getProperty("version.file");
                        if (versionFile != null && versionFile.trim().length() > 0) {
                            log.info((Object)("Version File name: " + versionFile));
                            versionFile = versionFile.substring(versionFile.lastIndexOf(File.separator) + 1, versionFile.length());
                            log.debug((Object)("File sent: " + fileName + ", Version file in getInfo: " + versionFile));
                            if (fileName.trim().equals(versionFile.trim())) {
                                addRevision = false;
                            }
                        }
                        rev.fileName = fileName;
                        log.debug((Object)("File sent: " + fileName));
                    }
                } else {
                    addRevision = false;
                }
                if (userCommentRE.match(revision, vssCommentRE.getParenEnd(0))) {
                    log.debug((Object)("User comment: " + userCommentRE.getParen(0)));
                    rev.comment = userCommentRE.getParen(0);
                }
            } else {
                log.debug((Object)"Didn't find vss comment!");
            }
            if (addRevision) {
                log.debug((Object)("Adding revision!: " + rev));
                revList.add(rev);
            } else {
                log.debug((Object)"Revision is not supposed to be added");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    private boolean needRevision(String comment) {
        String[] commands = new String[]{"Checked", "Created", "added", "deleted", "moved", "merged", "renamed"};
        for (int i = 0; i < commands.length; ++i) {
            if (comment.indexOf(commands[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private String getWholePath(String relativePath) {
        try {
            File f = new File(relativePath);
            log.debug((Object)("Sent: " + relativePath + ", whole path: " + f.getAbsolutePath()));
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return relativePath;
        }
    }

    private String getVssPath(String path) {
        if (path.indexOf("\\") != -1) {
            return path.replace('\\', '/');
        }
        return path;
    }

    protected int executeCommand(String command) throws RepositoryException {
        String[] envVars = new String[]{"SSDIR=" + this.vssRoot, "SSUSER=" + this.vssUser, "PATH=" + this.vssHome};
        log.info((Object)("Running VSS Command:" + command));
        try {
            Execute exe = new Execute();
            exe.setCommandline(this.toArray(command));
            exe.setLogger(log);
            exe.setEnvironment(envVars);
            return exe.execute();
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public String getModuleName() {
        if (this.branchName != null && !this.branchName.equals("")) {
            return this.branchName;
        }
        return this.vssModule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

