/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import com.urbancode.anthill.adapter.VersionReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class VersionModifier {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$adapter$VersionModifier == null ? (class$com$urbancode$anthill$adapter$VersionModifier = VersionModifier.class$("com.urbancode.anthill.adapter.VersionModifier")) : class$com$urbancode$anthill$adapter$VersionModifier).getName());
    private File versionFile = null;
    static /* synthetic */ Class class$com$urbancode$anthill$adapter$VersionModifier;

    public VersionModifier(String versionFileName) {
        this(new File(versionFileName));
        if (versionFileName == null) {
            throw new IllegalArgumentException("VersionFileName parameter can't be null.");
        }
    }

    public VersionModifier(File versionFile) {
        this.versionFile = versionFile;
        if (versionFile == null) {
            throw new IllegalArgumentException("VersionFile parameter can't be null.");
        }
        if (!versionFile.exists()) {
            throw new IllegalArgumentException("VersionFile parameter must point to a file that exists");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readVersionStr() {
        String versionStr = null;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(this.versionFile);
                versionStr = VersionReader.readVersionStr(fin);
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalStateException("VersionFile does not exist. file: " + this.versionFile.getPath());
            }
            Object var5_3 = null;
            if (fin == null) return versionStr;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fin == null) throw throwable;
            try {
                fin.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        fin.close();
        return versionStr;
    }

    public String readSpecVersion() {
        return this.readVersionFile(true);
    }

    public String readImplVersion() {
        return this.readVersionFile(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readVersionFile(boolean specVersion) {
        BufferedReader br = null;
        String versionString = null;
        try {
            try {
                br = new BufferedReader(new FileReader(this.versionFile));
                versionString = specVersion ? VersionReader.readSpecVersion(br) : VersionReader.readImplVersion(br);
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalStateException("Version File does not exist. file: " + this.versionFile.getPath());
            }
            Object var6_4 = null;
            if (br == null) return versionString;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        br.close();
        return versionString;
    }

    public void updateImplVersion(String implVersion) {
        if (implVersion == null) {
            throw new IllegalArgumentException("Implementation version can't be null.");
        }
        String tempSpecVersion = this.readSpecVersion();
        if (tempSpecVersion == null) {
            throw new IllegalArgumentException("Specification version can't be null.");
        }
        this.writeVersionStrings(tempSpecVersion, implVersion);
    }

    public void updateVersionStrings(String specVersion, String implVersion) throws IOException {
        if (specVersion == null) {
            throw new IllegalArgumentException("Specification version can't be null.");
        }
        if (implVersion == null) {
            throw new IllegalArgumentException("Implementation version can't be null.");
        }
        this.writeVersionStrings(specVersion, implVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeVersionStrings(String specVersion, String implVersion) {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(this.versionFile));
                bw.write(specVersion);
                bw.newLine();
                bw.write(implVersion);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Trouble updating version file.");
            }
            Object var6_4 = null;
            if (bw == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (bw == null) throw throwable;
            try {
                bw.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        bw.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeVersionStr(String versionStr) throws IOException {
        if (versionStr == null) {
            throw new IllegalArgumentException("VersionStr parameter can't be null.");
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.versionFile);
            writer.write(versionStr);
            Object var4_3 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (Exception e) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

