/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.adapter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;

public class VersionReader {
    public static String readVersionStr(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("InpuStream parameter can't be null.");
        }
        String versionStr = null;
        byte[] buf = new byte[128];
        int length = 0;
        String temp = null;
        StringBuffer versionBuf = new StringBuffer();
        try {
            while ((length = is.read(buf)) > 0) {
                temp = new String(buf, 0, length);
                versionBuf.append(temp);
            }
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        versionStr = versionBuf.toString().trim();
        return versionStr;
    }

    public static String readSpecVersion(BufferedReader br) {
        return VersionReader.readVersionFile(true, br);
    }

    public static String readImplVersion(BufferedReader br) {
        return VersionReader.readVersionFile(false, br);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersionFile(boolean specVersion, BufferedReader br) {
        String versionString = null;
        if (br == null) {
            throw new IllegalArgumentException("BufferedReader parameter can't be null.");
        }
        try {
            try {
                String tempLine = br.readLine();
                if (tempLine != null) {
                    versionString = specVersion ? tempLine.trim() : br.readLine().trim();
                }
                br.close();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Version file does not include valid version information.");
            }
            Object var5_5 = null;
            if (br == null) return versionString;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        br.close();
        return versionString;
    }
}

