/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.util;

import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class FileUtils {
    static final String ILLEGAL_FILE_CHARS_REG_EX = "[/:?*<>|\"\\ ]";
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$util$FileUtils == null ? (class$com$urbancode$anthill$util$FileUtils = FileUtils.class$("com.urbancode.anthill.util.FileUtils")) : class$com$urbancode$anthill$util$FileUtils).getName());
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;
    static /* synthetic */ Class class$com$urbancode$anthill$util$FileUtils;

    public static File makeProperPath(File root, String path) {
        if (root == null) {
            throw new IllegalArgumentException("Root parameter must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path parameter must not be null.");
        }
        File properPath = null;
        properPath = FileUtils.isAbsolutePath(path) ? new File(path) : new File(root, path);
        return properPath;
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path parameter must not be null.");
        }
        boolean absolute = false;
        if (path.startsWith("/")) {
            absolute = true;
        }
        if (path.indexOf(":\\") > 0) {
            absolute = true;
        }
        return absolute;
    }

    public static String getNameMinusExtension(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        name = name.substring(0, index);
        return name;
    }

    public static String getBytes(File file) {
        return FileUtils.getBytes(file, Locale.getDefault());
    }

    public static String getBytes(File file, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        return format.format(file.length()) + " bytes";
    }

    public static String getKiloBytes(File file) {
        return FileUtils.getKiloBytes(file, Locale.getDefault());
    }

    public static String getKiloBytes(File file, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        double size = file.length();
        return format.format(size / 1024.0) + " KB";
    }

    public static String getMegaBytes(File file) {
        return FileUtils.getMegaBytes(file, Locale.getDefault());
    }

    public static String getMegaBytes(File file, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        double size = file.length();
        return format.format(size / 1048576.0) + " MB";
    }

    public static String getGigaBytes(File file) {
        return FileUtils.getGigaBytes(file, Locale.getDefault());
    }

    public static String getGigaBytes(File file, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        double size = file.length();
        return format.format(size / 1.073741824E9) + " GB";
    }

    public static String getNearestBytes(File file) {
        return FileUtils.getNearestBytes(file, Locale.getDefault());
    }

    public static String getNearestBytes(File file, Locale locale) {
        long size = file.length();
        if ((double)size >= 1.073741824E9) {
            return FileUtils.getGigaBytes(file, locale);
        }
        if ((double)size >= 1048576.0) {
            return FileUtils.getMegaBytes(file, locale);
        }
        if ((double)size >= 1024.0) {
            return FileUtils.getKiloBytes(file, locale);
        }
        return FileUtils.getBytes(file, locale);
    }

    public static String getOSDependentPath(String path) {
        String result = null;
        if (File.separator.equals("/")) {
            result = path.replace('\\', '/');
        } else if (File.separator.equals("\\")) {
            result = path.replace('/', '\\');
        } else {
            log.error((Object)("Unexpected File.separator: " + File.separator));
            result = path;
        }
        return result;
    }

    public static String makeSafeFileName(String fileName) {
        String result = "";
        if (fileName == null) {
            result = fileName;
        } else {
            StringTokenizer t = new StringTokenizer(fileName, ILLEGAL_FILE_CHARS_REG_EX);
            if (t.hasMoreTokens()) {
                result = t.nextToken();
            }
            while (t.hasMoreTokens()) {
                result = result + "_" + t.nextToken();
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

