/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
extends Thread {
    private static final int SIZE = 128;
    private static final int SLEEP_TIME = 50;
    private InputStream is = null;
    private OutputStream os = null;
    private String name = null;
    private boolean verbose = false;
    private boolean isDone = false;

    public StreamPumper(InputStream is, String name, OutputStream os) {
        this(is, name, os, false);
    }

    public StreamPumper(InputStream is, String name, OutputStream os, boolean verbose) {
        this.is = is;
        this.os = os;
        this.name = name != null ? "[" + name + "] " : "";
        this.verbose = verbose;
    }

    public void run() {
        byte[] buf = new byte[128];
        int length = 0;
        String temp = "";
        try {
            while ((length = this.is.read(buf)) > 0) {
                int index;
                if (this.verbose && (index = (temp = temp + new String(buf, 0, length)).lastIndexOf("\n")) != -1) {
                    String line = temp.substring(0, index + 1);
                    temp = temp.substring(index + 1);
                    if (this.os != null) {
                        this.os.write(line.getBytes());
                    }
                }
                try {
                    StreamPumper.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.isDone = true;
                }
            }
            if (this.os != null) {
                this.os.write(temp.getBytes());
            }
        }
        catch (IOException e) {
            this.isDone = true;
        }
        this.isDone = true;
    }

    public boolean isThreadDone() {
        return this.isDone;
    }
}

