/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.anthill.web.admin;

import com.urbancode.anthill.Anthill;
import com.urbancode.anthill.AnthillProject;
import com.urbancode.anthill.web.admin.AnthillBaseServlet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DuplicateProjectServlet
extends AnthillBaseServlet {
    private static Logger log = Logger.getLogger((String)(class$com$urbancode$anthill$web$admin$DuplicateProjectServlet == null ? (class$com$urbancode$anthill$web$admin$DuplicateProjectServlet = DuplicateProjectServlet.class$("com.urbancode.anthill.web.admin.DuplicateProjectServlet")) : class$com$urbancode$anthill$web$admin$DuplicateProjectServlet).getName());
    static /* synthetic */ Class class$com$urbancode$anthill$web$admin$DuplicateProjectServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext context = this.getServletContext();
        Anthill anthill = (Anthill)context.getAttribute("Anthill");
        String sourceProjectName = req.getParameter("ProjectName");
        boolean error = false;
        String errorMessage = null;
        if (sourceProjectName == null) {
            error = true;
            errorMessage = "ProjectName parameter can not be null";
        }
        if (error) {
            req.setAttribute("errorMessage", (Object)errorMessage);
            context.getRequestDispatcher("/errorPage.jsp").forward((ServletRequest)req, (ServletResponse)res);
        } else {
            String sourceFileName = anthill.getAnthillProjectsDir().getAbsolutePath() + File.separator + sourceProjectName + ".anthill";
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                String errMsg = "source project file doesn't exist (filename: " + sourceFileName;
                log.error((Object)errMsg);
                throw new ServletException(errMsg);
            }
            String destFileName = anthill.getAnthillProjectsDir().getAbsolutePath() + File.separator + "_temp" + ".anthill";
            File destFile = new File(destFileName);
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(sourceFile));
                out = new BufferedWriter(new FileWriter(destFile));
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("lastBuildFailDate") != -1 || line.indexOf("lastBuildSucceeded") != -1 || line.indexOf("lastGoodBuildDate") != -1) continue;
                    out.write(line + "\n");
                }
            }
            finally {
                in.close();
                out.close();
            }
            AnthillProject project = anthill.getProject("_temp");
            if (project == null) {
                String errMsg = "Unable to load new project!";
                log.error((Object)errMsg);
                throw new ServletException(errMsg);
            }
            if (!destFile.delete()) {
                String errMsg = "Unable to delete temp file: " + destFileName;
                log.error((Object)errMsg);
                throw new ServletException(errMsg);
            }
            req.setAttribute("Project", (Object)project);
            req.setAttribute("Anthill", (Object)anthill);
            context.getRequestDispatcher("/projectProperties.jsp").forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

