/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.callback;

import com.ericsson.cms.categorymgmt.exception.DuplicateCategoryException;
import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.ericsson.cms.categorymgmt.util.CategoryLicenseProvider;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.TitlePersistException;
import java.util.List;
import org.apache.log4j.Logger;

public class TitlePersistCallback
implements ITitlePersistCallback {
    private static final Logger logger = Logger.getLogger(TitlePersistCallback.class);
    private CategoryLicenseProvider categoryModule = new CategoryLicenseProvider();
    private ICategoryManager categoryManager = this.getCategoryManager();

    public void onBeforePersist(Title title) throws TitlePersistException {
    }

    public void onPersist(Title title) throws TitlePersistException {
        try {
            if (this.categoryModule.isLicensed()) {
                if (title.getStatus() != TitleStatus.DRAFT) {
                    String path = this.getCategoryPath(title);
                    if (path == null || path.trim().length() < 1) {
                        return;
                    }
                    try {
                        this.categoryManager.createCategory(path.trim());
                        logger.debug((Object)("Saved category " + path));
                    }
                    catch (DuplicateCategoryException ex) {
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Could not save category " + path + " from title " + title.getId()), (Throwable)ex);
                    }
                }
            } else {
                logger.error((Object)("Could not save category from title " + title.getId() + ", Category Manager is not licensed"));
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error in obtaining the license for Category Manager " + e.getLocalizedMessage()));
        }
    }

    private String getCategoryPath(Title title) {
        List assets = title.getAssets("TITLE");
        if (assets == null || assets.isEmpty()) {
            return null;
        }
        Asset titleAsset = (Asset)assets.get(0);
        Field field = titleAsset.getField("/Fields/Categories/Category/Text");
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    private ICategoryManager getCategoryManager() {
        String jndiName = "cms/CategoryManager/local";
        return (ICategoryManager)InjectionUtil.injectInstance((String)jndiName, ICategoryManager.class);
    }
}

