/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.title;

import com.tandbergtv.cms.contentmgmt.service.pitch.IPitchScheduleRequestSender;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class PitchScheduleRequestSender
implements IPitchScheduleRequestSender {
    @EJB
    private IAuthorizationService authorizationService;
    private static String PROGRESS_NAME = " - WORK ORDER SCHEDULED";
    private static String PROGRESS_VALUE = "";
    private static String SOURCE_COMPONENT_NAME = "Content Management";
    private static String SOURCE_ENTITY_NAME = "";

    public void sendPitchWorkOrderCreateMessage(long titleId, String trackingSiteExternalId, String queueName, String queuePos, String templateName) {
        try {
            this.sendMessage(String.valueOf(titleId), trackingSiteExternalId, queueName, queuePos, templateName);
            ProgressManager.newInstance().updateStatus(titleId, null, templateName + PROGRESS_NAME, PROGRESS_VALUE, true, SOURCE_COMPONENT_NAME, SOURCE_ENTITY_NAME, this.authorizationService.getUserName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMessage(String titleId, String trackingSiteExternalId, String queueName, String queuePos, String templateName) throws Exception {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0104");
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("_template", "Pitch to Single Receiver");
        message.setCommand(command);
        message.getPayload().putValue("titleId", titleId);
        message.getPayload().putValue("trackingSiteExternalId", trackingSiteExternalId);
        message.getPayload().putValue("queueName", queueName);
        message.getPayload().putValue("queuePosition", queuePos);
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        router.send(new WPCLConverter().convert(message));
    }
}

