/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.service;

import com.ericsson.cms.contractmgmt.service.IInitializeOldScheduleService;
import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.ericsson.mail.ICMEmailNotificationManager;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IContractManagerExpiryTimer;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.ejb.EJB;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="ContractManager:service=com.ericsson.cms.contractmgmt.service.InitializeOldScheduleService")
@Depends(value={"Scheduler:service=com.ericsson.cms.scheduler.quartz.QuartzScheduler"})
public class InitializeOldScheduleService
implements IInitializeOldScheduleService {
    private static final Log log = LogFactory.getLog(InitializeOldScheduleService.class);
    private static final String ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION = "CMEmailNotification_SCHEDULER";
    @EJB
    private IContractManagerExpiryTimer timer;
    @Depends(value={"jboss.j2ee:ear=cms.ear,jar=neptune-2.0.0.515.jar,name=AuthorizationService,service=EJB3"})
    @EJB
    private IScheduler scheduler;
    @EJB
    private ICMEmailNotificationManager oldNotificationManager;
    private static final String CM_LICENSE = "ContractMgrLicense";
    @EJB
    private ILicenseManager neptuneLicenseManager;

    @Override
    public void start() throws SchedulerException {
        log.info((Object)"In initSchedule()");
        if (this.oldNotificationManager.deleteRegisteredEJBTimer()) {
            try {
                List jobs;
                if (this.isLicensed() && (jobs = this.scheduler.getJobsByAssociatedEntityType(ASSOCIATED_ENTITY_TYPE_CMEMAILNOTIFICATION)).size() <= 0) {
                    this.createDefaultJob();
                }
            }
            catch (InvalidLicenseException e) {
                log.error((Object)("Error in obtaining the license for Contract Manager " + e.getLocalizedMessage()));
            }
        }
    }

    private void createDefaultJob() {
        Calendar currentCal = Calendar.getInstance();
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setLenient(true);
        tomorrow.clear();
        tomorrow.set(currentCal.get(1), currentCal.get(2), currentCal.get(5) + 1, 0, 0, 0);
        ScheduleRule scheduleRule = new ScheduleRule();
        scheduleRule.setStartDate(tomorrow.getTime());
        scheduleRule.setType(ScheduleRuleType.EVERY_N_DAYS);
        ArrayList<ScheduleRuleParameter> params = new ArrayList<ScheduleRuleParameter>();
        ScheduleRuleParameter everyDay = new ScheduleRuleParameter();
        everyDay.setOrder(1);
        everyDay.setValue("1");
        params.add(everyDay);
        ScheduleRuleParameter atTime = new ScheduleRuleParameter();
        atTime.setOrder(2);
        atTime.setValue("12:05 am");
        params.add(atTime);
        scheduleRule.setParams(params);
        try {
            log.info((Object)"Calling createUpdateTimer()");
            this.timer.createUpdateTimer(scheduleRule);
            log.info((Object)"Finished Calling createUpdateTimer()");
        }
        catch (Exception e) {
            ContractManagerValidationException cmve = this.findContractManagerValidationException(e);
            if (cmve != null) {
                log.error((Object)("Could not create the Scheduler job: " + cmve.getValidationMessages()));
            } else {
                log.error((Object)("Could not create the Scheduler job: " + e.getLocalizedMessage()));
            }
            log.error((Object)"Could not create the Scheduler job.");
        }
    }

    private ContractManagerValidationException findContractManagerValidationException(Exception e) {
        ContractManagerValidationException result = null;
        if (e instanceof ContractManagerValidationException) {
            result = (ContractManagerValidationException)e;
        } else {
            Throwable current = e;
            while (current.getCause() != null) {
                if (!((current = current.getCause()) instanceof ContractManagerValidationException)) continue;
                result = (ContractManagerValidationException)current;
                break;
            }
        }
        return result;
    }

    private boolean isLicensed() throws InvalidLicenseException {
        String value = this.neptuneLicenseManager.getProperty(CM_LICENSE);
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

