/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.ejb.Contact;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public class ContactsValidator
extends ContractManagerValidator {
    protected static final int CONTACT_NAME_MAX_LENGTH = 50;
    protected static final int CONTACT_EMAIL_MAX_LENGTH = 150;
    protected static final int CONTACT_PHONE_MAX_LENGHT = 18;
    protected static final int CONTACT_PHONE_MIN_LENGHT = 7;

    protected void validateEmail(String email, List<String> validationMessages, ScreenName screenName) {
        if (email != null && !(email = email.trim()).isEmpty()) {
            if (email.length() > 150) {
                Object[] values = new Object[]{email, 150};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.email.length"), values));
            }
            try {
                new InternetAddress(email, true);
            }
            catch (Exception ex) {
                Object[] values = new Object[]{email, screenName};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.email.invalid"), values));
            }
        }
    }

    protected static boolean findDuplicates(String[] arr) {
        HashSet<String> set = new HashSet<String>();
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            if (set.contains(arr[i].trim().toLowerCase())) {
                return true;
            }
            set.add(arr[i].trim().toLowerCase());
        }
        return false;
    }

    protected void validateContact(Set<Contact> contacts, List<Contact> existentContacts, ScreenName screenName) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        Contact[] itr = contacts.toArray(new Contact[contacts.size()]);
        String[] arr = new String[contacts.size()];
        for (int i = 0; i < itr.length; ++i) {
            arr[i] = itr[i].getEmail();
        }
        if (ContactsValidator.findDuplicates(arr)) {
            Object[] values = new Object[]{screenName};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.duplicate.email"), values));
        }
        for (Contact contact : contacts) {
            super.validateRequired(contact.getName(), "Name", "", validationMessages);
            super.validateRequired(contact.getEmail(), "Email", "", validationMessages);
            super.validateNumeric(contact.getWork(), "Phone(Work)", "", validationMessages);
            super.validateNumeric(contact.getOffice(), "Phone(Office)", "", validationMessages);
            super.validateNumeric(contact.getMobile(), "Phone(Mobile)", "", validationMessages);
            this.validateEmail(contact.getEmail(), validationMessages, screenName);
            if (existentContacts == null || !this.validateSameEmail(contact.getEmail(), contact.getIdContact(), existentContacts)) continue;
            Object[] values = new Object[]{contact.getEmail(), screenName};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.email.existent"), values));
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private boolean validateSameEmail(String email, Long id, List<Contact> contacts) {
        if (!contacts.isEmpty()) {
            for (Contact contact : contacts) {
                if (!contact.getEmail().trim().equals(email.trim())) continue;
                if (id != null & contact.getIdContact() != null) {
                    return id.longValue() != contact.getIdContact().longValue();
                }
                if (contact.getIdContact() == null) continue;
                return true;
            }
        }
        return false;
    }
}

