/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.IContractManagerValidator;
import com.ericsson.ejb.Currency;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.Frequency;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.IFieldManager;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class ContractManagerValidator
implements IContractManagerValidator {
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final int MAX_DEFAULT_CHARS = 50;

    protected void validateRequired(Object value, String fieldName, String errorLocation, List<String> validationMessages) {
        if (value == null || value instanceof String && ((String)value).trim().isEmpty()) {
            Object[] values = new Object[]{fieldName, errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.required"), values));
        }
    }

    protected void validatePercentage(BigDecimal value, String fieldName, String errorLocation, List<String> validationMessages) {
        BigDecimal hundred = BigDecimal.valueOf(100L);
        if (value != null && (value.compareTo(BigDecimal.ZERO) < 0 || value.compareTo(hundred) > 0)) {
            Object[] values = new Object[]{fieldName, errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.percentage"), values));
        }
    }

    protected void validatePositiveInteger(Long value, String fieldName, String errorLocation, List<String> validationMessages) {
        if (value != null && value > Integer.MAX_VALUE) {
            Object[] values = new Object[]{fieldName, value, Integer.MAX_VALUE, errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.positiveInteger"), values));
        }
    }

    protected void validateLength(String value, String fieldName, int maxLength, String errorLocation, List<String> validationMessages) {
        if (value != null && value.length() > maxLength) {
            Object[] values = new Object[]{fieldName, errorLocation, maxLength};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.length"), values));
        }
    }

    protected void validateNumeric(String value, String fieldName, String errorLocation, List<String> validationMessages) {
        if (value != null && value.trim().length() > 0 && !value.matches("[0-9]+")) {
            Object[] values = new Object[]{fieldName, errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.numeric"), values));
        }
    }

    protected void validatePositiveValue(BigDecimal value, String fieldName, String errorLocation, List<String> validationMessages) {
        if (value != null && value.signum() == -1) {
            Object[] values = new Object[]{fieldName, errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("contract.manager.numeric.positive"), values));
        }
    }

    protected void validateCustomFields(Set<CustomLicFieldValue> customLicFieldValues, ScreenName screenName, List<String> validationMessages, String errorLocation, IFieldManager fieldManager, EntityManager entityManager) {
        for (CustomLicFieldValue fieldValue : customLicFieldValues) {
            Field field = fieldManager.findById(fieldValue.getField().getIdField().longValue());
            if (field == null || !screenName.equals((Object)field.getScreenName())) continue;
            this.validateCustomField(field, fieldValue.getValue(), validationMessages, errorLocation, entityManager);
        }
    }

    private void validateCustomField(Field field, String value, List<String> validationMessages, String errorLocation, EntityManager entityManager) {
        if (value != null && !value.trim().equals("")) {
            Object[] values;
            Integer order = field.getFieldOrder();
            if (order != null && order < 0) {
                values = new Object[]{field.getName(), Integer.MAX_VALUE, errorLocation};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.order.positive"), values));
            }
            switch (field.getType()) {
                case Date: {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                        sdf.parse(value);
                    }
                    catch (ParseException e) {
                        Object[] values2 = new Object[]{field.getName(), errorLocation};
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.invalid.date"), values2));
                    }
                    break;
                }
                case Alphanumeric: 
                case Text: {
                    if (field.getDropdown().booleanValue()) break;
                    if (field.getMinChars() != null && field.getMinChars() > 0 && value.length() < field.getMinChars()) {
                        values = new Object[]{field.getMinChars(), field.getName(), errorLocation};
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.minimum.character"), values));
                    }
                    if (field.getMaxChars() != null && field.getMaxChars() > 0 && value.length() > field.getMaxChars()) {
                        values = new Object[]{field.getMaxChars(), field.getName(), errorLocation};
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.maximum.character"), values));
                    }
                    if (field.getMaxChars() == null || field.getMaxChars() <= 50) break;
                    values = new Object[]{50, errorLocation};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.maximum.default.character"), values));
                    break;
                }
                case Currency: {
                    Currency currency = null;
                    try {
                        currency = (Currency)entityManager.getReference(Currency.class, (Object)Long.parseLong(value));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (currency != null) break;
                    Object[] values3 = new Object[]{field.getName(), errorLocation};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.invalid.value"), values3));
                    break;
                }
                case Frequency: {
                    Frequency frequency = null;
                    try {
                        frequency = (Frequency)entityManager.getReference(Frequency.class, (Object)Long.parseLong(value));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (frequency != null) break;
                    Object[] values4 = new Object[]{field.getName(), errorLocation};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.invalid.value"), values4));
                    break;
                }
                case Percentage: {
                    Float percentage = null;
                    try {
                        percentage = Float.valueOf(Float.parseFloat(value));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (percentage != null) {
                        if (!(percentage.floatValue() < 0.0f) && !(percentage.floatValue() > 100.0f)) break;
                        Object[] values5 = new Object[]{field.getName(), errorLocation};
                        validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.percentage"), values5));
                        break;
                    }
                    Object[] values6 = new Object[]{field.getName(), errorLocation};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.percentage.value"), values6));
                    break;
                }
                case Number: {
                    Long number = null;
                    try {
                        number = Long.parseLong(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (number != null) break;
                    Object[] values7 = new Object[]{field.getName(), Long.MAX_VALUE, errorLocation, Long.MIN_VALUE};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.number.min.max"), values7));
                }
            }
        } else if (field.getRequired().booleanValue()) {
            Object[] values = new Object[]{field.getName(), errorLocation};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("custom.field.number.required"), values));
        }
    }
}

