/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ContractValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.IDealManagerValidator;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealType;
import com.ericsson.ejb.License;
import com.ericsson.entitymanager.DealManager;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.IFieldManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DealValidator
extends ContractManagerValidator
implements IDealManagerValidator {
    private static final Log log = LogFactory.getLog(ContractValidator.class);
    private static int NAME_MAX_LENGTH = 50;

    @Override
    public void validate(Deal deal, ICMLicenseManager licenseManager, IFieldManager fieldManager, EntityManager entityManager, DealManager dmgr) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (deal == null) {
            validationMessages.add(ValidationMessages.getString("audit.deal.null"));
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateDealFields(deal, validationMessages, fieldManager, licenseManager, entityManager, dmgr);
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateDealFields(Deal deal, List<String> validationMessages, IFieldManager fieldManager, ICMLicenseManager licenseManager, EntityManager entityManager, DealManager dmgr) throws ContractManagerValidationException {
        super.validateRequired(deal.getName(), "Name", "", validationMessages);
        super.validateRequired(deal.getDealType(), "Deal Type", "", validationMessages);
        super.validateRequired(deal.getCreationDate(), "Creation Date", "", validationMessages);
        super.validateRequired(deal.getEffectiveDate(), "Effective Date", "", validationMessages);
        super.validateRequired(deal.getExpiryDate(), "Expiry Date", "", validationMessages);
        super.validateLength(deal.getName(), "Name", NAME_MAX_LENGTH, "", validationMessages);
        if (deal.getLicenseExpiryReminder() != null) {
            super.validateNumeric(deal.getLicenseExpiryReminder().toString(), "License Expiry Reminder", "", validationMessages);
        }
        if (deal.getContract() == null) {
            validationMessages.add(ValidationMessages.getString("deal.CRHValidation"));
        } else {
            Contract contract = null;
            try {
                contract = (Contract)entityManager.getReference(Contract.class, (Object)deal.getContract().getIdContract());
            }
            catch (Exception e) {
                log.debug((Object)("Error on checking Contract for Deal [" + contract.getName() + "] - " + e.getMessage()));
            }
            if (contract == null) {
                Object[] values = new Object[]{deal.getContract().getName(), ""};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("deal.contract.non.existent"), values));
            }
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
        this.validateDates(deal, validationMessages);
        this.validateAgainstLicenseDates(deal, validationMessages, licenseManager);
        this.validateAgainstContractDates(deal, validationMessages, entityManager);
        super.validateCustomFields(deal.getDealCustomLicFieldValues(), ScreenName.DEAL, validationMessages, "", fieldManager, entityManager);
        this.validateDealType(deal.getDealType(), entityManager, validationMessages);
        try {
            Deal d = dmgr.getFullDealByExternalId(deal.getExternalId());
            if (deal.getIdDeal() == null && d != null) {
                validationMessages.add("The save operation failed. Deal External Id '" + deal.getExternalId() + "' already exists.");
                throw new ContractManagerValidationException(validationMessages);
            }
            if (!deal.getName().equals(d.getName()) && deal.getExternalId().equals(d.getExternalId())) {
                validationMessages.add("The save operation failed. Deal External Id '" + deal.getExternalId() + "' already exists.");
                throw new ContractManagerValidationException(validationMessages);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void validateAgainstLicenseDates(Deal deal, List<String> validationMessages, ICMLicenseManager licenseManager) {
        if (deal.getIdDeal() != null) {
            for (License license : licenseManager.findByDealId(deal.getIdDeal())) {
                Object[] values;
                if (license.getCreationDate().before(deal.getCreationDate())) {
                    values = new Object[]{deal.getCreationDate(), ""};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("deal.licenseDate"), values));
                    continue;
                }
                if (license.getEffectiveDate().before(deal.getEffectiveDate())) {
                    values = new Object[]{deal.getEffectiveDate(), ""};
                    validationMessages.add(MessageFormat.format(ValidationMessages.getString("deal.effectiveDate"), values));
                    continue;
                }
                if (!license.getExpiryDate().after(deal.getExpiryDate())) continue;
                values = new Object[]{deal.getExpiryDate(), ""};
                validationMessages.add(MessageFormat.format(ValidationMessages.getString("deal.expiryDate"), values));
            }
        }
    }

    private void validateAgainstContractDates(Deal deal, List<String> validationMessages, EntityManager entityManager) {
        Contract contract = deal.getContract();
        if (deal.getCreationDate().before(contract.getCreationDate())) {
            validationMessages.add(ValidationMessages.getString("deal.contract.creationDateValidation"));
        }
        if (deal.getEffectiveDate().before(contract.getEffectiveDate()) || deal.getEffectiveDate().after(contract.getExpiryDate()) || deal.getEffectiveDate().equals(contract.getExpiryDate())) {
            validationMessages.add(ValidationMessages.getString("deal.contract.effectiveDateValidation"));
        }
        if (deal.getExpiryDate().after(contract.getExpiryDate())) {
            validationMessages.add(ValidationMessages.getString("deal.contract.expiryDateValidation"));
        }
    }

    private void validateDates(Deal deal, List<String> validationMessages) {
        if (deal.getCreationDate().after(deal.getEffectiveDate())) {
            validationMessages.add(ValidationMessages.getString("deal.CreationDateValidation"));
        }
        if (deal.getEffectiveDate().after(deal.getExpiryDate())) {
            validationMessages.add(ValidationMessages.getString("deal.effectiveDateValidation"));
        }
    }

    private void validateDealType(DealType type, EntityManager entityManager, List<String> validationMessages) {
        DealType dealType = null;
        try {
            dealType = (DealType)entityManager.getReference(DealType.class, (Object)type.getIdType());
        }
        catch (Exception e) {
            log.error((Object)("DealType reference error: " + e.getMessage()));
        }
        if (dealType == null) {
            Object[] values = new Object[]{type.getType()};
            validationMessages.add(MessageFormat.format(ValidationMessages.getString("deal.type.non.existent"), values));
        }
    }
}

