/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.validation;

import com.ericsson.cms.contractmgmt.validation.ContractManagerValidator;
import com.ericsson.cms.contractmgmt.validation.ValidationMessages;
import com.ericsson.cms.contractmgmt.validation.interfaces.ILicenseValidator;
import com.ericsson.ejb.DistributionManagement;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.RevenuePricing;
import com.ericsson.entitymanager.CMLicenseManager;
import com.ericsson.enumeration.RevenuePricingType;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IFieldManager;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class LicenseValidator
extends ContractManagerValidator
implements ILicenseValidator {
    private static final String DATE_FORMAT = "MM/dd/yyyy";

    @Override
    public void validate(License license, IFieldManager fieldManager, EntityManager entityManager, CMLicenseManager lmgr) throws ContractManagerValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        this.validateLicenseFields(license, validationMessages, fieldManager, entityManager, lmgr);
        for (LicenseDetails ld : license.getLicenseDetails()) {
            this.validateLicenseDetails(license, ld, validationMessages, fieldManager, entityManager);
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
    }

    private void validateLicenseFields(License license, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager, CMLicenseManager lmgr) throws ContractManagerValidationException {
        if (license.getDeal() == null || license.getDeal().getIdDeal() == null) {
            validationMessages.add(ValidationMessages.getString("license.CRHValidation"));
        }
        this.validateRequired(license.getName(), "Name", "", validationMessages);
        this.validateRequired(license.getLicenseType(), "License Type", "", validationMessages);
        this.validateRequired(license.getCreationDate(), "Creation Date", "", validationMessages);
        this.validateRequired(license.getExpiryDate(), "Expiry Date", "", validationMessages);
        this.validateRequired(license.getEffectiveDate(), "Effective Date", "", validationMessages);
        if (license.getNotes() != null && license.getNotes().length() > 250) {
            validationMessages.add("The notes length should not exceed 250 characters");
        }
        if (!validationMessages.isEmpty()) {
            throw new ContractManagerValidationException(validationMessages);
        }
        if (license.getCreationDate() != null && license.getExpiryDate() != null && license.getEffectiveDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date creationDateNoTime = this.resetTime(license.getCreationDate());
            Date effectiveDateNoTime = this.resetTime(license.getEffectiveDate());
            Date expiryDateNoTime = this.resetTime(license.getExpiryDate());
            Date dealCreationDateNoTime = this.resetTime(license.getDeal().getCreationDate());
            Date dealEffectiveDateNoTime = this.resetTime(license.getDeal().getEffectiveDate());
            Date dealExpiryDateNoTime = this.resetTime(license.getDeal().getExpiryDate());
            if (creationDateNoTime != null && effectiveDateNoTime != null && creationDateNoTime.after(effectiveDateNoTime)) {
                validationMessages.add("The Creation Date should not be after the Effective Date (" + sdf.format(effectiveDateNoTime) + ")");
            }
            if (creationDateNoTime != null && dealCreationDateNoTime != null && creationDateNoTime.before(dealCreationDateNoTime)) {
                validationMessages.add("The Creation Date should not be before the Deal Creation Date (" + sdf.format(dealCreationDateNoTime) + ")");
            }
            if (effectiveDateNoTime != null && dealEffectiveDateNoTime != null && effectiveDateNoTime.before(dealEffectiveDateNoTime)) {
                validationMessages.add("The Effective Date should not be before the Deal Effective Date (" + sdf.format(dealEffectiveDateNoTime) + ")");
            }
            if (expiryDateNoTime != null && effectiveDateNoTime != null && !expiryDateNoTime.after(effectiveDateNoTime)) {
                validationMessages.add("The Expiry Date should be after the Effective Date (" + sdf.format(effectiveDateNoTime) + ")");
            }
            if (expiryDateNoTime != null && dealExpiryDateNoTime != null && expiryDateNoTime.after(dealExpiryDateNoTime)) {
                validationMessages.add("The Expiry Date should not be after the Deal Expiry Date (" + sdf.format(dealExpiryDateNoTime) + ")");
            }
        }
        super.validateCustomFields(license.getLicenseCustomLicFieldValues(), ScreenName.LICENSE, validationMessages, "", fieldManager, entityManager);
        try {
            License l = lmgr.getFullLicenseForIngestByExternalId(license.getExternalId());
            if (license.getIdLicense() == null && l != null) {
                validationMessages.add("The save operation failed. License External Id '" + license.getExternalId() + "' already exists.");
                throw new ContractManagerValidationException(validationMessages);
            }
            if (!license.getName().equals(l.getName()) && license.getExternalId().equals(l.getExternalId())) {
                validationMessages.add("The save operation failed. License External Id '" + license.getExternalId() + "' already exists.");
                throw new ContractManagerValidationException(validationMessages);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void validateLicenseDetails(License license, LicenseDetails ld, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) {
        this.validateStorageMetadataFields(license, ld, validationMessages, fieldManager, entityManager);
        this.validateDistributionFields(license, ld, validationMessages, fieldManager, entityManager);
        this.validateAssetEnhancementFields(ld, validationMessages, fieldManager, entityManager);
        this.validatePricingFields(license, ld, validationMessages, fieldManager, entityManager);
    }

    private void validateStorageMetadataFields(License license, LicenseDetails ld, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) {
        String errorLocation = " for Storage and Metadata";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        if (ld.getLanguages() == null || ld.getLanguages().isEmpty()) {
            validationMessages.add("Language is required" + this.getLocation(ld, errorLocation));
        }
        this.validateRequired(ld.getSmPosterArtRequired(), "Poster Art Required", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getSmPreviewRequired(), "Preview Required", this.getLocation(ld, errorLocation), validationMessages);
        if (ld.getSmEffectiveDate() != null && ld.getSmExpiryDate() != null) {
            Date smEffectiveDateNoTime = this.resetTime(ld.getSmEffectiveDate());
            Date smExpiryDateNoTime = this.resetTime(ld.getSmExpiryDate());
            if (smExpiryDateNoTime != null && smEffectiveDateNoTime != null && smExpiryDateNoTime.before(smEffectiveDateNoTime)) {
                validationMessages.add("The Storage Management License Window End Date should not be before than the Storage Management License Window Start Date (" + sdf.format(smEffectiveDateNoTime) + ")" + this.getLocation(ld, errorLocation));
            }
        }
        Date effectiveDateNoTime = this.resetTime(license.getEffectiveDate());
        Date expiryDateNoTime = this.resetTime(license.getExpiryDate());
        if (ld.getSmEffectiveDate() == null) {
            validationMessages.add("Effective Date is required" + this.getLocation(ld, errorLocation));
        } else if (effectiveDateNoTime != null && expiryDateNoTime != null && (ld.getSmEffectiveDate().before(effectiveDateNoTime) || ld.getSmEffectiveDate().after(expiryDateNoTime))) {
            validationMessages.add("The Storage Management License Window Effective Date must be within the License Effective Date (" + sdf.format(effectiveDateNoTime) + ") and License Expiry Date (" + expiryDateNoTime + ")" + this.getLocation(ld, errorLocation));
        }
        if (ld.getSmExpiryDate() == null) {
            validationMessages.add("Expiry Date is required" + this.getLocation(ld, errorLocation));
        } else {
            Date smExpiryDateNoTime = this.resetTime(ld.getSmExpiryDate());
            if (smExpiryDateNoTime.before(effectiveDateNoTime) || smExpiryDateNoTime.after(expiryDateNoTime)) {
                validationMessages.add("The Storage Management License Window End Date must be within the License Effective Date (" + sdf.format(effectiveDateNoTime) + ") and License Expiry Date (" + expiryDateNoTime + ")" + this.getLocation(ld, errorLocation));
            }
        }
        super.validateCustomFields(ld.getLicenseDetailsCustomLicFieldValues(), ScreenName.STORAGE_METADATA, validationMessages, this.getLocation(ld, errorLocation), fieldManager, entityManager);
    }

    private void validateDistributionFields(License license, LicenseDetails ld, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) {
        String errorLocation = " for Distribution";
        ArrayList distributionManagementList = new ArrayList(ld.getDistributionManagements());
        boolean uniqueViolated = false;
        for (int x = 0; x < distributionManagementList.size(); ++x) {
            DistributionManagement dm1 = (DistributionManagement)distributionManagementList.get(x);
            this.validatePositiveValue(dm1.getDeliveryCost(), "Cost", this.getLocation(ld, errorLocation), validationMessages);
            Long methodKey1 = null;
            if (dm1.getDeliveryMethod() != null) {
                methodKey1 = dm1.getDeliveryMethod().getIdDeliveryMethod();
            }
            Long mediaKey1 = null;
            if (dm1.getMedia() != null) {
                mediaKey1 = dm1.getMedia().getIdMedia();
            }
            String formatKey1 = dm1.getMetadataFormat();
            for (int y = x + 1; y < distributionManagementList.size(); ++y) {
                DistributionManagement dm2 = (DistributionManagement)distributionManagementList.get(y);
                Long methodKey2 = null;
                if (dm2.getDeliveryMethod() != null) {
                    methodKey2 = dm2.getDeliveryMethod().getIdDeliveryMethod();
                }
                Long mediaKey2 = null;
                if (dm2.getMedia() != null) {
                    mediaKey2 = dm2.getMedia().getIdMedia();
                }
                String formatKey2 = dm2.getMetadataFormat();
                if (!this.compareLongs(methodKey1, methodKey2) || !this.compareLongs(mediaKey1, mediaKey2) || !this.compareStrings(formatKey1, formatKey2)) continue;
                uniqueViolated = true;
                break;
            }
            if (uniqueViolated) break;
        }
        if (uniqueViolated) {
            validationMessages.add("The combination of the following fields should be unique: Type of Media, Delivery Method and Meta Format" + this.getLocation(ld, errorLocation));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        for (int x = 0; x < distributionManagementList.size(); ++x) {
            DistributionManagement dm = (DistributionManagement)distributionManagementList.get(x);
            Date deliveryDateNoTime = this.resetTime(dm.getDeliveryDate());
            Date dueDateNoTime = this.resetTime(dm.getDueDate());
            Date returnDateNoTime = this.resetTime(dm.getReturnDate());
            Date effectiveDateNoTime = this.resetTime(license.getEffectiveDate());
            Date expiryDateNoTime = this.resetTime(license.getExpiryDate());
            if (returnDateNoTime != null) {
                if (deliveryDateNoTime == null) {
                    validationMessages.add("Delivery Date is required" + this.getLocation(ld, errorLocation));
                } else if (!deliveryDateNoTime.before(returnDateNoTime)) {
                    validationMessages.add("The Delivery Date has to be earlier than the Return Date (" + sdf.format(returnDateNoTime) + ")" + this.getLocation(ld, errorLocation));
                }
            }
            if (dueDateNoTime != null && deliveryDateNoTime != null && deliveryDateNoTime.before(dueDateNoTime)) {
                validationMessages.add("The Delivery Date cannot be earlier than the Due Date (" + sdf.format(dueDateNoTime) + ")" + this.getLocation(ld, errorLocation));
            }
            this.validateDatesWithin(deliveryDateNoTime, "Delivery Date", effectiveDateNoTime, expiryDateNoTime, x, validationMessages);
            this.validateDatesWithin(dueDateNoTime, "Due Date", effectiveDateNoTime, expiryDateNoTime, x, validationMessages);
            this.validateDatesWithin(returnDateNoTime, "Return Date", effectiveDateNoTime, expiryDateNoTime, x, validationMessages);
        }
        super.validateCustomFields(ld.getLicenseDetailsCustomLicFieldValues(), ScreenName.DISTRIBUTION, validationMessages, this.getLocation(ld, errorLocation), fieldManager, entityManager);
    }

    private void validatePricingFields(License license, LicenseDetails ld, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) {
        Float revenue;
        Float lost;
        Float buyrate;
        String errorLocation = " for Pricing";
        if (ld.getPrGuaranteedBuyRate() != null && ((buyrate = new Float(ld.getPrGuaranteedBuyRate().floatValue())).floatValue() < 0.0f || buyrate.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabBuyRate"));
        }
        if (ld.getPrLostBuys() != null && ((lost = new Float(ld.getPrLostBuys().floatValue())).floatValue() < 0.0f || lost.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabLostBuys"));
        }
        if (ld.getPrRevenueShare() != null && ((revenue = new Float(ld.getPrRevenueShare().floatValue())).floatValue() < 0.0f || revenue.floatValue() > 100.0f)) {
            validationMessages.add(ValidationMessages.getString("license.detail.pricingTabRevenueShare"));
        }
        if (ld.getPrGuaranteedSubscribers() != null) {
            this.validatePositiveInteger(ld.getPrGuaranteedSubscribers(), "Guaranteed Subscribers", this.getLocation(ld, errorLocation), validationMessages);
        }
        this.validatePositiveValue(ld.getPrInstallmentPlan(), "Installment Plan", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrMinimumLicenseFee(), "Minimum License Fee", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrDeemedRetailPrice(), "Deemed Retail Price", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrActualRetailPrice(), "Actual Retail Price", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrActualLicenseFee(), "Actual License Fee", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrUpfrontPayment(), "Upfront Payment", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePositiveValue(ld.getPrOverage(), "Overage amounts", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePercentage(ld.getPrGuaranteedBuyRate(), "Guaranteed Buy Rate", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePercentage(ld.getPrLostBuys(), "Lost Buys", this.getLocation(ld, errorLocation), validationMessages);
        this.validatePercentage(ld.getPrRevenueShare(), "Revenue Share", this.getLocation(ld, errorLocation), validationMessages);
        if (ld.getPrUpfrontPaymentRequired() != null && ld.getPrUpfrontPaymentRequired().booleanValue() && ld.getPrUpfrontPayment() == null) {
            validationMessages.add("The Upfront Payment is required" + errorLocation);
        }
        if (ld.getPrOverageRequired() != null && ld.getPrOverageRequired().booleanValue() && ld.getPrOverage() == null) {
            validationMessages.add("The Overage is required" + errorLocation);
        }
        if (ld.getPrInstallmentPlanRequired() != null && ld.getPrInstallmentPlanRequired().booleanValue() && ld.getPrInstallmentPlan() == null) {
            validationMessages.add("The Installment Plan is required" + errorLocation);
        }
        HashSet<RevenuePricing> tieredPricingSet = new HashSet<RevenuePricing>();
        HashSet<RevenuePricing> revenueShareSet = new HashSet<RevenuePricing>();
        for (RevenuePricing revenuePricing : ld.getRevenuePricings()) {
            if (RevenuePricingType.TP.equals((Object)revenuePricing.getType())) {
                tieredPricingSet.add(revenuePricing);
                continue;
            }
            revenueShareSet.add(revenuePricing);
        }
        this.validateRows(tieredPricingSet, license, ld, validationMessages, "Tiered Pricing", errorLocation);
        this.validateRows(revenueShareSet, license, ld, validationMessages, "Revenue Share", errorLocation);
        super.validateCustomFields(ld.getLicenseDetailsCustomLicFieldValues(), ScreenName.PRICING, validationMessages, this.getLocation(ld, errorLocation), fieldManager, entityManager);
    }

    private void validateRows(Set<RevenuePricing> revenuePricingsSet, License license, LicenseDetails ld, List<String> validationMessages, String revenuePricingType, String errorLocation) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        boolean overlap = false;
        HashSet<RevenuePricing> rpTempSet = new HashSet<RevenuePricing>();
        block0: for (RevenuePricing rp1 : revenuePricingsSet) {
            this.validatePositiveValue(rp1.getThreshold(), "Threshold", this.getLocation(ld, errorLocation), validationMessages);
            this.validatePositiveValue(rp1.getPrice(), "Price", this.getLocation(ld, errorLocation), validationMessages);
            this.validatePositiveValue(rp1.getPenalty(), "Penalty", this.getLocation(ld, errorLocation), validationMessages);
            if (rp1.getIdRevenuePricing() != null) {
                this.validatePositiveValue(new BigDecimal(rp1.getIdRevenuePricing()), "Threshold", this.getLocation(ld, errorLocation), validationMessages);
            }
            rpTempSet.add(rp1);
            if (rp1.getPrice() == null) {
                validationMessages.add("The " + (rp1.getType() == RevenuePricingType.TP ? "price" : "percentage") + " field is required in " + revenuePricingType + " records" + this.getLocation(ld, errorLocation));
            }
            if (rp1.getThreshold() != null && (!rp1.getType().equals((Object)RevenuePricingType.RS) || rp1.getFromDt() == null || rp1.getToDt() == null)) continue;
            Date fromDate1 = this.resetTime(rp1.getFromDt());
            Date toDate1 = this.resetTime(rp1.getToDt());
            if (fromDate1 != null && toDate1 != null) {
                if (fromDate1.after(toDate1)) {
                    validationMessages.add("The From Date (" + sdf.format(fromDate1) + ") should not be after the To Date (" + sdf.format(toDate1) + ") in " + revenuePricingType + " records" + this.getLocation(ld, errorLocation));
                }
                if (license.getEffectiveDate() != null && license.getExpiryDate() != null && rp1.getToDt() != null && rp1.getFromDt() != null) {
                    if (license.getEffectiveDate().after(rp1.getFromDt())) {
                        validationMessages.add("The From Date (" + sdf.format(fromDate1) + ") cannot be earlier than the license Effective date (" + sdf.format(license.getEffectiveDate()) + ")");
                    }
                    if (license.getExpiryDate().before(rp1.getToDt())) {
                        validationMessages.add("The To Date (" + sdf.format(toDate1) + ") should be earlier than the license Expiry date (" + sdf.format(license.getExpiryDate()) + ")");
                    }
                }
                if (overlap) continue;
                for (RevenuePricing rp2 : revenuePricingsSet) {
                    if (rpTempSet.contains(rp2)) continue;
                    Date fromDate2 = this.resetTime(rp2.getFromDt());
                    Date toDate2 = this.resetTime(rp2.getToDt());
                    if (fromDate2 == null || toDate2 == null || (fromDate2.before(fromDate1) || fromDate2.after(toDate1)) && (toDate2.before(fromDate1) || toDate2.after(toDate1))) continue;
                    validationMessages.add("The date ranges should not overlap in " + revenuePricingType + " records" + this.getLocation(ld, errorLocation));
                    overlap = true;
                    continue block0;
                }
                continue;
            }
            validationMessages.add("The Threshold field or the date range should be filled in " + revenuePricingType + " records");
        }
    }

    private void validateAssetEnhancementFields(LicenseDetails ld, List<String> validationMessages, IFieldManager fieldManager, EntityManager entityManager) {
        String errorLocation = " for Asset Enhancement";
        this.validateRequired(ld.getAeAdRemoval(), "Ad Removal Allowed", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeContentEdit(), "Content Edit Allowed", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeContentSecurity(), "Content Security Required", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeFingerprinting(), "Fingerprinting Required", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeQualityCheck(), "Quality Check Required", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeTranscoding(), "Transcoding Required", this.getLocation(ld, errorLocation), validationMessages);
        this.validateRequired(ld.getAeWatermarking(), "Watermarking Required", this.getLocation(ld, errorLocation), validationMessages);
        super.validateCustomFields(ld.getLicenseDetailsCustomLicFieldValues(), ScreenName.ASSET_ENHANCEMENT, validationMessages, this.getLocation(ld, errorLocation), fieldManager, entityManager);
    }

    private void validateDatesWithin(Date date, String field, Date d1, Date d2, int row, List<String> validationMessages) {
        if (date != null && d1 != null && d2 != null && (date.compareTo(d1) < 0 || date.compareTo(d2) > 0)) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            String d1Text = sdf.format(d1);
            String d2Text = sdf.format(d2);
            validationMessages.add("In row " + row + 1 + ", the " + field + " should be within " + d1Text + " and " + d2Text);
        }
    }

    private Date resetTime(Date date) {
        Date resetDate = null;
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            resetDate = cal.getTime();
        }
        return resetDate;
    }

    private String getLocation(LicenseDetails ld, String errorLocation) {
        String location = errorLocation + " ";
        if (ld.getDeliveryLocation() != null) {
            location = location + "(" + ld.getDeliveryLocation();
            if (ld.getPlatform() != null) {
                location = location + "," + ld.getPlatform().getDescription();
                if (ld.getDevice() != null) {
                    location = location + "," + ld.getDevice().getDeviceName();
                }
            }
            location = location + ")";
        } else {
            location = location + "(Default)";
        }
        return location;
    }

    private boolean compareLongs(Long value1, Long value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && (value1 != null && value1.equals(value2) || value2 != null && value2.equals(value1))) {
            isEqual = true;
        }
        return isEqual;
    }

    private boolean compareStrings(String value1, String value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }
        return isEqual;
    }
}

