/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Audit;
import com.ericsson.service.IAuditManager;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IAuditManager.class})
@Stateless
public class AuditManager
implements IAuditManager {
    private static final Log log = LogFactory.getLog(AuditManager.class);
    @EJB
    private IAuthorizationService authorizationService;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public Audit merge(Audit detachedInstance) {
        return null;
    }

    public void persist(Audit transientInstance) {
        log.debug((Object)"persisting Audit instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"Audit persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"Audit persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Audit persistentInstance) {
    }

    public List<Audit> findAuditsByFilter(int start, int length, String sortProperty, boolean isAscending, String userName, Date startDate, Date endDate, Long auditType) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Audit", Audit.class, "audit");
        try {
            SortingOrder sortOrder = SortingOrder.ASCENDING;
            if (!isAscending) {
                sortOrder = SortingOrder.DESCENDING;
            }
            e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
            this.setFilterPArameters(e, userName, startDate, this.addADayToDate(endDate), auditType);
            criteria.addParameter((SearchParameterBase)e);
            criteria.setStartingRecordNumber(start);
            criteria.setRecordsCount(length);
            String s = this.getQuery(criteria);
            Query query = this.entityManager.createQuery(s);
            query.setFirstResult(start);
            query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"find failed", (Throwable)re);
            throw re;
        }
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count(String userName, Date startDate, Date endDate, Long auditType) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Audit", Audit.class, "audit");
        this.setFilterPArameters(e, userName, startDate, this.addADayToDate(endDate), auditType);
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("Audit", Audit.class, "audit");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    public Audit findById(long id) {
        return null;
    }

    public void logAudit(Long auditType, Long auditAction, String auditMessage) {
        Audit audit = new Audit();
        audit.setUserName(this.authorizationService.getUserName());
        audit.setAuditType(auditType);
        audit.setAuditAction(auditAction);
        audit.setCreateDate(Calendar.getInstance().getTime());
        audit.setAuditMessage(auditMessage);
        this.persist(audit);
    }

    private Date addADayToDate(Date day) {
        if (day != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(day);
            c.add(5, 1);
            return c.getTime();
        }
        return null;
    }

    private void setFilterPArameters(Entity e, String userName, Date startDate, Date endDate, Long auditType) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (userName != null && !userName.trim().isEmpty()) {
            e.addParameter((SearchParameterBase)new ValueParameter("userName", SearchType.STRING, (Object)userName));
        }
        if (startDate != null) {
            e.addParameter((SearchParameterBase)new ValueParameter("createDate", SearchType.DATE, (Object)formatter.format(startDate), SearchOperator.GREATERTHANEQUAL));
        }
        if (endDate != null) {
            e.addParameter((SearchParameterBase)new ValueParameter("createDate", SearchType.DATE, (Object)formatter.format(endDate), SearchOperator.LESSTHANEQUAL));
        }
        if (auditType != null) {
            e.addParameter((SearchParameterBase)new ValueParameter("auditType", SearchType.NUMERIC, (Object)auditType));
        }
    }
}

