/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.ContractContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IContractContactsValidator;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.IContractContactsManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IContractContactsManager.class})
@Stateless
public class ContractContactsManager
implements IContractContactsManager {
    private static final Log log = LogFactory.getLog(ContractContactsManager.class);
    private IContractContactsValidator contactsValidator = new ContractContactsValidator();
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(ContractContacts transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting ContractContacts instance");
        try {
            this.validate(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.contact.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(ContractContacts persistentInstance) {
        log.debug((Object)"removing ContractContacts instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.contact.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public ContractContacts merge(ContractContacts detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging ContractContacts instance");
        try {
            this.validate(detachedInstance);
            ContractContacts result = (ContractContacts)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.CONTRACT.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.contract.contact.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public ContractContacts findById(long id) {
        log.debug((Object)("getting ContractContacts instance with id: " + id));
        try {
            ContractContacts instance = (ContractContacts)this.entityManager.find(ContractContacts.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<ContractContacts> findByContract(long contractId) {
        try {
            Query query = this.entityManager.createQuery("SELECT contacts from ContractContacts contacts WHERE contacts.contract.idContract = " + contractId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<ContractContacts> getContractContacts(Long contractKey, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("ContractContacts", ContractContacts.class, "contractContacts");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        e.addParameter((SearchParameterBase)new ValueParameter("contract", SearchType.NUMERIC, (Object)contractKey));
        criteria.addParameter((SearchParameterBase)e);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    private void validate(ContractContacts instance) throws ContractManagerValidationException {
        try {
            HashSet<ContractContacts> contacts = new HashSet<ContractContacts>(0);
            ArrayList<ContractContacts> existentContacts = null;
            if (instance.getContract() != null) {
                existentContacts = new ArrayList<ContractContacts>(this.findByContract(instance.getContract().getIdContract()));
            }
            contacts.add(instance);
            this.contactsValidator.validate(contacts, existentContacts);
        }
        catch (ContractManagerValidationException e) {
            log.error((Object)"ContractContact Validation failed", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"RuntimeException inside ContractContact Validation ", (Throwable)e);
            throw e;
        }
    }
}

