/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.cms.contractmgmt.validation.DealContactsValidator;
import com.ericsson.cms.contractmgmt.validation.interfaces.IDealContactsValidator;
import com.ericsson.ejb.DealContacts;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.IDealContactsManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDealContactsManager.class})
@Stateless
public class DealContactsManager
implements IDealContactsManager {
    private static final Log log = LogFactory.getLog(DealContactsManager.class);
    private IDealContactsValidator contactsValidator = new DealContactsValidator();
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(DealContacts transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting DealContacts instance");
        try {
            this.validate(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getName(), transientInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.contact.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(DealContacts persistentInstance) {
        log.debug((Object)"removing DealContacts instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getName(), persistentInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.contact.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public DealContacts merge(DealContacts detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging DealContacts instance");
        try {
            this.validate(detachedInstance);
            DealContacts result = (DealContacts)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getName(), detachedInstance.getIdContact()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.contact.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public DealContacts findById(long id) {
        log.debug((Object)("getting DealContacts instance with id: " + id));
        try {
            DealContacts instance = (DealContacts)this.entityManager.find(DealContacts.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<DealContacts> findByDeal(long dealId) {
        try {
            Query query = this.entityManager.createQuery("SELECT contacts from DealContacts contacts WHERE contacts.deal.idDeal = " + dealId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<DealContacts> getDealContacts(Long dealKey, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("DealContacts", DealContacts.class, "dealContacts");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        e.addParameter((SearchParameterBase)new ValueParameter("deal", SearchType.NUMERIC, (Object)dealKey));
        criteria.addParameter((SearchParameterBase)e);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        return query.getResultList();
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    private void validate(DealContacts instance) throws ContractManagerValidationException {
        try {
            HashSet<DealContacts> contacts = new HashSet<DealContacts>(0);
            ArrayList<DealContacts> existentContacts = null;
            if (instance.getDeal() != null) {
                existentContacts = new ArrayList<DealContacts>(this.findByDeal(instance.getDeal().getIdDeal()));
            }
            contacts.add(instance);
            this.contactsValidator.validate(contacts, existentContacts);
        }
        catch (ContractManagerValidationException e) {
            log.error((Object)"DealContact Validation failed", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"RuntimeException inside DealContact Validation ", (Throwable)e);
            throw e;
        }
    }
}

