/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.audit.AuditMessages;
import com.ericsson.ejb.DealDocuments;
import com.ericsson.enumeration.AuditAction;
import com.ericsson.enumeration.AuditType;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.IDealDocumentsManager;
import java.text.MessageFormat;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDealDocumentsManager.class})
@Stateless
public class DealDocumentsManager
implements IDealDocumentsManager {
    private static final Log log = LogFactory.getLog(DealDocumentsManager.class);
    @EJB
    private IAuditManager auditManager;
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(DealDocuments transientInstance) {
        log.debug((Object)"persisting DealDocuments instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            this.entityManager.flush();
            log.debug((Object)"persist successful");
            Object[] values = new Object[]{transientInstance.getFileName(), transientInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.CREATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.document.create"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(DealDocuments persistentInstance) {
        log.debug((Object)"removing DealDocuments instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            Object[] values = new Object[]{persistentInstance.getFileName(), persistentInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.DELETE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.document.delete"), values));
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public DealDocuments merge(DealDocuments detachedInstance) {
        log.debug((Object)"merging DealDocuments instance");
        try {
            DealDocuments result = (DealDocuments)this.entityManager.merge((Object)detachedInstance);
            this.entityManager.flush();
            log.debug((Object)"merge successful");
            Object[] values = new Object[]{detachedInstance.getFileName(), detachedInstance.getIdDocument()};
            this.auditManager.logAudit(AuditType.DEAL.getValue(), AuditAction.UPDATE.getValue(), MessageFormat.format(AuditMessages.getString("audit.deal.document.update"), values));
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public DealDocuments findById(long id) {
        log.debug((Object)("getting DealDocuments instance with id: " + id));
        try {
            DealDocuments instance = (DealDocuments)this.entityManager.find(DealDocuments.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<DealDocuments> findByDeal(long dealId) {
        try {
            Query query = this.entityManager.createQuery("SELECT docs from DealDocuments docs WHERE docs.deal.idDeal = " + dealId);
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

